(ns burningswell.web.ui.spot-card
  (:require [burningswell.web.ui.image :refer [image]]
            [burningswell.web.ui.links :as link-to]
            [burningswell.web.util :as util]
            [hal.core :as hal]
            [rum.core :as rum]
            [rum.mdl :as mdl]))

(rum/defc spot-headline < rum/static
  "Render the spot headline."
  [system spot]
  (when spot
    [:div.spot-headline
     [:h6.spot-headline__name
      [:img.spot-headline__country-flag
       {:src (util/country-flag-url (hal/embedded spot :country))}]
      (link-to/spot system spot)]
     [:div.spot-headline__location
      (mdl/icon {:class "spot-headline__location-icon"} "location_on")
      (link-to/region system (hal/embedded spot :region))
      ", "
      (link-to/country system (hal/embedded spot :country))]]))

(rum/defc spot-image < rum/static
  "Render a spot image."
  [spot]
  (when-let [src (-> spot :_embedded :photo :images :small :url)]
    (image
     {:class "spot-card__image"
      :background "#222222"
      :preload true
      :sizing "cover"
      :fade true
      :src src})))

(defn spot-card-key
  "Return the spot list item key."
  [system spot]
  (str "spot-list-item-" (:id spot)))

(rum/defc spot-card < rum/static {:key-fn spot-card-key}
  "Render the spot list item."
  [system spot]
  [:div.spot-card
   (spot-image spot)
   (spot-headline system spot)])

(rum/defc spot-cards < rum/static
  "Render a spot list."
  [system spots]
  [:div.spot-cards
   (for [spot spots]
     (spot-card system spot))])
