(ns burningswell.web.signup-test
  (:require [burningswell.web.signin-test :as signin]
            [burningswell.web.test :refer :all]
            [burningswell.web.webdriver :refer [quick-fill]]
            [clj-webdriver.taxi :as taxi]
            [clojure.test :refer :all]))

(def signup-data
  {:email "john.doe@example.com"
   :username "johndoe"
   :password "secret"
   :terms-of-service true})

(defn fill-signup-form
  "Fill the signup form."
  [system {:keys [email username password terms-of-service]}]
  (quick-fill
   (:webdriver system)
   {"input[name=username]" username}
   {"input[name=email]" email}
   {"input[name=password]" password}
   {"input[name=terms-of-service]"
    #(if terms-of-service (taxi/click (:webdriver system) %))}))

(defn submit-signup-form
  "Fill and submit the signup form."
  [system credentials]
  (browse-to system "/signup")
  (fill-signup-form system credentials)
  (taxi/submit (:webdriver system) "input[name=email]"))

(defn signup-error
  "Return the error message for `key` of the signup form."
  [{:keys [webdriver]} key]
  (some->> {:css (str ".signup-form__" (name key) "__error")}
           (taxi/find-element webdriver)
           (taxi/text webdriver)))

;; (deftest test-signup-sucess
;;   (with-webdriver-system [system env]
;;     (submit-signup-form system signup-data)
;;     (wait-for-path (:webdriver system) #"/spots")
;;     (signin/submit-signin-form
;;      system {:login (:username signup-data)
;;              :password (:password signup-data)})
;;     (wait-for-path (:webdriver system) #"/spots")))

;; (deftest test-signup-username-blank
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :username "")
;;          (submit-signup-form system))
;;     (is (= (signup-error system :username)
;;            "Username can't be blank."))))

;; (deftest test-signup-username-taken
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :username "bodhi")
;;          (submit-signup-form system))
;;     (is (= (signup-error system :username)
;;            "Username has already been taken."))))

;; (deftest test-signup-email-blank
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :email "")
;;          (submit-signup-form system))
;;     (is (= (signup-error system :email)
;;            "Email can't be blank."))))

;; (deftest test-signup-email-invalid
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :email "invalid")
;;          (submit-signup-form system))
;;     (is (= (signup-error system :email)
;;            "Email is not valid."))))

;; (deftest test-signup-email-taken
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :email "bodhi@burningswell.com")
;;          (submit-signup-form system))
;;     (is (= (signup-error system :email)
;;            "Email has already been taken."))))

;; (deftest test-signup-password-blank
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :password "")
;;          (submit-signup-form system))
;;     (is (= (signup-error system :password)
;;            "Password can't be blank."))))

;; (deftest test-signup-password-too-short
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :password "x")
;;          (submit-signup-form system))
;;     (is (= (signup-error system :password)
;;            "Password is too short (min. 6 chars)."))))

;; (deftest test-signup-terms-of-service-not-accepted
;;   (with-webdriver-system [system env]
;;     (->> (assoc signup-data :terms-of-service false)
;;          (submit-signup-form system))
;;     (is (= (signup-error system :terms-of-service)
;;            "Please accept the Terms of Service."))))
