// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('cljs_http.client');
goog.require('cljs.core');
goog.require('goog.Uri');
goog.require('cljs_http.core');
goog.require('cljs.core.async');
goog.require('no.en.core');
goog.require('cljs_http.util');
goog.require('clojure.string');
goog.require('cljs.reader');
cljs_http.client.if_pos = (function cljs_http$client$if_pos(v){
if(cljs.core.truth_((function (){var and__6782__auto__ = v;
if(cljs.core.truth_(and__6782__auto__)){
return (v > (0));
} else {
return and__6782__auto__;
}
})())){
return v;
} else {
return null;
}
});
/**
 * Parse `s` as query params and return a hash map.
 */
cljs_http.client.parse_query_params = (function cljs_http$client$parse_query_params(s){
if(!(clojure.string.blank_QMARK_(s))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__49215_SHARP_,p2__49214_SHARP_){
var vec__49219 = clojure.string.split.cljs$core$IFn$_invoke$arity$2(p2__49214_SHARP_,/=/);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49219,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49219,(1),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__49215_SHARP_,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(no.en.core.url_decode(k)),no.en.core.url_decode(v));
}),cljs.core.PersistentArrayMap.EMPTY,clojure.string.split.cljs$core$IFn$_invoke$arity$2([cljs.core.str(s)].join(''),/&/));
} else {
return null;
}
});
/**
 * Parse `url` into a hash map.
 */
cljs_http.client.parse_url = (function cljs_http$client$parse_url(url){
if(!(clojure.string.blank_QMARK_(url))){
var uri = goog.Uri.parse(url);
var query_data = uri.getQueryData();
return new cljs.core.PersistentArrayMap(null, 6, [cljs.core.cst$kw$scheme,cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(uri.getScheme()),cljs.core.cst$kw$server_DASH_name,uri.getDomain(),cljs.core.cst$kw$server_DASH_port,cljs_http.client.if_pos(uri.getPort()),cljs.core.cst$kw$uri,uri.getPath(),cljs.core.cst$kw$query_DASH_string,((cljs.core.not(query_data.isEmpty()))?[cljs.core.str(query_data)].join(''):null),cljs.core.cst$kw$query_DASH_params,((cljs.core.not(query_data.isEmpty()))?cljs_http.client.parse_query_params([cljs.core.str(query_data)].join('')):null)], null);
} else {
return null;
}
});
cljs_http.client.unexceptional_status_QMARK_ = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 13, [(205),null,(206),null,(300),null,(204),null,(307),null,(303),null,(301),null,(201),null,(302),null,(202),null,(200),null,(203),null,(207),null], null), null);
cljs_http.client.encode_val = (function cljs_http$client$encode_val(k,v){
return [cljs.core.str(no.en.core.url_encode(cljs.core.name(k))),cljs.core.str("="),cljs.core.str(no.en.core.url_encode([cljs.core.str(v)].join('')))].join('');
});
cljs_http.client.encode_vals = (function cljs_http$client$encode_vals(k,vs){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__49235_SHARP_){
return cljs_http.client.encode_val(k,p1__49235_SHARP_);
}),vs));
});
cljs_http.client.encode_param = (function cljs_http$client$encode_param(p__49239){
var vec__49243 = p__49239;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49243,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49243,(1),null);
if(cljs.core.coll_QMARK_(v)){
return cljs_http.client.encode_vals(k,v);
} else {
return cljs_http.client.encode_val(k,v);
}
});
cljs_http.client.generate_query_string = (function cljs_http$client$generate_query_string(params){
return clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs_http.client.encode_param,params));
});
cljs_http.client.regex_char_esc_smap = (function (){var esc_chars = "()*&^%$#!+";
return cljs.core.zipmap(esc_chars,cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (esc_chars){
return (function (p1__49251_SHARP_){
return [cljs.core.str("\\"),cljs.core.str(p1__49251_SHARP_)].join('');
});})(esc_chars))
,esc_chars));
})();
/**
 * Escape special characters -- for content-type.
 */
cljs_http.client.escape_special = (function cljs_http$client$escape_special(string){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(cljs.core.str,cljs.core.replace.cljs$core$IFn$_invoke$arity$2(cljs_http.client.regex_char_esc_smap,string));
});
/**
 * Decocde the :body of `response` with `decode-fn` if the content type matches.
 */
cljs_http.client.decode_body = (function cljs_http$client$decode_body(response,decode_fn,content_type,request_method){
if(cljs.core.truth_((function (){var and__6782__auto__ = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.cst$kw$head,request_method);
if(and__6782__auto__){
var and__6782__auto____$1 = cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2((204),cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(response));
if(and__6782__auto____$1){
return cljs.core.re_find(cljs.core.re_pattern([cljs.core.str("(?i)"),cljs.core.str(cljs_http.client.escape_special(content_type))].join('')),[cljs.core.str(cljs.core.get.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(response),"content-type",""))].join(''));
} else {
return and__6782__auto____$1;
}
} else {
return and__6782__auto__;
}
})())){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(response,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$body], null),decode_fn);
} else {
return response;
}
});
/**
 * Encode :edn-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_edn_params = (function cljs_http$client$wrap_edn_params(client){
return (function (request__$1){
var temp__6367__auto__ = cljs.core.cst$kw$edn_DASH_params.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(temp__6367__auto__)){
var params = temp__6367__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/edn"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request__$1)], 0));
var G__49283 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request__$1,cljs.core.cst$kw$edn_DASH_params),cljs.core.cst$kw$body,cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([params], 0))),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49283) : client.call(null,G__49283));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
});
/**
 * Decode application/edn responses.
 */
cljs_http.client.wrap_edn_response = (function cljs_http$client$wrap_edn_response(client){
return (function (request__$1){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__49295_SHARP_){
return cljs_http.client.decode_body(p1__49295_SHARP_,cljs.reader.read_string,"application/edn",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request__$1));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1))], null));
});
});
cljs_http.client.wrap_default_headers = (function cljs_http$client$wrap_default_headers(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49322 = arguments.length;
var i__7978__auto___49323 = (0);
while(true){
if((i__7978__auto___49323 < len__7977__auto___49322)){
args__7984__auto__.push((arguments[i__7978__auto___49323]));

var G__49324 = (i__7978__auto___49323 + (1));
i__7978__auto___49323 = G__49324;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__49314){
var vec__49315 = p__49314;
var default_headers = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49315,(0),null);
return ((function (vec__49315,default_headers){
return (function (request__$1){
var temp__6367__auto__ = (function (){var or__6794__auto__ = cljs.core.cst$kw$default_DASH_headers.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return default_headers;
}
})();
if(cljs.core.truth_(temp__6367__auto__)){
var default_headers__$1 = temp__6367__auto__;
var G__49319 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(request__$1,cljs.core.cst$kw$default_DASH_headers,default_headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49319) : client.call(null,G__49319));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
;})(vec__49315,default_headers))
});

cljs_http.client.wrap_default_headers.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_default_headers.cljs$lang$applyTo = (function (seq49306){
var G__49307 = cljs.core.first(seq49306);
var seq49306__$1 = cljs.core.next(seq49306);
return cljs_http.client.wrap_default_headers.cljs$core$IFn$_invoke$arity$variadic(G__49307,seq49306__$1);
});

cljs_http.client.wrap_accept = (function cljs_http$client$wrap_accept(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49368 = arguments.length;
var i__7978__auto___49369 = (0);
while(true){
if((i__7978__auto___49369 < len__7977__auto___49368)){
args__7984__auto__.push((arguments[i__7978__auto___49369]));

var G__49372 = (i__7978__auto___49369 + (1));
i__7978__auto___49369 = G__49372;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__49355){
var vec__49356 = p__49355;
var accept = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49356,(0),null);
return ((function (vec__49356,accept){
return (function (request__$1){
var temp__6367__auto__ = (function (){var or__6794__auto__ = cljs.core.cst$kw$accept.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return accept;
}
})();
if(cljs.core.truth_(temp__6367__auto__)){
var accept__$1 = temp__6367__auto__;
var G__49359 = cljs.core.assoc_in(request__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"accept"], null),accept__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49359) : client.call(null,G__49359));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
;})(vec__49356,accept))
});

cljs_http.client.wrap_accept.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_accept.cljs$lang$applyTo = (function (seq49349){
var G__49350 = cljs.core.first(seq49349);
var seq49349__$1 = cljs.core.next(seq49349);
return cljs_http.client.wrap_accept.cljs$core$IFn$_invoke$arity$variadic(G__49350,seq49349__$1);
});

cljs_http.client.wrap_content_type = (function cljs_http$client$wrap_content_type(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49422 = arguments.length;
var i__7978__auto___49423 = (0);
while(true){
if((i__7978__auto___49423 < len__7977__auto___49422)){
args__7984__auto__.push((arguments[i__7978__auto___49423]));

var G__49424 = (i__7978__auto___49423 + (1));
i__7978__auto___49423 = G__49424;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__49417){
var vec__49418 = p__49417;
var content_type = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49418,(0),null);
return ((function (vec__49418,content_type){
return (function (request__$1){
var temp__6367__auto__ = (function (){var or__6794__auto__ = cljs.core.cst$kw$content_DASH_type.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return content_type;
}
})();
if(cljs.core.truth_(temp__6367__auto__)){
var content_type__$1 = temp__6367__auto__;
var G__49421 = cljs.core.assoc_in(request__$1,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"content-type"], null),content_type__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49421) : client.call(null,G__49421));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
;})(vec__49418,content_type))
});

cljs_http.client.wrap_content_type.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_content_type.cljs$lang$applyTo = (function (seq49409){
var G__49410 = cljs.core.first(seq49409);
var seq49409__$1 = cljs.core.next(seq49409);
return cljs_http.client.wrap_content_type.cljs$core$IFn$_invoke$arity$variadic(G__49410,seq49409__$1);
});

cljs_http.client.default_transit_opts = new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$encoding,cljs.core.cst$kw$json,cljs.core.cst$kw$encoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$decoding,cljs.core.cst$kw$json,cljs.core.cst$kw$decoding_DASH_opts,cljs.core.PersistentArrayMap.EMPTY], null);
/**
 * Encode :transit-params in the `request` :body and set the appropriate
 *   Content Type header.
 * 
 *   A :transit-opts map can be optionally provided with the following keys:
 * 
 *   :encoding                #{:json, :json-verbose}
 *   :decoding                #{:json, :json-verbose}
 *   :encoding/decoding-opts  appropriate map of options to be passed to
 *                         transit writer/reader, respectively.
 */
cljs_http.client.wrap_transit_params = (function cljs_http$client$wrap_transit_params(client){
return (function (request__$1){
var temp__6367__auto__ = cljs.core.cst$kw$transit_DASH_params.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(temp__6367__auto__)){
var params = temp__6367__auto__;
var map__49431 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request__$1)], 0));
var map__49431__$1 = ((((!((map__49431 == null)))?((((map__49431.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49431.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49431):map__49431);
var encoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49431__$1,cljs.core.cst$kw$encoding);
var encoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49431__$1,cljs.core.cst$kw$encoding_DASH_opts);
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/transit+json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request__$1)], 0));
var G__49433 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request__$1,cljs.core.cst$kw$transit_DASH_params),cljs.core.cst$kw$body,cljs_http.util.transit_encode(params,encoding,encoding_opts)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49433) : client.call(null,G__49433));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
});
/**
 * Decode application/transit+json responses.
 */
cljs_http.client.wrap_transit_response = (function cljs_http$client$wrap_transit_response(client){
return (function (request__$1){
var map__49443 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs_http.client.default_transit_opts,cljs.core.cst$kw$transit_DASH_opts.cljs$core$IFn$_invoke$arity$1(request__$1)], 0));
var map__49443__$1 = ((((!((map__49443 == null)))?((((map__49443.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49443.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49443):map__49443);
var decoding = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49443__$1,cljs.core.cst$kw$decoding);
var decoding_opts = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49443__$1,cljs.core.cst$kw$decoding_DASH_opts);
var transit_decode = ((function (map__49443,map__49443__$1,decoding,decoding_opts){
return (function (p1__49439_SHARP_){
return cljs_http.util.transit_decode(p1__49439_SHARP_,decoding,decoding_opts);
});})(map__49443,map__49443__$1,decoding,decoding_opts))
;
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2(((function (map__49443,map__49443__$1,decoding,decoding_opts,transit_decode){
return (function (p1__49440_SHARP_){
return cljs_http.client.decode_body(p1__49440_SHARP_,transit_decode,"application/transit+json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request__$1));
});})(map__49443,map__49443__$1,decoding,decoding_opts,transit_decode))
,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1))], null));
});
});
/**
 * Encode :json-params in the `request` :body and set the appropriate
 *   Content Type header.
 */
cljs_http.client.wrap_json_params = (function cljs_http$client$wrap_json_params(client){
return (function (request__$1){
var temp__6367__auto__ = cljs.core.cst$kw$json_DASH_params.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(temp__6367__auto__)){
var params = temp__6367__auto__;
var headers = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/json"], null),cljs.core.cst$kw$headers.cljs$core$IFn$_invoke$arity$1(request__$1)], 0));
var G__49450 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request__$1,cljs.core.cst$kw$json_DASH_params),cljs.core.cst$kw$body,cljs_http.util.json_encode(params)),cljs.core.cst$kw$headers,headers);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49450) : client.call(null,G__49450));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
});
/**
 * Decode application/json responses.
 */
cljs_http.client.wrap_json_response = (function cljs_http$client$wrap_json_response(client){
return (function (request__$1){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((function (p1__49451_SHARP_){
return cljs_http.client.decode_body(p1__49451_SHARP_,cljs_http.util.json_decode,"application/json",cljs.core.cst$kw$request_DASH_method.cljs$core$IFn$_invoke$arity$1(request__$1));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1))], null));
});
});
cljs_http.client.wrap_query_params = (function cljs_http$client$wrap_query_params(client){
return (function (p__49456){
var map__49457 = p__49456;
var map__49457__$1 = ((((!((map__49457 == null)))?((((map__49457.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49457.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49457):map__49457);
var req = map__49457__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49457__$1,cljs.core.cst$kw$query_DASH_params);
if(cljs.core.truth_(query_params)){
var G__49459 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$query_DASH_params),cljs.core.cst$kw$query_DASH_string,cljs_http.client.generate_query_string(query_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49459) : client.call(null,G__49459));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_form_params = (function cljs_http$client$wrap_form_params(client){
return (function (p__49465){
var map__49466 = p__49465;
var map__49466__$1 = ((((!((map__49466 == null)))?((((map__49466.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49466.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49466):map__49466);
var request__$1 = map__49466__$1;
var form_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49466__$1,cljs.core.cst$kw$form_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49466__$1,cljs.core.cst$kw$request_DASH_method);
var headers = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49466__$1,cljs.core.cst$kw$headers);
if(cljs.core.truth_((function (){var and__6782__auto__ = form_params;
if(cljs.core.truth_(and__6782__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null).call(null,request_method);
} else {
return and__6782__auto__;
}
})())){
var headers__$1 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, ["content-type","application/x-www-form-urlencoded"], null),headers], 0));
var G__49468 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request__$1,cljs.core.cst$kw$form_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_query_string(form_params)),cljs.core.cst$kw$headers,headers__$1);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49468) : client.call(null,G__49468));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
});
cljs_http.client.generate_form_data = (function cljs_http$client$generate_form_data(params){
var form_data = (new FormData());
var seq__49479_49489 = cljs.core.seq(params);
var chunk__49480_49490 = null;
var count__49481_49491 = (0);
var i__49482_49492 = (0);
while(true){
if((i__49482_49492 < count__49481_49491)){
var vec__49483_49493 = chunk__49480_49490.cljs$core$IIndexed$_nth$arity$2(null,i__49482_49492);
var k_49494 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49483_49493,(0),null);
var v_49495 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49483_49493,(1),null);
if(cljs.core.coll_QMARK_(v_49495)){
form_data.append(cljs.core.name(k_49494),cljs.core.first(v_49495),cljs.core.second(v_49495));
} else {
form_data.append(cljs.core.name(k_49494),v_49495);
}

var G__49496 = seq__49479_49489;
var G__49497 = chunk__49480_49490;
var G__49498 = count__49481_49491;
var G__49499 = (i__49482_49492 + (1));
seq__49479_49489 = G__49496;
chunk__49480_49490 = G__49497;
count__49481_49491 = G__49498;
i__49482_49492 = G__49499;
continue;
} else {
var temp__6369__auto___49502 = cljs.core.seq(seq__49479_49489);
if(temp__6369__auto___49502){
var seq__49479_49503__$1 = temp__6369__auto___49502;
if(cljs.core.chunked_seq_QMARK_(seq__49479_49503__$1)){
var c__7697__auto___49504 = cljs.core.chunk_first(seq__49479_49503__$1);
var G__49505 = cljs.core.chunk_rest(seq__49479_49503__$1);
var G__49506 = c__7697__auto___49504;
var G__49507 = cljs.core.count(c__7697__auto___49504);
var G__49508 = (0);
seq__49479_49489 = G__49505;
chunk__49480_49490 = G__49506;
count__49481_49491 = G__49507;
i__49482_49492 = G__49508;
continue;
} else {
var vec__49486_49510 = cljs.core.first(seq__49479_49503__$1);
var k_49511 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49486_49510,(0),null);
var v_49512 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49486_49510,(1),null);
if(cljs.core.coll_QMARK_(v_49512)){
form_data.append(cljs.core.name(k_49511),cljs.core.first(v_49512),cljs.core.second(v_49512));
} else {
form_data.append(cljs.core.name(k_49511),v_49512);
}

var G__49515 = cljs.core.next(seq__49479_49503__$1);
var G__49516 = null;
var G__49517 = (0);
var G__49519 = (0);
seq__49479_49489 = G__49515;
chunk__49480_49490 = G__49516;
count__49481_49491 = G__49517;
i__49482_49492 = G__49519;
continue;
}
} else {
}
}
break;
}

return form_data;
});
cljs_http.client.wrap_multipart_params = (function cljs_http$client$wrap_multipart_params(client){
return (function (p__49527){
var map__49528 = p__49527;
var map__49528__$1 = ((((!((map__49528 == null)))?((((map__49528.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49528.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49528):map__49528);
var request__$1 = map__49528__$1;
var multipart_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49528__$1,cljs.core.cst$kw$multipart_DASH_params);
var request_method = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49528__$1,cljs.core.cst$kw$request_DASH_method);
if(cljs.core.truth_((function (){var and__6782__auto__ = multipart_params;
if(cljs.core.truth_(and__6782__auto__)){
return new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$patch,null,cljs.core.cst$kw$delete,null,cljs.core.cst$kw$post,null,cljs.core.cst$kw$put,null], null), null).call(null,request_method);
} else {
return and__6782__auto__;
}
})())){
var G__49530 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(request__$1,cljs.core.cst$kw$multipart_DASH_params),cljs.core.cst$kw$body,cljs_http.client.generate_form_data(multipart_params));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49530) : client.call(null,G__49530));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
});
cljs_http.client.wrap_method = (function cljs_http$client$wrap_method(client){
return (function (req){
var temp__6367__auto__ = cljs.core.cst$kw$method.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6367__auto__)){
var m = temp__6367__auto__;
var G__49536 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$method),cljs.core.cst$kw$request_DASH_method,m);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49536) : client.call(null,G__49536));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
cljs_http.client.wrap_server_name = (function cljs_http$client$wrap_server_name(client,server_name){
return (function (p1__49537_SHARP_){
var G__49543 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__49537_SHARP_,cljs.core.cst$kw$server_DASH_name,server_name);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49543) : client.call(null,G__49543));
});
});
cljs_http.client.wrap_url = (function cljs_http$client$wrap_url(client){
return (function (p__49551){
var map__49552 = p__49551;
var map__49552__$1 = ((((!((map__49552 == null)))?((((map__49552.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49552.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49552):map__49552);
var req = map__49552__$1;
var query_params = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49552__$1,cljs.core.cst$kw$query_DASH_params);
var temp__6367__auto__ = cljs_http.client.parse_url(cljs.core.cst$kw$url.cljs$core$IFn$_invoke$arity$1(req));
if(cljs.core.truth_(temp__6367__auto__)){
var spec = temp__6367__auto__;
var G__49554 = cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,spec], 0)),cljs.core.cst$kw$url),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$query_DASH_params], null),((function (spec,temp__6367__auto__,map__49552,map__49552__$1,req,query_params){
return (function (p1__49546_SHARP_){
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__49546_SHARP_,query_params], 0));
});})(spec,temp__6367__auto__,map__49552,map__49552__$1,req,query_params))
);
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49554) : client.call(null,G__49554));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Middleware converting the :basic-auth option or `credentials` into
 *   an Authorization header.
 */
cljs_http.client.wrap_basic_auth = (function cljs_http$client$wrap_basic_auth(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49564 = arguments.length;
var i__7978__auto___49565 = (0);
while(true){
if((i__7978__auto___49565 < len__7977__auto___49564)){
args__7984__auto__.push((arguments[i__7978__auto___49565]));

var G__49566 = (i__7978__auto___49565 + (1));
i__7978__auto___49565 = G__49566;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic = (function (client,p__49558){
var vec__49559 = p__49558;
var credentials = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49559,(0),null);
return ((function (vec__49559,credentials){
return (function (req){
var credentials__$1 = (function (){var or__6794__auto__ = cljs.core.cst$kw$basic_DASH_auth.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return credentials;
}
})();
if(!(cljs.core.empty_QMARK_(credentials__$1))){
var G__49562 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$basic_DASH_auth),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),cljs_http.util.basic_auth(credentials__$1));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49562) : client.call(null,G__49562));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
;})(vec__49559,credentials))
});

cljs_http.client.wrap_basic_auth.cljs$lang$maxFixedArity = (1);

cljs_http.client.wrap_basic_auth.cljs$lang$applyTo = (function (seq49556){
var G__49557 = cljs.core.first(seq49556);
var seq49556__$1 = cljs.core.next(seq49556);
return cljs_http.client.wrap_basic_auth.cljs$core$IFn$_invoke$arity$variadic(G__49557,seq49556__$1);
});

/**
 * Middleware converting the :oauth-token option into an Authorization header.
 */
cljs_http.client.wrap_oauth = (function cljs_http$client$wrap_oauth(client){
return (function (req){
var temp__6367__auto__ = cljs.core.cst$kw$oauth_DASH_token.cljs$core$IFn$_invoke$arity$1(req);
if(cljs.core.truth_(temp__6367__auto__)){
var oauth_token = temp__6367__auto__;
var G__49568 = cljs.core.assoc_in(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(req,cljs.core.cst$kw$oauth_DASH_token),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$headers,"authorization"], null),[cljs.core.str("Bearer "),cljs.core.str(oauth_token)].join(''));
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(G__49568) : client.call(null,G__49568));
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(req) : client.call(null,req));
}
});
});
/**
 * Pipe the response-channel into the request-map's
 * custom channel (e.g. to enable transducers)
 */
cljs_http.client.wrap_channel_from_request_map = (function cljs_http$client$wrap_channel_from_request_map(client){
return (function (request__$1){
var temp__6367__auto__ = cljs.core.cst$kw$channel.cljs$core$IFn$_invoke$arity$1(request__$1);
if(cljs.core.truth_(temp__6367__auto__)){
var custom_channel = temp__6367__auto__;
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1)),custom_channel);
} else {
return (client.cljs$core$IFn$_invoke$arity$1 ? client.cljs$core$IFn$_invoke$arity$1(request__$1) : client.call(null,request__$1));
}
});
});
/**
 * Returns a batteries-included HTTP request function coresponding to the given
 * core client. See client/request
 */
cljs_http.client.wrap_request = (function cljs_http$client$wrap_request(request__$1){
return cljs_http.client.wrap_default_headers(cljs_http.client.wrap_channel_from_request_map(cljs_http.client.wrap_url(cljs_http.client.wrap_method(cljs_http.client.wrap_oauth(cljs_http.client.wrap_basic_auth(cljs_http.client.wrap_query_params(cljs_http.client.wrap_content_type(cljs_http.client.wrap_json_response(cljs_http.client.wrap_json_params(cljs_http.client.wrap_transit_response(cljs_http.client.wrap_transit_params(cljs_http.client.wrap_edn_response(cljs_http.client.wrap_edn_params(cljs_http.client.wrap_multipart_params(cljs_http.client.wrap_form_params(cljs_http.client.wrap_accept(request__$1)))))))))))))))));
});
/**
 * Executes the HTTP request corresponding to the given map and returns the
 * response map for corresponding to the resulting HTTP response.
 * 
 * In addition to the standard Ring request keys, the following keys are also
 * recognized:
 * * :url
 * * :method
 * * :query-params
 */
cljs_http.client.request = cljs_http.client.wrap_request(cljs_http.core.request);
/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.delete$ = (function cljs_http$client$delete(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49581 = arguments.length;
var i__7978__auto___49582 = (0);
while(true){
if((i__7978__auto___49582 < len__7977__auto___49581)){
args__7984__auto__.push((arguments[i__7978__auto___49582]));

var G__49583 = (i__7978__auto___49582 + (1));
i__7978__auto___49582 = G__49583;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49576){
var vec__49577 = p__49576;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49577,(0),null);
var G__49580 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$delete,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49580) : cljs_http.client.request.call(null,G__49580));
});

cljs_http.client.delete$.cljs$lang$maxFixedArity = (1);

cljs_http.client.delete$.cljs$lang$applyTo = (function (seq49573){
var G__49574 = cljs.core.first(seq49573);
var seq49573__$1 = cljs.core.next(seq49573);
return cljs_http.client.delete$.cljs$core$IFn$_invoke$arity$variadic(G__49574,seq49573__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.get = (function cljs_http$client$get(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49599 = arguments.length;
var i__7978__auto___49600 = (0);
while(true){
if((i__7978__auto___49600 < len__7977__auto___49599)){
args__7984__auto__.push((arguments[i__7978__auto___49600]));

var G__49601 = (i__7978__auto___49600 + (1));
i__7978__auto___49600 = G__49601;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49587){
var vec__49588 = p__49587;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49588,(0),null);
var G__49591 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$get,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49591) : cljs_http.client.request.call(null,G__49591));
});

cljs_http.client.get.cljs$lang$maxFixedArity = (1);

cljs_http.client.get.cljs$lang$applyTo = (function (seq49585){
var G__49586 = cljs.core.first(seq49585);
var seq49585__$1 = cljs.core.next(seq49585);
return cljs_http.client.get.cljs$core$IFn$_invoke$arity$variadic(G__49586,seq49585__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.head = (function cljs_http$client$head(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49623 = arguments.length;
var i__7978__auto___49624 = (0);
while(true){
if((i__7978__auto___49624 < len__7977__auto___49623)){
args__7984__auto__.push((arguments[i__7978__auto___49624]));

var G__49626 = (i__7978__auto___49624 + (1));
i__7978__auto___49624 = G__49626;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49618){
var vec__49619 = p__49618;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49619,(0),null);
var G__49622 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$head,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49622) : cljs_http.client.request.call(null,G__49622));
});

cljs_http.client.head.cljs$lang$maxFixedArity = (1);

cljs_http.client.head.cljs$lang$applyTo = (function (seq49616){
var G__49617 = cljs.core.first(seq49616);
var seq49616__$1 = cljs.core.next(seq49616);
return cljs_http.client.head.cljs$core$IFn$_invoke$arity$variadic(G__49617,seq49616__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.jsonp = (function cljs_http$client$jsonp(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49634 = arguments.length;
var i__7978__auto___49635 = (0);
while(true){
if((i__7978__auto___49635 < len__7977__auto___49634)){
args__7984__auto__.push((arguments[i__7978__auto___49635]));

var G__49638 = (i__7978__auto___49635 + (1));
i__7978__auto___49635 = G__49638;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49629){
var vec__49630 = p__49629;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49630,(0),null);
var G__49633 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$jsonp,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49633) : cljs_http.client.request.call(null,G__49633));
});

cljs_http.client.jsonp.cljs$lang$maxFixedArity = (1);

cljs_http.client.jsonp.cljs$lang$applyTo = (function (seq49627){
var G__49628 = cljs.core.first(seq49627);
var seq49627__$1 = cljs.core.next(seq49627);
return cljs_http.client.jsonp.cljs$core$IFn$_invoke$arity$variadic(G__49628,seq49627__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.move = (function cljs_http$client$move(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49653 = arguments.length;
var i__7978__auto___49654 = (0);
while(true){
if((i__7978__auto___49654 < len__7977__auto___49653)){
args__7984__auto__.push((arguments[i__7978__auto___49654]));

var G__49655 = (i__7978__auto___49654 + (1));
i__7978__auto___49654 = G__49655;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49648){
var vec__49649 = p__49648;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49649,(0),null);
var G__49652 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$move,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49652) : cljs_http.client.request.call(null,G__49652));
});

cljs_http.client.move.cljs$lang$maxFixedArity = (1);

cljs_http.client.move.cljs$lang$applyTo = (function (seq49646){
var G__49647 = cljs.core.first(seq49646);
var seq49646__$1 = cljs.core.next(seq49646);
return cljs_http.client.move.cljs$core$IFn$_invoke$arity$variadic(G__49647,seq49646__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.options = (function cljs_http$client$options(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49672 = arguments.length;
var i__7978__auto___49673 = (0);
while(true){
if((i__7978__auto___49673 < len__7977__auto___49672)){
args__7984__auto__.push((arguments[i__7978__auto___49673]));

var G__49674 = (i__7978__auto___49673 + (1));
i__7978__auto___49673 = G__49674;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49667){
var vec__49668 = p__49667;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49668,(0),null);
var G__49671 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$options,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49671) : cljs_http.client.request.call(null,G__49671));
});

cljs_http.client.options.cljs$lang$maxFixedArity = (1);

cljs_http.client.options.cljs$lang$applyTo = (function (seq49665){
var G__49666 = cljs.core.first(seq49665);
var seq49665__$1 = cljs.core.next(seq49665);
return cljs_http.client.options.cljs$core$IFn$_invoke$arity$variadic(G__49666,seq49665__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.patch = (function cljs_http$client$patch(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49686 = arguments.length;
var i__7978__auto___49687 = (0);
while(true){
if((i__7978__auto___49687 < len__7977__auto___49686)){
args__7984__auto__.push((arguments[i__7978__auto___49687]));

var G__49688 = (i__7978__auto___49687 + (1));
i__7978__auto___49687 = G__49688;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49681){
var vec__49682 = p__49681;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49682,(0),null);
var G__49685 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$patch,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49685) : cljs_http.client.request.call(null,G__49685));
});

cljs_http.client.patch.cljs$lang$maxFixedArity = (1);

cljs_http.client.patch.cljs$lang$applyTo = (function (seq49677){
var G__49680 = cljs.core.first(seq49677);
var seq49677__$1 = cljs.core.next(seq49677);
return cljs_http.client.patch.cljs$core$IFn$_invoke$arity$variadic(G__49680,seq49677__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.post = (function cljs_http$client$post(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49698 = arguments.length;
var i__7978__auto___49699 = (0);
while(true){
if((i__7978__auto___49699 < len__7977__auto___49698)){
args__7984__auto__.push((arguments[i__7978__auto___49699]));

var G__49700 = (i__7978__auto___49699 + (1));
i__7978__auto___49699 = G__49700;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49693){
var vec__49694 = p__49693;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49694,(0),null);
var G__49697 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$post,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49697) : cljs_http.client.request.call(null,G__49697));
});

cljs_http.client.post.cljs$lang$maxFixedArity = (1);

cljs_http.client.post.cljs$lang$applyTo = (function (seq49691){
var G__49692 = cljs.core.first(seq49691);
var seq49691__$1 = cljs.core.next(seq49691);
return cljs_http.client.post.cljs$core$IFn$_invoke$arity$variadic(G__49692,seq49691__$1);
});

/**
 * Like #'request, but sets the :method and :url as appropriate.
 */
cljs_http.client.put = (function cljs_http$client$put(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49711 = arguments.length;
var i__7978__auto___49712 = (0);
while(true){
if((i__7978__auto___49712 < len__7977__auto___49711)){
args__7984__auto__.push((arguments[i__7978__auto___49712]));

var G__49713 = (i__7978__auto___49712 + (1));
i__7978__auto___49712 = G__49713;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic = (function (url,p__49706){
var vec__49707 = p__49706;
var req = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49707,(0),null);
var G__49710 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([req,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$method,cljs.core.cst$kw$put,cljs.core.cst$kw$url,url], null)], 0));
return (cljs_http.client.request.cljs$core$IFn$_invoke$arity$1 ? cljs_http.client.request.cljs$core$IFn$_invoke$arity$1(G__49710) : cljs_http.client.request.call(null,G__49710));
});

cljs_http.client.put.cljs$lang$maxFixedArity = (1);

cljs_http.client.put.cljs$lang$applyTo = (function (seq49703){
var G__49704 = cljs.core.first(seq49703);
var seq49703__$1 = cljs.core.next(seq49703);
return cljs_http.client.put.cljs$core$IFn$_invoke$arity$variadic(G__49704,seq49703__$1);
});

