// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.ui.links');
goog.require('cljs.core');
goog.require('burningswell.web.history');
goog.require('clojure.string');
goog.require('rum.core');
/**
 * Return an on-click handler for `path`.
 */
burningswell.web.ui.links.on_click_handler = (function burningswell$web$ui$links$on_click_handler(system,path){
return (function (event){
burningswell.web.history.set_token_BANG_(cljs.core.cst$kw$history.cljs$core$IFn$_invoke$arity$1(system),path);

return event.preventDefault();
});
});
/**
 * Return the React key for a history link.
 */
burningswell.web.ui.links.history_key = (function burningswell$web$ui$links$history_key(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49236 = arguments.length;
var i__7978__auto___49237 = (0);
while(true){
if((i__7978__auto___49237 < len__7977__auto___49236)){
args__7984__auto__.push((arguments[i__7978__auto___49237]));

var G__49238 = (i__7978__auto___49237 + (1));
i__7978__auto___49237 = G__49238;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((3) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((3)),(0),null)):null);
return burningswell.web.ui.links.history_key.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7985__auto__);
});

burningswell.web.ui.links.history_key.cljs$core$IFn$_invoke$arity$variadic = (function (system,path,content,p__49231){
var vec__49232 = p__49231;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49232,(0),null);
return [cljs.core.str("link-to-history-"),cljs.core.str(cljs.core.hash(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [path,content], null)))].join('');
});

burningswell.web.ui.links.history_key.cljs$lang$maxFixedArity = (3);

burningswell.web.ui.links.history_key.cljs$lang$applyTo = (function (seq49227){
var G__49228 = cljs.core.first(seq49227);
var seq49227__$1 = cljs.core.next(seq49227);
var G__49229 = cljs.core.first(seq49227__$1);
var seq49227__$2 = cljs.core.next(seq49227__$1);
var G__49230 = cljs.core.first(seq49227__$2);
var seq49227__$3 = cljs.core.next(seq49227__$2);
return burningswell.web.ui.links.history_key.cljs$core$IFn$_invoke$arity$variadic(G__49228,G__49229,G__49230,seq49227__$3);
});

/**
 * Render a HTML5 history link.
 */
burningswell.web.ui.links.history = rum.core.build_defc((function() { 
var G__49252__delegate = function (system,path,content,p__49246){
var vec__49247 = p__49246;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49247,(0),null);
return sablono.interpreter.interpret(cljs.core.vec(cljs.core.sequence.cljs$core$IFn$_invoke$arity$1(cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$variadic(cljs.core._conj(cljs.core.List.EMPTY,cljs.core.cst$kw$a),(function (){var x__7720__auto__ = cljs.core.assoc.cljs$core$IFn$_invoke$arity$variadic(opts,cljs.core.cst$kw$href,path,cljs.core.array_seq([cljs.core.cst$kw$on_DASH_click,burningswell.web.ui.links.on_click_handler(system,path)], 0));
return cljs.core._conj(cljs.core.List.EMPTY,x__7720__auto__);
})(),cljs.core.array_seq([content], 0))))));
};
var G__49252 = function (system,path,content,var_args){
var p__49246 = null;
if (arguments.length > 3) {
var G__49254__i = 0, G__49254__a = new Array(arguments.length -  3);
while (G__49254__i < G__49254__a.length) {G__49254__a[G__49254__i] = arguments[G__49254__i + 3]; ++G__49254__i;}
  p__49246 = new cljs.core.IndexedSeq(G__49254__a,0);
} 
return G__49252__delegate.call(this,system,path,content,p__49246);};
G__49252.cljs$lang$maxFixedArity = 3;
G__49252.cljs$lang$applyTo = (function (arglist__49255){
var system = cljs.core.first(arglist__49255);
arglist__49255 = cljs.core.next(arglist__49255);
var path = cljs.core.first(arglist__49255);
arglist__49255 = cljs.core.next(arglist__49255);
var content = cljs.core.first(arglist__49255);
var p__49246 = cljs.core.rest(arglist__49255);
return G__49252__delegate(system,path,content,p__49246);
});
G__49252.cljs$core$IFn$_invoke$arity$variadic = G__49252__delegate;
return G__49252;
})()
,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$key_DASH_fn,burningswell.web.ui.links.history_key], null)], null),"history");
/**
 * Render a HTML5 history link to the countries page.
 */
burningswell.web.ui.links.countries = (function burningswell$web$ui$links$countries(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49262 = arguments.length;
var i__7978__auto___49263 = (0);
while(true){
if((i__7978__auto___49263 < len__7977__auto___49262)){
args__7984__auto__.push((arguments[i__7978__auto___49263]));

var G__49264 = (i__7978__auto___49263 + (1));
i__7978__auto___49263 = G__49264;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.ui.links.countries.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.ui.links.countries.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__49258){
var vec__49259 = p__49258;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49259,(0),null);
return (burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4 ? burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4(system,"/countries","Countries",opts) : burningswell.web.ui.links.history.call(null,system,"/countries","Countries",opts));
});

burningswell.web.ui.links.countries.cljs$lang$maxFixedArity = (1);

burningswell.web.ui.links.countries.cljs$lang$applyTo = (function (seq49256){
var G__49257 = cljs.core.first(seq49256);
var seq49256__$1 = cljs.core.next(seq49256);
return burningswell.web.ui.links.countries.cljs$core$IFn$_invoke$arity$variadic(G__49257,seq49256__$1);
});

/**
 * Render a HTML5 history link to a country.
 */
burningswell.web.ui.links.country = (function burningswell$web$ui$links$country(system,country__$1){
if(cljs.core.truth_(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(country__$1))){
var G__49275 = system;
var G__49276 = [cljs.core.str("/countries/"),cljs.core.str(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(country__$1))].join('');
var G__49277 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(country__$1);
var G__49278 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["link--country",null,"link",null], null), null)], null);
return (burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4 ? burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4(G__49275,G__49276,G__49277,G__49278) : burningswell.web.ui.links.history.call(null,G__49275,G__49276,G__49277,G__49278));
} else {
return null;
}
});
/**
 * Render a HTML5 history link to the signup page.
 */
burningswell.web.ui.links.create_account = (function burningswell$web$ui$links$create_account(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49290 = arguments.length;
var i__7978__auto___49291 = (0);
while(true){
if((i__7978__auto___49291 < len__7977__auto___49290)){
args__7984__auto__.push((arguments[i__7978__auto___49291]));

var G__49293 = (i__7978__auto___49291 + (1));
i__7978__auto___49291 = G__49293;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.ui.links.create_account.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.ui.links.create_account.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__49286){
var vec__49287 = p__49286;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49287,(0),null);
return (burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4 ? burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4(system,"/signup","Create one",opts) : burningswell.web.ui.links.history.call(null,system,"/signup","Create one",opts));
});

burningswell.web.ui.links.create_account.cljs$lang$maxFixedArity = (1);

burningswell.web.ui.links.create_account.cljs$lang$applyTo = (function (seq49284){
var G__49285 = cljs.core.first(seq49284);
var seq49284__$1 = cljs.core.next(seq49284);
return burningswell.web.ui.links.create_account.cljs$core$IFn$_invoke$arity$variadic(G__49285,seq49284__$1);
});

/**
 * Render a HTML5 history link to the signin page.
 */
burningswell.web.ui.links.login = (function burningswell$web$ui$links$login(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49312 = arguments.length;
var i__7978__auto___49313 = (0);
while(true){
if((i__7978__auto___49313 < len__7977__auto___49312)){
args__7984__auto__.push((arguments[i__7978__auto___49313]));

var G__49318 = (i__7978__auto___49313 + (1));
i__7978__auto___49313 = G__49318;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.ui.links.login.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.ui.links.login.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__49308){
var vec__49309 = p__49308;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49309,(0),null);
return (burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4 ? burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4(system,"/signin","Login",opts) : burningswell.web.ui.links.history.call(null,system,"/signin","Login",opts));
});

burningswell.web.ui.links.login.cljs$lang$maxFixedArity = (1);

burningswell.web.ui.links.login.cljs$lang$applyTo = (function (seq49298){
var G__49299 = cljs.core.first(seq49298);
var seq49298__$1 = cljs.core.next(seq49298);
return burningswell.web.ui.links.login.cljs$core$IFn$_invoke$arity$variadic(G__49299,seq49298__$1);
});

/**
 * Render a HTML5 history link to a region.
 */
burningswell.web.ui.links.region = (function burningswell$web$ui$links$region(system,region__$1){
if(cljs.core.truth_(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(region__$1))){
var G__49330 = system;
var G__49331 = [cljs.core.str("/regions/"),cljs.core.str(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(region__$1))].join('');
var G__49332 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(region__$1);
var G__49333 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["link--region",null,"link",null], null), null)], null);
return (burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4 ? burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4(G__49330,G__49331,G__49332,G__49333) : burningswell.web.ui.links.history.call(null,G__49330,G__49331,G__49332,G__49333));
} else {
return null;
}
});
/**
 * Render a HTML5 history link to a spot.
 */
burningswell.web.ui.links.spot = (function burningswell$web$ui$links$spot(system,spot__$1){
if(cljs.core.truth_(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(spot__$1))){
var G__49343 = system;
var G__49344 = [cljs.core.str("/spots/"),cljs.core.str(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(spot__$1))].join('');
var G__49345 = cljs.core.cst$kw$name.cljs$core$IFn$_invoke$arity$1(spot__$1);
var G__49346 = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["link",null,"link--spot",null], null), null)], null);
return (burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4 ? burningswell.web.ui.links.history.cljs$core$IFn$_invoke$arity$4(G__49343,G__49344,G__49345,G__49346) : burningswell.web.ui.links.history.call(null,G__49343,G__49344,G__49345,G__49346));
} else {
return null;
}
});
