// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.ui.image');
goog.require('cljs.core');
goog.require('rum.core');
/**
 * Return `url` in CSS style.
 */
burningswell.web.ui.image.css_url = (function burningswell$web$ui$image$css_url(url){
if(cljs.core.truth_(url)){
return [cljs.core.str("url("),cljs.core.str(url),cljs.core.str(")")].join('');
} else {
return null;
}
});
/**
 * Return the attributes of the container element.
 */
burningswell.web.ui.image.attributes = (function burningswell$web$ui$image$attributes(p__49792){
var map__49798 = p__49792;
var map__49798__$1 = ((((!((map__49798 == null)))?((((map__49798.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49798.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49798):map__49798);
var background = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49798__$1,cljs.core.cst$kw$background);
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49798__$1,cljs.core.cst$kw$class);
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49798__$1,cljs.core.cst$kw$height);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49798__$1,cljs.core.cst$kw$width);
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$class,(function (){var or__6794__auto__ = class$;
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return "image";
}
})(),cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$background,background,cljs.core.cst$kw$height,height,cljs.core.cst$kw$overflow,"hidden",cljs.core.cst$kw$width,width], null)], null);
});
/**
 * Return the background image for the sized element.
 */
burningswell.web.ui.image.sized_element_background_image = (function burningswell$web$ui$image$sized_element_background_image(image,p__49808){
var map__49812 = p__49808;
var map__49812__$1 = ((((!((map__49812 == null)))?((((map__49812.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49812.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49812):map__49812);
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49812__$1,cljs.core.cst$kw$placeholder);
var prevent_load = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49812__$1,cljs.core.cst$kw$prevent_DASH_load);
if(cljs.core.truth_((function (){var and__6782__auto__ = (function (){var or__6794__auto__ = placeholder;
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return prevent_load;
}
})();
if(cljs.core.truth_(and__6782__auto__)){
return cljs.core.not(image);
} else {
return and__6782__auto__;
}
})())){
return burningswell.web.ui.image.css_url(placeholder);
} else {
if(cljs.core.truth_(image)){
return burningswell.web.ui.image.css_url(image.src);
} else {
return null;
}
}
});
/**
 * Return the sized element.
 */
burningswell.web.ui.image.sized_element = rum.core.build_defc((function (image,p__49835){
var map__49836 = p__49835;
var map__49836__$1 = ((((!((map__49836 == null)))?((((map__49836.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49836.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49836):map__49836);
var opts = map__49836__$1;
var fade = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49836__$1,cljs.core.cst$kw$fade);
var sizing = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49836__$1,cljs.core.cst$kw$sizing);
var G__49838 = "div";
var G__49839 = ({"role": "img", "style": ({"bottom": (0), "transition": (cljs.core.truth_((function (){var and__6782__auto__ = image;
if(cljs.core.truth_(and__6782__auto__)){
return fade;
} else {
return and__6782__auto__;
}
})())?"opacity 0.5s linear":null), "top": (0), "backgroundRepeat": (cljs.core.truth_(sizing)?"no-repeat":null), "backgroundPosition": "50% 50%", "backgroundSize": sizing, "opacity": (cljs.core.truth_(image)?(1):(0)), "backgroundImage": burningswell.web.ui.image.sized_element_background_image(image,opts), "right": (0), "display": (cljs.core.truth_(sizing)?"block":"none"), "position": "absolute", "left": (0)})});
return React.createElement(G__49838,G__49839);
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$], null),"sized-element");
/**
 * Return the source attribute of the image element.
 */
burningswell.web.ui.image.image_element_source = (function burningswell$web$ui$image$image_element_source(image,p__49850){
var map__49855 = p__49850;
var map__49855__$1 = ((((!((map__49855 == null)))?((((map__49855.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49855.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49855):map__49855);
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49855__$1,cljs.core.cst$kw$placeholder);
var preload = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49855__$1,cljs.core.cst$kw$preload);
var src = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49855__$1,cljs.core.cst$kw$src);
if(cljs.core.truth_((function (){var and__6782__auto__ = placeholder;
if(cljs.core.truth_(and__6782__auto__)){
return cljs.core.not(image);
} else {
return and__6782__auto__;
}
})())){
return placeholder;
} else {
if(cljs.core.truth_((function (){var and__6782__auto__ = preload;
if(cljs.core.truth_(and__6782__auto__)){
return image;
} else {
return and__6782__auto__;
}
})())){
return image.src;
} else {
if(cljs.core.not(preload)){
return src;
} else {
return null;
}
}
}
});
/**
 * Return the image element.
 */
burningswell.web.ui.image.image_element = rum.core.build_defc((function (image,p__49868){
var map__49869 = p__49868;
var map__49869__$1 = ((((!((map__49869 == null)))?((((map__49869.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49869.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49869):map__49869);
var opts = map__49869__$1;
var fade = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49869__$1,cljs.core.cst$kw$fade);
var height = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49869__$1,cljs.core.cst$kw$height);
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49869__$1,cljs.core.cst$kw$placeholder);
var preload = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49869__$1,cljs.core.cst$kw$preload);
var src = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49869__$1,cljs.core.cst$kw$src);
var sizing = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49869__$1,cljs.core.cst$kw$sizing);
var width = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49869__$1,cljs.core.cst$kw$width);
var G__49875 = "img";
var G__49876 = ({"ref": "img", "role": "none", "src": burningswell.web.ui.image.image_element_source(image,opts), "style": ({"display": (cljs.core.truth_(sizing)?"none":"block"), "opacity": (cljs.core.truth_(image)?(1):(0)), "height": (function (){var or__6794__auto__ = height;
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return "auto";
}
})(), "width": (function (){var or__6794__auto__ = width;
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return "auto";
}
})(), "transition": (cljs.core.truth_((function (){var and__6782__auto__ = image;
if(cljs.core.truth_(and__6782__auto__)){
return fade;
} else {
return and__6782__auto__;
}
})())?"opacity 0.5s linear":null)})});
return React.createElement(G__49875,G__49876);
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$], null),"image-element");
/**
 * Return the placeholder element.
 */
burningswell.web.ui.image.placeholder_element = rum.core.build_defc((function (image,p__49890){
var map__49892 = p__49890;
var map__49892__$1 = ((((!((map__49892 == null)))?((((map__49892.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49892.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49892):map__49892);
var image__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49892__$1,cljs.core.cst$kw$image);
var placeholder = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49892__$1,cljs.core.cst$kw$placeholder);
var position = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49892__$1,cljs.core.cst$kw$position);
var sizing = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49892__$1,cljs.core.cst$kw$sizing);
return sablono.interpreter.interpret((cljs.core.truth_((function (){var and__6782__auto__ = placeholder;
if(cljs.core.truth_(and__6782__auto__)){
return cljs.core.not(image__$1);
} else {
return and__6782__auto__;
}
})())?new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$div,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$ref,"placeholder",cljs.core.cst$kw$style,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$background_DASH_color,"inherit",cljs.core.cst$kw$background_DASH_size,sizing,cljs.core.cst$kw$background_DASH_position,(cljs.core.truth_(sizing)?(function (){var or__6794__auto__ = position;
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return "center";
}
})():null),cljs.core.cst$kw$background_DASH_repeat,"no-repeat",cljs.core.cst$kw$background_DASH_image,burningswell.web.ui.image.css_url(placeholder),cljs.core.cst$kw$width,"100%",cljs.core.cst$kw$height,"100%"], null)], null)], null):null));
}),new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$], null),"placeholder-element");
/**
 * Return the image URL.
 */
burningswell.web.ui.image.image_url = (function burningswell$web$ui$image$image_url(state){
return cljs.core.cst$kw$src.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state)));
});
/**
 * Load the image.
 */
burningswell.web.ui.image.load_image = (function burningswell$web$ui$image$load_image(state){
var image = (new Image());
image.onload = ((function (image){
return (function (){
var G__49929 = cljs.core.cst$kw$burningswell$web$ui$image_SLASH_image.cljs$core$IFn$_invoke$arity$1(state);
var G__49930 = image;
return (cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2 ? cljs.core.reset_BANG_.cljs$core$IFn$_invoke$arity$2(G__49929,G__49930) : cljs.core.reset_BANG_.call(null,G__49929,G__49930));
});})(image))
;

image.src = burningswell.web.ui.image.image_url(state);

return image;
});
/**
 * The image mixin.
 */
burningswell.web.ui.image.image_mixin = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$will_DASH_mount,(function (state){
burningswell.web.ui.image.load_image(state);

return state;
}),cljs.core.cst$kw$did_DASH_remount,(function (old_state,new_state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(burningswell.web.ui.image.image_url(old_state),burningswell.web.ui.image.image_url(new_state))){
} else {
burningswell.web.ui.image.load_image(new_state);
}

return new_state;
})], null);
/**
 * Render an image.
 */
burningswell.web.ui.image.image = rum.core.build_defcs((function (state,opts){
var image = (function (){var G__49938 = state;
var G__49938__$1 = (((G__49938 == null))?null:cljs.core.cst$kw$burningswell$web$ui$image_SLASH_image.cljs$core$IFn$_invoke$arity$1(G__49938));
if((G__49938__$1 == null)){
return null;
} else {
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__49938__$1) : cljs.core.deref.call(null,G__49938__$1));
}
})();
var attrs49937 = burningswell.web.ui.image.attributes(opts);
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(React.createElement,"div",((cljs.core.map_QMARK_(attrs49937))?sablono.interpreter.attributes(sablono.normalize.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["image"], null)], null),attrs49937], 0))):({"className": "image"})),((cljs.core.map_QMARK_(attrs49937))?new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49939 = "div";
var G__49941 = ({"style": ({"display": "block", "height": "100%", "position": "relative", "width": "100%"}), "className": "image__content"});
var G__49942 = sablono.interpreter.interpret((burningswell.web.ui.image.sized_element.cljs$core$IFn$_invoke$arity$2 ? burningswell.web.ui.image.sized_element.cljs$core$IFn$_invoke$arity$2(image,opts) : burningswell.web.ui.image.sized_element.call(null,image,opts)));
var G__49943 = sablono.interpreter.interpret((burningswell.web.ui.image.image_element.cljs$core$IFn$_invoke$arity$2 ? burningswell.web.ui.image.image_element.cljs$core$IFn$_invoke$arity$2(image,opts) : burningswell.web.ui.image.image_element.call(null,image,opts)));
var G__49944 = sablono.interpreter.interpret((burningswell.web.ui.image.placeholder_element.cljs$core$IFn$_invoke$arity$2 ? burningswell.web.ui.image.placeholder_element.cljs$core$IFn$_invoke$arity$2(image,opts) : burningswell.web.ui.image.placeholder_element.call(null,image,opts)));
return React.createElement(G__49939,G__49941,G__49942,G__49943,G__49944);
})()], null):new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs49937),(function (){var G__49946 = "div";
var G__49947 = ({"style": ({"display": "block", "height": "100%", "position": "relative", "width": "100%"}), "className": "image__content"});
var G__49948 = sablono.interpreter.interpret((burningswell.web.ui.image.sized_element.cljs$core$IFn$_invoke$arity$2 ? burningswell.web.ui.image.sized_element.cljs$core$IFn$_invoke$arity$2(image,opts) : burningswell.web.ui.image.sized_element.call(null,image,opts)));
var G__49949 = sablono.interpreter.interpret((burningswell.web.ui.image.image_element.cljs$core$IFn$_invoke$arity$2 ? burningswell.web.ui.image.image_element.cljs$core$IFn$_invoke$arity$2(image,opts) : burningswell.web.ui.image.image_element.call(null,image,opts)));
var G__49950 = sablono.interpreter.interpret((burningswell.web.ui.image.placeholder_element.cljs$core$IFn$_invoke$arity$2 ? burningswell.web.ui.image.placeholder_element.cljs$core$IFn$_invoke$arity$2(image,opts) : burningswell.web.ui.image.placeholder_element.call(null,image,opts)));
return React.createElement(G__49946,G__49947,G__49948,G__49949,G__49950);
})()], null)));
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$,rum.core.local.cljs$core$IFn$_invoke$arity$2(null,cljs.core.cst$kw$burningswell$web$ui$image_SLASH_image),burningswell.web.ui.image.image_mixin], null),"image");
