// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.ui.google_map');
goog.require('cljs.core');
goog.require('clojure.string');
goog.require('geo.core');
goog.require('rum.core');
burningswell.web.ui.google_map.point__GT_map = (function burningswell$web$ui$google_map$point__GT_map(point){
return new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$latitude,point.lat(),cljs.core.cst$kw$longitude,point.lng()], null);
});
/**
 * Convert `point` to a Google Maps compatible location object.
 */
burningswell.web.ui.google_map.point__GT_lat_lng = (function burningswell$web$ui$google_map$point__GT_lat_lng(location){
if(cljs.core.truth_(location)){
return ({"lat": cljs.core.second(cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(location)), "lng": cljs.core.first(cljs.core.cst$kw$coordinates.cljs$core$IFn$_invoke$arity$1(location))});
} else {
return null;
}
});
/**
 * Convert `point` to a Google Maps compatible location object.
 */
burningswell.web.ui.google_map.lat_lng__GT_point = (function burningswell$web$ui$google_map$lat_lng__GT_point(location){
return geo.core.point((4326),location.lng(),location.lat());
});
/**
 * Returns the bounding box of `component`.
 */
burningswell.web.ui.google_map.center = (function burningswell$web$ui$google_map$center(map){
return burningswell.web.ui.google_map.lat_lng__GT_point(map.getCenter());
});
/**
 * Returns the bounding box of `map` as a geo box.
 */
burningswell.web.ui.google_map.bounding_box = (function burningswell$web$ui$google_map$bounding_box(map){
var bounds = map.getBounds();
return geo.core.bounding_box(burningswell.web.ui.google_map.lat_lng__GT_point(bounds.getSouthWest()),burningswell.web.ui.google_map.lat_lng__GT_point(bounds.getNorthEast()));
});
/**
 * Returns the bounding box of `map` as query params.
 */
burningswell.web.ui.google_map.bounding_box_query_params = (function burningswell$web$ui$google_map$bounding_box_query_params(map){
var bounds = map.getBounds();
return new cljs.core.PersistentArrayMap(null, 4, [cljs.core.cst$kw$top,bounds.getNorthEast().lat(),cljs.core.cst$kw$right,bounds.getNorthEast().lng(),cljs.core.cst$kw$bottom,bounds.getSouthWest().lat(),cljs.core.cst$kw$left,bounds.getSouthWest().lng()], null);
});
/**
 * Returns the zoom level of `map`.
 */
burningswell.web.ui.google_map.zoom = (function burningswell$web$ui$google_map$zoom(map){
return map.getZoom();
});
/**
 * Return the Google Maps event name.
 */
burningswell.web.ui.google_map.event_name = (function burningswell$web$ui$google_map$event_name(handler){
return clojure.string.replace(clojure.string.replace(cljs.core.name(handler),/^on-/,""),"-","_");
});
/**
 * Return the map element.
 */
burningswell.web.ui.google_map.map_element = (function burningswell$web$ui$google_map$map_element(state){
return rum.core.ref_node(state,"map");
});
/**
 * Return the map options
 */
burningswell.web.ui.google_map.map_opts = (function burningswell$web$ui$google_map$map_opts(opts){
var location = (function (){var or__6794__auto__ = cljs.core.cst$kw$location.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return geo.core.point((4326),(0),(0));
}
})();
return ({"center": burningswell.web.ui.google_map.point__GT_lat_lng(location), "zoom": (function (){var or__6794__auto__ = cljs.core.cst$kw$zoom.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return (4);
}
})()});
});
/**
 * Make a new Google Maps map.
 */
burningswell.web.ui.google_map.make_map = (function burningswell$web$ui$google_map$make_map(state){
return (new google.maps.Map(burningswell.web.ui.google_map.map_element(state),burningswell.web.ui.google_map.map_opts(cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state)))));
});
/**
 * Return the Google Maps event name.
 */
burningswell.web.ui.google_map.event_handlers = (function burningswell$web$ui$google_map$event_handlers(state){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__7648__auto__ = (function burningswell$web$ui$google_map$event_handlers_$_iter__50125(s__50126){
return (new cljs.core.LazySeq(null,(function (){
var s__50126__$1 = s__50126;
while(true){
var temp__6369__auto__ = cljs.core.seq(s__50126__$1);
if(temp__6369__auto__){
var s__50126__$2 = temp__6369__auto__;
if(cljs.core.chunked_seq_QMARK_(s__50126__$2)){
var c__7646__auto__ = cljs.core.chunk_first(s__50126__$2);
var size__7647__auto__ = cljs.core.count(c__7646__auto__);
var b__50128 = cljs.core.chunk_buffer(size__7647__auto__);
if((function (){var i__50127 = (0);
while(true){
if((i__50127 < size__7647__auto__)){
var vec__50137 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7646__auto__,i__50127);
var handler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50137,(0),null);
var callback = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50137,(1),null);
if(cljs.core.truth_((function (){var and__6782__auto__ = (handler instanceof cljs.core.Keyword);
if(and__6782__auto__){
return cljs.core.re_matches(/^on-.+/,cljs.core.name(handler));
} else {
return and__6782__auto__;
}
})())){
cljs.core.chunk_append(b__50128,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [handler,callback], null));

var G__50153 = (i__50127 + (1));
i__50127 = G__50153;
continue;
} else {
var G__50154 = (i__50127 + (1));
i__50127 = G__50154;
continue;
}
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__50128),burningswell$web$ui$google_map$event_handlers_$_iter__50125(cljs.core.chunk_rest(s__50126__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__50128),null);
}
} else {
var vec__50140 = cljs.core.first(s__50126__$2);
var handler = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50140,(0),null);
var callback = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50140,(1),null);
if(cljs.core.truth_((function (){var and__6782__auto__ = (handler instanceof cljs.core.Keyword);
if(and__6782__auto__){
return cljs.core.re_matches(/^on-.+/,cljs.core.name(handler));
} else {
return and__6782__auto__;
}
})())){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [handler,callback], null),burningswell$web$ui$google_map$event_handlers_$_iter__50125(cljs.core.rest(s__50126__$2)));
} else {
var G__50162 = cljs.core.rest(s__50126__$2);
s__50126__$1 = G__50162;
continue;
}
}
} else {
return null;
}
break;
}
}),null,null));
});
return iter__7648__auto__(cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state)));
})());
});
/**
 * Register the event handlers for `map`.
 */
burningswell.web.ui.google_map.register_event_handlers = (function burningswell$web$ui$google_map$register_event_handlers(state){
var seq__50177_50187 = cljs.core.seq(burningswell.web.ui.google_map.event_handlers(state));
var chunk__50178_50188 = null;
var count__50179_50189 = (0);
var i__50180_50190 = (0);
while(true){
if((i__50180_50190 < count__50179_50189)){
var vec__50181_50191 = chunk__50178_50188.cljs$core$IIndexed$_nth$arity$2(null,i__50180_50190);
var handler_50192 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50181_50191,(0),null);
var callback_50193 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50181_50191,(1),null);
cljs.core.cst$kw$burningswell$web$ui$google_DASH_map_SLASH_map.cljs$core$IFn$_invoke$arity$1(state).addListener(burningswell.web.ui.google_map.event_name(handler_50192),((function (seq__50177_50187,chunk__50178_50188,count__50179_50189,i__50180_50190,vec__50181_50191,handler_50192,callback_50193){
return (function (p1__50165_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(callback_50193,cljs.core.cst$kw$burningswell$web$ui$google_DASH_map_SLASH_map.cljs$core$IFn$_invoke$arity$1(state),p1__50165_SHARP_);
});})(seq__50177_50187,chunk__50178_50188,count__50179_50189,i__50180_50190,vec__50181_50191,handler_50192,callback_50193))
);

var G__50204 = seq__50177_50187;
var G__50205 = chunk__50178_50188;
var G__50206 = count__50179_50189;
var G__50207 = (i__50180_50190 + (1));
seq__50177_50187 = G__50204;
chunk__50178_50188 = G__50205;
count__50179_50189 = G__50206;
i__50180_50190 = G__50207;
continue;
} else {
var temp__6369__auto___50208 = cljs.core.seq(seq__50177_50187);
if(temp__6369__auto___50208){
var seq__50177_50209__$1 = temp__6369__auto___50208;
if(cljs.core.chunked_seq_QMARK_(seq__50177_50209__$1)){
var c__7697__auto___50210 = cljs.core.chunk_first(seq__50177_50209__$1);
var G__50211 = cljs.core.chunk_rest(seq__50177_50209__$1);
var G__50212 = c__7697__auto___50210;
var G__50213 = cljs.core.count(c__7697__auto___50210);
var G__50214 = (0);
seq__50177_50187 = G__50211;
chunk__50178_50188 = G__50212;
count__50179_50189 = G__50213;
i__50180_50190 = G__50214;
continue;
} else {
var vec__50184_50215 = cljs.core.first(seq__50177_50209__$1);
var handler_50216 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50184_50215,(0),null);
var callback_50217 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50184_50215,(1),null);
cljs.core.cst$kw$burningswell$web$ui$google_DASH_map_SLASH_map.cljs$core$IFn$_invoke$arity$1(state).addListener(burningswell.web.ui.google_map.event_name(handler_50216),((function (seq__50177_50187,chunk__50178_50188,count__50179_50189,i__50180_50190,vec__50184_50215,handler_50216,callback_50217,seq__50177_50209__$1,temp__6369__auto___50208){
return (function (p1__50165_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$3(callback_50217,cljs.core.cst$kw$burningswell$web$ui$google_DASH_map_SLASH_map.cljs$core$IFn$_invoke$arity$1(state),p1__50165_SHARP_);
});})(seq__50177_50187,chunk__50178_50188,count__50179_50189,i__50180_50190,vec__50184_50215,handler_50216,callback_50217,seq__50177_50209__$1,temp__6369__auto___50208))
);

var G__50221 = cljs.core.next(seq__50177_50209__$1);
var G__50222 = null;
var G__50223 = (0);
var G__50224 = (0);
seq__50177_50187 = G__50221;
chunk__50178_50188 = G__50222;
count__50179_50189 = G__50223;
i__50180_50190 = G__50224;
continue;
}
} else {
}
}
break;
}

return state;
});
/**
 * Return the options from `state`.
 */
burningswell.web.ui.google_map.options = (function burningswell$web$ui$google_map$options(state){
return cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state));
});
/**
 * Return the location from `state`.
 */
burningswell.web.ui.google_map.location = (function burningswell$web$ui$google_map$location(state){
return cljs.core.cst$kw$location.cljs$core$IFn$_invoke$arity$1(cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state)));
});
/**
 * Set the map center to `location`.
 */
burningswell.web.ui.google_map.set_center_BANG_ = (function burningswell$web$ui$google_map$set_center_BANG_(state,location){
return cljs.core.cst$kw$burningswell$web$ui$google_DASH_map_SLASH_map.cljs$core$IFn$_invoke$arity$1(state).setCenter(burningswell.web.ui.google_map.point__GT_lat_lng(location));
});
/**
 * The google-map mixin.
 */
burningswell.web.ui.google_map.google_map_mixin = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$did_DASH_mount,(function (state){
return burningswell.web.ui.google_map.register_event_handlers(cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$burningswell$web$ui$google_DASH_map_SLASH_map,burningswell.web.ui.google_map.make_map(state)));
}),cljs.core.cst$kw$did_DASH_remount,(function (old_state,new_state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(burningswell.web.ui.google_map.location(old_state),burningswell.web.ui.google_map.location(new_state))){
} else {
burningswell.web.ui.google_map.set_center_BANG_(new_state,burningswell.web.ui.google_map.location(new_state));
}

return new_state;
}),cljs.core.cst$kw$will_DASH_unmount,(function (state){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(state,cljs.core.cst$kw$burningswell$web$ui$google_DASH_map_SLASH_map);
})], null);
/**
 * Render an image.
 */
burningswell.web.ui.google_map.google_map = rum.core.build_defc((function (opts){
var G__50232 = "div";
var G__50233 = ({"ref": "map", "className": sablono.util.join_classes(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["class",opts], null))});
return React.createElement(G__50232,G__50233);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$,burningswell.web.ui.google_map.google_map_mixin], null),"google-map");
