// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.ui.diaporama');
goog.require('cljs.core');
goog.require('goog.object');
goog.require('rum.core');
burningswell.web.ui.diaporama.transitions = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$html_url,cljs.core.cst$kw$glsl,cljs.core.cst$kw$uniforms,cljs.core.cst$kw$name,cljs.core.cst$kw$updated_at,cljs.core.cst$kw$id,cljs.core.cst$kw$stars,cljs.core.cst$kw$owner,cljs.core.cst$kw$created_at],["https://gist.github.com/3da654388c3f3cd031c0","#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D from, to;\nuniform float progress;\nuniform vec2 resolution;\n\nuniform vec3 color;\n\nvoid main() {\n  vec2 p = gl_FragCoord.xy / resolution.xy;\n  gl_FragColor = mix(\n    texture2D(from, p) + vec4(progress*color, 1.0),\n    texture2D(to, p) + vec4((1.0-progress)*color, 1.0),\n    progress);\n}",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$color,new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [0.9,0.4,0.2], null)], null),"burn","2015-12-04T07:14:12Z","3da654388c3f3cd031c0",1.0,"gre","2014-05-20T09:06:02Z"]),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$html_url,cljs.core.cst$kw$glsl,cljs.core.cst$kw$uniforms,cljs.core.cst$kw$name,cljs.core.cst$kw$updated_at,cljs.core.cst$kw$id,cljs.core.cst$kw$stars,cljs.core.cst$kw$owner,cljs.core.cst$kw$created_at],["https://gist.github.com/b86b90161503a0023231","// Converted from https://github.com/rectalogic/rendermix-basic-effects/blob/master/assets/com/rendermix/CrossZoom/CrossZoom.frag\n// Which is based on https://github.com/evanw/glfx.js/blob/master/src/filters/blur/zoomblur.js\n// With additional easing functions from https://github.com/rectalogic/rendermix-basic-effects/blob/master/assets/com/rendermix/Easing/Easing.glsllib\n\n#ifdef GL_ES\nprecision highp float;\n#endif\nuniform sampler2D from, to;\nuniform float progress;\nuniform vec2 resolution;\n\nuniform float strength;\n\nconst float PI = 3.141592653589793;\n\nfloat Linear_ease(in float begin, in float change, in float duration, in float time) {\n    return change * time / duration + begin;\n}\n\nfloat Exponential_easeInOut(in float begin, in float change, in float duration, in float time) {\n    if (time == 0.0)\n        return begin;\n    else if (time == duration)\n        return begin + change;\n    time = time / (duration / 2.0);\n    if (time < 1.0)\n        return change / 2.0 * pow(2.0, 10.0 * (time - 1.0)) + begin;\n    return change / 2.0 * (-pow(2.0, -10.0 * (time - 1.0)) + 2.0) + begin;\n}\n\nfloat Sinusoidal_easeInOut(in float begin, in float change, in float duration, in float time) {\n    return -change / 2.0 * (cos(PI * time / duration) - 1.0) + begin;\n}\n\n/* random number between 0 and 1 */\nfloat random(in vec3 scale, in float seed) {\n    /* use the fragment position for randomness */\n    return fract(sin(dot(gl_FragCoord.xyz + seed, scale)) * 43758.5453 + seed);\n}\n\nvec3 crossFade(in vec2 uv, in float dissolve) {\n    return mix(texture2D(from, uv).rgb, texture2D(to, uv).rgb, dissolve);\n}\n\nvoid main() {\n    vec2 texCoord = gl_FragCoord.xy / resolution.xy;\n\n    // Linear interpolate center across center half of the image\n    vec2 center = vec2(Linear_ease(0.25, 0.5, 1.0, progress), 0.5);\n    float dissolve = Exponential_easeInOut(0.0, 1.0, 1.0, progress);\n\n    // Mirrored sinusoidal loop. 0->strength then strength->0\n    float strength = Sinusoidal_easeInOut(0.0, strength, 0.5, progress);\n\n    vec3 color = vec3(0.0);\n    float total = 0.0;\n    vec2 toCenter = center - texCoord;\n\n    /* randomize the lookup values to hide the fixed number of samples */\n    float offset = random(vec3(12.9898, 78.233, 151.7182), 0.0);\n\n    for (float t = 0.0; t <= 40.0; t++) {\n        float percent = (t + offset) / 40.0;\n        float weight = 4.0 * (percent - percent * percent);\n        color += crossFade(texCoord + toCenter * percent * strength, dissolve) * weight;\n        total += weight;\n    }\n    gl_FragColor = vec4(color / total, 1.0);\n}",new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$strength,0.4], null),"CrossZoom","2016-02-02T03:25:07Z","b86b90161503a0023231",5.0,"rectalogic","2014-05-25T01:24:39Z"])], null);
/**
 * The diaporama mixin.
 */
burningswell.web.ui.diaporama.diaporama_mixin = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$did_DASH_mount,(function (state){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(state,cljs.core.cst$kw$diaporama,(new Diaporama(rum.core.ref_node(state,"diaporama"),null,cljs.core.clj__GT_js(cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state))))));
}),cljs.core.cst$kw$did_DASH_remount,(function (old_state,new_state){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(old_state)),cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(new_state)))){
} else {
var seq__49814_49831 = cljs.core.seq(cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(new_state)));
var chunk__49815_49832 = null;
var count__49816_49833 = (0);
var i__49817_49834 = (0);
while(true){
if((i__49817_49834 < count__49816_49833)){
var vec__49818_49840 = chunk__49815_49832.cljs$core$IIndexed$_nth$arity$2(null,i__49817_49834);
var k_49841 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49818_49840,(0),null);
var v_49842 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49818_49840,(1),null);
var G__49821_49843 = cljs.core.cst$kw$diaporama.cljs$core$IFn$_invoke$arity$1(new_state);
var G__49822_49844 = cljs.core.name(k_49841);
var G__49823_49845 = cljs.core.clj__GT_js(v_49842);
goog.object.set(G__49821_49843,G__49822_49844,G__49823_49845);

var G__49846 = seq__49814_49831;
var G__49847 = chunk__49815_49832;
var G__49848 = count__49816_49833;
var G__49849 = (i__49817_49834 + (1));
seq__49814_49831 = G__49846;
chunk__49815_49832 = G__49847;
count__49816_49833 = G__49848;
i__49817_49834 = G__49849;
continue;
} else {
var temp__6369__auto___49853 = cljs.core.seq(seq__49814_49831);
if(temp__6369__auto___49853){
var seq__49814_49854__$1 = temp__6369__auto___49853;
if(cljs.core.chunked_seq_QMARK_(seq__49814_49854__$1)){
var c__7697__auto___49857 = cljs.core.chunk_first(seq__49814_49854__$1);
var G__49858 = cljs.core.chunk_rest(seq__49814_49854__$1);
var G__49859 = c__7697__auto___49857;
var G__49860 = cljs.core.count(c__7697__auto___49857);
var G__49861 = (0);
seq__49814_49831 = G__49858;
chunk__49815_49832 = G__49859;
count__49816_49833 = G__49860;
i__49817_49834 = G__49861;
continue;
} else {
var vec__49824_49862 = cljs.core.first(seq__49814_49854__$1);
var k_49863 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49824_49862,(0),null);
var v_49864 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49824_49862,(1),null);
var G__49827_49865 = cljs.core.cst$kw$diaporama.cljs$core$IFn$_invoke$arity$1(new_state);
var G__49828_49866 = cljs.core.name(k_49863);
var G__49829_49867 = cljs.core.clj__GT_js(v_49864);
goog.object.set(G__49827_49865,G__49828_49866,G__49829_49867);

var G__49871 = cljs.core.next(seq__49814_49854__$1);
var G__49872 = null;
var G__49873 = (0);
var G__49874 = (0);
seq__49814_49831 = G__49871;
chunk__49815_49832 = G__49872;
count__49816_49833 = G__49873;
i__49817_49834 = G__49874;
continue;
}
} else {
}
}
break;
}
}

return new_state;
}),cljs.core.cst$kw$will_DASH_unmount,(function (state){
var G__49830_49877 = state;
var G__49830_49878__$1 = (((G__49830_49877 == null))?null:cljs.core.cst$kw$diaporama.cljs$core$IFn$_invoke$arity$1(G__49830_49877));
if((G__49830_49878__$1 == null)){
} else {
G__49830_49878__$1.destroy();
}

return state;
})], null);
/**
 * Render an image.
 */
burningswell.web.ui.diaporama.diaporama = rum.core.build_defc((function (opts){
var G__49881 = "div";
var G__49882 = ({"key": cljs.core.cst$kw$key.cljs$core$IFn$_invoke$arity$1(opts), "ref": "diaporama", "style": ({"minHeight": "100%"}), "className": sablono.util.join_classes(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [[cljs.core.str(cljs.core.cst$kw$class.cljs$core$IFn$_invoke$arity$1(opts))].join('')], null))});
return React.createElement(G__49881,G__49882);
}),new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$,burningswell.web.ui.diaporama.diaporama_mixin], null),"diaporama");
