// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.ui.auto_complete');
goog.require('cljs.core');
goog.require('goog.events.KeyCodes');
goog.require('rum.core');
goog.require('rum.mdl');
/**
 * Return the query from `state`.
 */
burningswell.web.ui.auto_complete.query = (function burningswell$web$ui$auto_complete$query(state){
return cljs.core.first(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state));
});
/**
 * Return the query results from `state`.
 */
burningswell.web.ui.auto_complete.results = (function burningswell$web$ui$auto_complete$results(state){
return cljs.core.second(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state));
});
/**
 * Return the options from `state`.
 */
burningswell.web.ui.auto_complete.options = (function burningswell$web$ui$auto_complete$options(state){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$rum_SLASH_args.cljs$core$IFn$_invoke$arity$1(state),(2),null);
});
/**
 * Return the index from `state`.
 */
burningswell.web.ui.auto_complete.index = (function burningswell$web$ui$auto_complete$index(state){
return cljs.core.cst$kw$index.cljs$core$IFn$_invoke$arity$1((function (){var G__49224 = cljs.core.cst$kw$auto_DASH_complete.cljs$core$IFn$_invoke$arity$1(state);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__49224) : cljs.core.deref.call(null,G__49224));
})());
});
/**
 * Set the auto complete index.
 */
burningswell.web.ui.auto_complete.set_index_BANG_ = (function burningswell$web$ui$auto_complete$set_index_BANG_(state,index){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$auto_DASH_complete.cljs$core$IFn$_invoke$arity$1(state),cljs.core.assoc,cljs.core.cst$kw$index,index);
});
/**
 * Set the :show-results? flag.
 */
burningswell.web.ui.auto_complete.set_show_results_BANG_ = (function burningswell$web$ui$auto_complete$set_show_results_BANG_(state,show_results_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$auto_DASH_complete.cljs$core$IFn$_invoke$arity$1(state),cljs.core.assoc,cljs.core.cst$kw$show_DASH_results_QMARK_,show_results_QMARK_);
});
/**
 * Set the :loading? flag.
 */
burningswell.web.ui.auto_complete.set_loading_BANG_ = (function burningswell$web$ui$auto_complete$set_loading_BANG_(state,loading_QMARK_){
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(cljs.core.cst$kw$auto_DASH_complete.cljs$core$IFn$_invoke$arity$1(state),cljs.core.assoc,cljs.core.cst$kw$loading_QMARK_,loading_QMARK_);
});
/**
 * Clear the current query.
 */
burningswell.web.ui.auto_complete.on_clear_query = (function burningswell$web$ui$auto_complete$on_clear_query(state,opts){
burningswell.web.ui.auto_complete.set_index_BANG_(state,(-1));

burningswell.web.ui.auto_complete.set_show_results_BANG_(state,false);

burningswell.web.ui.auto_complete.set_loading_BANG_(state,false);

var temp__6369__auto__ = cljs.core.cst$kw$on_DASH_change.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__6369__auto__)){
var handler = temp__6369__auto__;
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(null) : handler.call(null,null));
} else {
return null;
}
});
/**
 * Handle selecting a search result.
 */
burningswell.web.ui.auto_complete.select_result = (function burningswell$web$ui$auto_complete$select_result(state,result){
var temp__6369__auto__ = cljs.core.cst$kw$on_DASH_select.cljs$core$IFn$_invoke$arity$1(burningswell.web.ui.auto_complete.options(state));
if(cljs.core.truth_(temp__6369__auto__)){
var handler = temp__6369__auto__;
burningswell.web.ui.auto_complete.set_show_results_BANG_(state,false);

return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(result) : handler.call(null,result));
} else {
return null;
}
});
/**
 * Handle selecting a search result.
 */
burningswell.web.ui.auto_complete.on_select = (function burningswell$web$ui$auto_complete$on_select(state){
return burningswell.web.ui.auto_complete.select_result(state,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(burningswell.web.ui.auto_complete.results(state),burningswell.web.ui.auto_complete.index(state)));
});
/**
 * Handle submitting a query.
 */
burningswell.web.ui.auto_complete.on_submit = (function burningswell$web$ui$auto_complete$on_submit(state){
var temp__6369__auto__ = cljs.core.cst$kw$on_DASH_submit.cljs$core$IFn$_invoke$arity$1(burningswell.web.ui.auto_complete.options(state));
if(cljs.core.truth_(temp__6369__auto__)){
var handler = temp__6369__auto__;
var G__49253 = burningswell.web.ui.auto_complete.query(state);
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(G__49253) : handler.call(null,G__49253));
} else {
return null;
}
});
/**
 * Handle enter key.
 */
burningswell.web.ui.auto_complete.on_enter_key = (function burningswell$web$ui$auto_complete$on_enter_key(state){
burningswell.web.ui.auto_complete.set_show_results_BANG_(state,false);

burningswell.web.ui.auto_complete.set_loading_BANG_(state,true);

if((burningswell.web.ui.auto_complete.index(state) < (0))){
return burningswell.web.ui.auto_complete.on_submit(state);
} else {
return burningswell.web.ui.auto_complete.on_select(state);
}
});
/**
 * Handle escape key.
 */
burningswell.web.ui.auto_complete.on_escape_key = (function burningswell$web$ui$auto_complete$on_escape_key(state){
burningswell.web.ui.auto_complete.set_show_results_BANG_(state,false);

return burningswell.web.ui.auto_complete.set_loading_BANG_(state,false);
});
/**
 * Move to the next auto complete result.
 */
burningswell.web.ui.auto_complete.select_next = (function burningswell$web$ui$auto_complete$select_next(state){
var next = (burningswell.web.ui.auto_complete.index(state) + (1));
burningswell.web.ui.auto_complete.set_show_results_BANG_(state,true);

if((next < cljs.core.count(burningswell.web.ui.auto_complete.results(state)))){
return burningswell.web.ui.auto_complete.set_index_BANG_(state,next);
} else {
return burningswell.web.ui.auto_complete.set_index_BANG_(state,(-1));
}
});
/**
 * Move to the previous auto complete result.
 */
burningswell.web.ui.auto_complete.select_previous = (function burningswell$web$ui$auto_complete$select_previous(state){
var prev = (burningswell.web.ui.auto_complete.index(state) - (1));
var results = burningswell.web.ui.auto_complete.results(state);
burningswell.web.ui.auto_complete.set_show_results_BANG_(state,true);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prev,(-2))){
return burningswell.web.ui.auto_complete.set_index_BANG_(state,(cljs.core.count(results) - (1)));
} else {
return burningswell.web.ui.auto_complete.set_index_BANG_(state,prev);
}
});
/**
 * Handle query changes.
 */
burningswell.web.ui.auto_complete.on_query_change = (function burningswell$web$ui$auto_complete$on_query_change(state,opts,event){
burningswell.web.ui.auto_complete.set_index_BANG_(state,(-1));

burningswell.web.ui.auto_complete.set_show_results_BANG_(state,true);

burningswell.web.ui.auto_complete.set_loading_BANG_(state,true);

var temp__6369__auto__ = cljs.core.cst$kw$on_DASH_change.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__6369__auto__)){
var handler = temp__6369__auto__;
var G__49294 = event.target.value;
return (handler.cljs$core$IFn$_invoke$arity$1 ? handler.cljs$core$IFn$_invoke$arity$1(G__49294) : handler.call(null,G__49294));
} else {
return null;
}
});
/**
 * Handle key down events.
 */
burningswell.web.ui.auto_complete.on_key_down = (function burningswell$web$ui$auto_complete$on_key_down(state,event){
var pred__49303 = cljs.core._EQ_;
var expr__49304 = event.keyCode;
if(cljs.core.truth_((pred__49303.cljs$core$IFn$_invoke$arity$2 ? pred__49303.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.DOWN,expr__49304) : pred__49303.call(null,goog.events.KeyCodes.DOWN,expr__49304)))){
return burningswell.web.ui.auto_complete.select_next(state);
} else {
if(cljs.core.truth_((pred__49303.cljs$core$IFn$_invoke$arity$2 ? pred__49303.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.ENTER,expr__49304) : pred__49303.call(null,goog.events.KeyCodes.ENTER,expr__49304)))){
return burningswell.web.ui.auto_complete.on_enter_key(state);
} else {
if(cljs.core.truth_((pred__49303.cljs$core$IFn$_invoke$arity$2 ? pred__49303.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.ESC,expr__49304) : pred__49303.call(null,goog.events.KeyCodes.ESC,expr__49304)))){
return burningswell.web.ui.auto_complete.on_escape_key(state);
} else {
if(cljs.core.truth_((pred__49303.cljs$core$IFn$_invoke$arity$2 ? pred__49303.cljs$core$IFn$_invoke$arity$2(goog.events.KeyCodes.UP,expr__49304) : pred__49303.call(null,goog.events.KeyCodes.UP,expr__49304)))){
return burningswell.web.ui.auto_complete.select_previous(state);
} else {
return null;
}
}
}
}
});
/**
 * The auto complete mixin.
 */
burningswell.web.ui.auto_complete.auto_complete_mixin = new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$did_DASH_remount,(function (old_state,new_state){
if((cljs.core.empty_QMARK_(burningswell.web.ui.auto_complete.results(new_state))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(burningswell.web.ui.auto_complete.results(old_state),burningswell.web.ui.auto_complete.results(new_state))) || (cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(burningswell.web.ui.auto_complete.query(old_state),burningswell.web.ui.auto_complete.query(new_state)))){
var G__49335_49337 = (function (){
return burningswell.web.ui.auto_complete.set_loading_BANG_(new_state,false);
});
var G__49336_49338 = (500);
setTimeout(G__49335_49337,G__49336_49338);
} else {
}

return new_state;
})], null);
/**
 * The auto complete local state.
 */
burningswell.web.ui.auto_complete.auto_complete_state = rum.core.local.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$index,(-1),cljs.core.cst$kw$show_DASH_results_QMARK_,false,cljs.core.cst$kw$loading_QMARK_,false], null),cljs.core.cst$kw$auto_DASH_complete);
/**
 * Render an auto complete input field.
 */
burningswell.web.ui.auto_complete.auto_complete = rum.core.build_defcs((function (state,query,results,opts){
var map__49351 = (function (){var G__49352 = cljs.core.cst$kw$auto_DASH_complete.cljs$core$IFn$_invoke$arity$1(state);
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__49352) : cljs.core.deref.call(null,G__49352));
})();
var map__49351__$1 = ((((!((map__49351 == null)))?((((map__49351.cljs$lang$protocol_mask$partition0$ & (64))) || (map__49351.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__49351):map__49351);
var index = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49351__$1,cljs.core.cst$kw$index);
var loading_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49351__$1,cljs.core.cst$kw$loading_QMARK_);
var show_results_QMARK_ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49351__$1,cljs.core.cst$kw$show_DASH_results_QMARK_);
var clear_id = (cljs.core.truth_(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(opts))?[cljs.core.str(cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(opts)),cljs.core.str("__clear")].join(''):null);
var G__49360 = "div";
var G__49361 = ({"className": "auto-complete"});
var G__49362 = (function (){var attrs49354 = (cljs.core.truth_(loading_QMARK_)?(function (){var G__49367 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$mdl,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$single_DASH_color], null),cljs.core.cst$kw$is_DASH_active,true], null);
return (rum.mdl.spinner.cljs$core$IFn$_invoke$arity$1 ? rum.mdl.spinner.cljs$core$IFn$_invoke$arity$1(G__49367) : rum.mdl.spinner.call(null,G__49367));
})():rum.mdl.icon.cljs$core$IFn$_invoke$arity$1("search"));
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(React.createElement,"div",((cljs.core.map_QMARK_(attrs49354))?sablono.interpreter.attributes(sablono.normalize.merge_with_class.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$class,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, ["auto-complete__icon-search"], null)], null),attrs49354], 0))):({"className": "auto-complete__icon-search"})),((cljs.core.map_QMARK_(attrs49354))?null:new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [sablono.interpreter.interpret(attrs49354)], null)));
})();
var G__49363 = sablono.interpreter.create_element("input",({"autoFocus": cljs.core.cst$kw$auto_DASH_focus.cljs$core$IFn$_invoke$arity$1(opts), "type": "text", "onChange": ((function (G__49360,G__49361,G__49362,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (p1__49347_SHARP_){
return burningswell.web.ui.auto_complete.on_query_change(state,opts,p1__49347_SHARP_);
});})(G__49360,G__49361,G__49362,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "onClick": ((function (G__49360,G__49361,G__49362,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.set_show_results_BANG_(state,true);
});})(G__49360,G__49361,G__49362,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "onKeyDown": ((function (G__49360,G__49361,G__49362,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (p1__49348_SHARP_){
return burningswell.web.ui.auto_complete.on_key_down(state,p1__49348_SHARP_);
});})(G__49360,G__49361,G__49362,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "placeholder": cljs.core.cst$kw$placeholder.cljs$core$IFn$_invoke$arity$1(opts), "value": (function (){var or__6794__auto__ = query;
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return "";
}
})(), "ref": "query", "className": "auto-complete__query"}));
var G__49364 = sablono.interpreter.interpret((function (){var G__49370 = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$class,new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, ["auto-complete__clear",null,"mdl-button--icon",null], null), null),cljs.core.cst$kw$id,clear_id,cljs.core.cst$kw$on_DASH_click,((function (G__49360,G__49361,G__49362,G__49363,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.on_clear_query(state,opts);
});})(G__49360,G__49361,G__49362,G__49363,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
], null);
var G__49371 = rum.mdl.icon.cljs$core$IFn$_invoke$arity$1("clear");
return (rum.mdl.button.cljs$core$IFn$_invoke$arity$2 ? rum.mdl.button.cljs$core$IFn$_invoke$arity$2(G__49370,G__49371) : rum.mdl.button.call(null,G__49370,G__49371));
})());
var G__49365 = sablono.interpreter.interpret((function (){var G__49373 = new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$mdl,new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$bottom], null),cljs.core.cst$kw$for,clear_id], null);
var G__49374 = "Clear search";
return (rum.mdl.tooltip.cljs$core$IFn$_invoke$arity$2 ? rum.mdl.tooltip.cljs$core$IFn$_invoke$arity$2(G__49373,G__49374) : rum.mdl.tooltip.call(null,G__49373,G__49374));
})());
var G__49366 = (function (){var G__49375 = "div";
var G__49376 = ({"className": sablono.util.join_classes(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["auto-complete__suggestions",(((cljs.core.empty_QMARK_(results)) || (cljs.core.not(show_results_QMARK_)))?"auto-complete__suggestions--hidden":null)], null))});
var G__49377 = cljs.core.into_array.cljs$core$IFn$_invoke$arity$1((function (){var iter__7648__auto__ = ((function (G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function burningswell$web$ui$auto_complete$iter__49378(s__49379){
return (new cljs.core.LazySeq(null,((function (G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
var s__49379__$1 = s__49379;
while(true){
var temp__6369__auto__ = cljs.core.seq(s__49379__$1);
if(temp__6369__auto__){
var s__49379__$2 = temp__6369__auto__;
if(cljs.core.chunked_seq_QMARK_(s__49379__$2)){
var c__7646__auto__ = cljs.core.chunk_first(s__49379__$2);
var size__7647__auto__ = cljs.core.count(c__7646__auto__);
var b__49381 = cljs.core.chunk_buffer(size__7647__auto__);
if((function (){var i__49380 = (0);
while(true){
if((i__49380 < size__7647__auto__)){
var vec__49401 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__7646__auto__,i__49380);
var current = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49401,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49401,(1),null);
cljs.core.chunk_append(b__49381,(function (){var G__49405 = "div";
var G__49406 = ({"key": [cljs.core.str("auto-complete__result--"),cljs.core.str(current)].join(''), "onClick": ((function (i__49380,G__49405,vec__49401,current,result,c__7646__auto__,size__7647__auto__,b__49381,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.select_result(state,result);
});})(i__49380,G__49405,vec__49401,current,result,c__7646__auto__,size__7647__auto__,b__49381,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "onMouseEnter": ((function (i__49380,G__49405,vec__49401,current,result,c__7646__auto__,size__7647__auto__,b__49381,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.set_index_BANG_(state,current);
});})(i__49380,G__49405,vec__49401,current,result,c__7646__auto__,size__7647__auto__,b__49381,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "onTouchEnd": ((function (i__49380,G__49405,vec__49401,current,result,c__7646__auto__,size__7647__auto__,b__49381,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.select_result(state,result);
});})(i__49380,G__49405,vec__49401,current,result,c__7646__auto__,size__7647__auto__,b__49381,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "className": sablono.util.join_classes(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["auto-complete__result",((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,index))?"auto-complete__result--highlight":null)], null))});
var G__49407 = sablono.interpreter.interpret((function (){var or__6794__auto__ = cljs.core.cst$kw$render.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return cljs.core.pr_str;
}
})().call(null,result));
return React.createElement(G__49405,G__49406,G__49407);
})());

var G__49463 = (i__49380 + (1));
i__49380 = G__49463;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__49381),burningswell$web$ui$auto_complete$iter__49378(cljs.core.chunk_rest(s__49379__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__49381),null);
}
} else {
var vec__49411 = cljs.core.first(s__49379__$2);
var current = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49411,(0),null);
var result = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49411,(1),null);
return cljs.core.cons((function (){var G__49414 = "div";
var G__49415 = ({"key": [cljs.core.str("auto-complete__result--"),cljs.core.str(current)].join(''), "onClick": ((function (G__49414,vec__49411,current,result,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.select_result(state,result);
});})(G__49414,vec__49411,current,result,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "onMouseEnter": ((function (G__49414,vec__49411,current,result,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.set_index_BANG_(state,current);
});})(G__49414,vec__49411,current,result,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "onTouchEnd": ((function (G__49414,vec__49411,current,result,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id){
return (function (){
return burningswell.web.ui.auto_complete.select_result(state,result);
});})(G__49414,vec__49411,current,result,s__49379__$2,temp__6369__auto__,G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
, "className": sablono.util.join_classes(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, ["auto-complete__result",((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(current,index))?"auto-complete__result--highlight":null)], null))});
var G__49416 = sablono.interpreter.interpret((function (){var or__6794__auto__ = cljs.core.cst$kw$render.cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return cljs.core.pr_str;
}
})().call(null,result));
return React.createElement(G__49414,G__49415,G__49416);
})(),burningswell$web$ui$auto_complete$iter__49378(cljs.core.rest(s__49379__$2)));
}
} else {
return null;
}
break;
}
});})(G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
,null,null));
});})(G__49375,G__49376,G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,map__49351,map__49351__$1,index,loading_QMARK_,show_results_QMARK_,clear_id))
;
return iter__7648__auto__(cljs.core.map_indexed.cljs$core$IFn$_invoke$arity$2(cljs.core.vector,results));
})());
return React.createElement(G__49375,G__49376,G__49377);
})();
return React.createElement(G__49360,G__49361,G__49362,G__49363,G__49364,G__49365,G__49366);
}),new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [rum.core.static$,burningswell.web.ui.auto_complete.auto_complete_mixin,burningswell.web.ui.auto_complete.auto_complete_state], null),"auto-complete");
