// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.stores.resources');
goog.require('cljs.core');
goog.require('coolant.core');
goog.require('no.en.core');
/**
 * Return the :id of `resource` as an integer.
 */
burningswell.web.stores.resources.id = (function burningswell$web$stores$resources$id(resource){
var G__49572 = resource;
var G__49572__$1 = (((G__49572 == null))?null:cljs.core.cst$kw$id.cljs$core$IFn$_invoke$arity$1(G__49572));
if((G__49572__$1 == null)){
return null;
} else {
return no.en.core.parse_integer(G__49572__$1);
}
});
/**
 * Return the resource path for `country`.
 */
burningswell.web.stores.resources.country_path = (function burningswell$web$stores$resources$country_path(country){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$country_SLASH_by_DASH_id,burningswell.web.stores.resources.id(country)], null);
});
/**
 * Return the resource path for `photo`.
 */
burningswell.web.stores.resources.photo_path = (function burningswell$web$stores$resources$photo_path(photo){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$photo_SLASH_by_DASH_id,burningswell.web.stores.resources.id(photo)], null);
});
/**
 * Return the resource path for `region`.
 */
burningswell.web.stores.resources.region_path = (function burningswell$web$stores$resources$region_path(region){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$region_SLASH_by_DASH_id,burningswell.web.stores.resources.id(region)], null);
});
/**
 * Return the resource path for `spot`.
 */
burningswell.web.stores.resources.spot_path = (function burningswell$web$stores$resources$spot_path(spot){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$spot_SLASH_by_DASH_id,burningswell.web.stores.resources.id(spot)], null);
});
/**
 * Return the resource path for `user`.
 */
burningswell.web.stores.resources.user_path = (function burningswell$web$stores$resources$user_path(user){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$user_SLASH_by_DASH_id,burningswell.web.stores.resources.id(user)], null);
});
burningswell.web.stores.resources.add_resource = (function burningswell$web$stores$resources$add_resource(path_fn){
return (function (state,resource){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(state,(path_fn.cljs$core$IFn$_invoke$arity$1 ? path_fn.cljs$core$IFn$_invoke$arity$1(resource) : path_fn.call(null,resource)),(function (p1__49575_SHARP_){
return no.en.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__49575_SHARP_,resource], 0));
}));
});
});
burningswell.web.stores.resources.add_resources = (function burningswell$web$stores$resources$add_resources(path_fn){
var add = burningswell.web.stores.resources.add_resource(path_fn);
return ((function (add){
return (function (state,resources){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(add,state,resources);
});
;})(add))
});
/**
 * Update the `resource` in `state` at the path produced by applying
 *   `resource` to `path-fn`.
 */
burningswell.web.stores.resources.update_resource = (function burningswell$web$stores$resources$update_resource(state,resource,path_fn){
return cljs.core.update_in.cljs$core$IFn$_invoke$arity$3(state,(path_fn.cljs$core$IFn$_invoke$arity$1 ? path_fn.cljs$core$IFn$_invoke$arity$1(resource) : path_fn.call(null,resource)),(function (p1__49584_SHARP_){
return no.en.core.deep_merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([p1__49584_SHARP_,resource], 0));
}));
});
/**
 * Update `spot` in `state`.
 */
burningswell.web.stores.resources.update_spot = (function burningswell$web$stores$resources$update_spot(state,spot){
return burningswell.web.stores.resources.update_resource(state,spot,burningswell.web.stores.resources.spot_path);
});
/**
 * Update `photo` in `state`.
 */
burningswell.web.stores.resources.update_photo = (function burningswell$web$stores$resources$update_photo(state,photo){
return burningswell.web.stores.resources.update_resource(state,photo,burningswell.web.stores.resources.photo_path);
});
/**
 * Update the `spots` of a region in `state`.
 */
burningswell.web.stores.resources.update_region_spots = (function burningswell$web$stores$resources$update_region_spots(state,p__49592){
var vec__49596 = p__49592;
var region = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49596,(0),null);
var spots = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49596,(1),null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(burningswell.web.stores.resources.update_spot,state,spots);
});
/**
 * Update the `spots` around a `spot`.
 */
burningswell.web.stores.resources.update_spot_spots = (function burningswell$web$stores$resources$update_spot_spots(state,p__49602){
var vec__49606 = p__49602;
var region = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49606,(0),null);
var spots = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49606,(1),null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(burningswell.web.stores.resources.update_spot,state,spots);
});
/**
 * Update the `spots` around a `spot`.
 */
burningswell.web.stores.resources.update_spot_photos = (function burningswell$web$stores$resources$update_spot_photos(state,p__49609){
var vec__49613 = p__49609;
var region = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49613,(0),null);
var photos = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49613,(1),null);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(burningswell.web.stores.resources.update_photo,state,photos);
});
/**
 * Get a resource from `store` by `path`.
 */
burningswell.web.stores.resources.resource = (function burningswell$web$stores$resources$resource(store,path){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(store,path);
});
/**
 * Get a resources from `store` by `paths`.
 */
burningswell.web.stores.resources.resources = (function burningswell$web$stores$resources$resources(store,paths){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__49625_SHARP_){
return cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(store,p1__49625_SHARP_);
}),paths);
});
/**
 * The resources store.
 */
burningswell.web.stores.resources.store = coolant.core.store(cljs.core.cst$kw$resources,new cljs.core.PersistentArrayMap(null, 5, [cljs.core.cst$kw$country_SLASH_by_DASH_id,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$photo_SLASH_by_DASH_id,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$region_SLASH_by_DASH_id,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$spot_SLASH_by_DASH_id,cljs.core.PersistentArrayMap.EMPTY,cljs.core.cst$kw$user_SLASH_by_DASH_id,cljs.core.PersistentArrayMap.EMPTY], null),cljs.core.PersistentHashMap.fromArrays([cljs.core.cst$kw$spot_SLASH_spots,cljs.core.cst$kw$country_SLASH_regions,cljs.core.cst$kw$spots_SLASH_list,cljs.core.cst$kw$countries_SLASH_list,cljs.core.cst$kw$regions_SLASH_list,cljs.core.cst$kw$region_SLASH_spots,cljs.core.cst$kw$spot_SLASH_photos,cljs.core.cst$kw$country_SLASH_country,cljs.core.cst$kw$region_SLASH_region,cljs.core.cst$kw$spot_SLASH_spot],[burningswell.web.stores.resources.update_spot_spots,burningswell.web.stores.resources.add_resources(burningswell.web.stores.resources.region_path),burningswell.web.stores.resources.add_resources(burningswell.web.stores.resources.spot_path),burningswell.web.stores.resources.add_resources(burningswell.web.stores.resources.country_path),burningswell.web.stores.resources.add_resources(burningswell.web.stores.resources.region_path),burningswell.web.stores.resources.update_region_spots,burningswell.web.stores.resources.update_spot_photos,burningswell.web.stores.resources.add_resource(burningswell.web.stores.resources.country_path),burningswell.web.stores.resources.add_resource(burningswell.web.stores.resources.region_path),burningswell.web.stores.resources.add_resource(burningswell.web.stores.resources.spot_path)]));
