// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.service_worker');
goog.require('cljs.core');
goog.require('burningswell.web.logging');
goog.require('com.stuartsierra.component');
/**
 * The logger of the current namespace.
 */
burningswell.web.service_worker.logger = burningswell.web.logging.logger("burningswell.web.service-worker");
/**
 * The URL of the service worker JavaScript.
 */
burningswell.web.service_worker.service_worker_url = "/javascripts/service-worker.js";
/**
 * Returns true if service worker is supported, otherwise false.
 */
burningswell.web.service_worker.service_worker_QMARK_ = (function burningswell$web$service_worker$service_worker_QMARK_(){
return cljs.core.some_QMARK_((navigator["serviceWorker"]));
});
/**
 * Register the service worker at `url`.
 */
burningswell.web.service_worker.register_service_worker = (function burningswell$web$service_worker$register_service_worker(url){
return navigator.serviceWorker.register(url).then((function (){
return burningswell.web.logging.info(burningswell.web.service_worker.logger,"Service worker registered.");
}),(function (error){
burningswell.web.logging.error(burningswell.web.service_worker.logger,"Service worker registration failed.");

return burningswell.web.logging.error(burningswell.web.service_worker.logger,error);
}));
});
if(cljs.core.truth_(burningswell.web.service_worker.service_worker_QMARK_())){
burningswell.web.service_worker.register_service_worker(burningswell.web.service_worker.service_worker_url);
} else {
}

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {com.stuartsierra.component.Lifecycle}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
burningswell.web.service_worker.ServiceWorker = (function (__meta,__extmap,__hash){
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2229667594;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__7464__auto__,k__7465__auto__){
var self__ = this;
var this__7464__auto____$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(this__7464__auto____$1,k__7465__auto__,null);
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__7466__auto__,k49747,else__7467__auto__){
var self__ = this;
var this__7466__auto____$1 = this;
var G__49749 = k49747;
switch (G__49749) {
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49747,else__7467__auto__);

}
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__7478__auto__,writer__7479__auto__,opts__7480__auto__){
var self__ = this;
var this__7478__auto____$1 = this;
var pr_pair__7481__auto__ = ((function (this__7478__auto____$1){
return (function (keyval__7482__auto__){
return cljs.core.pr_sequential_writer(writer__7479__auto__,cljs.core.pr_writer,""," ","",opts__7480__auto__,keyval__7482__auto__);
});})(this__7478__auto____$1))
;
return cljs.core.pr_sequential_writer(writer__7479__auto__,pr_pair__7481__auto__,"#burningswell.web.service-worker.ServiceWorker{",", ","}",opts__7480__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IIterable$ = true;

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49746){
var self__ = this;
var G__49746__$1 = this;
return (new cljs.core.RecordIter((0),G__49746__$1,0,cljs.core.PersistentVector.EMPTY,cljs.core._iterator(self__.__extmap)));
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__7462__auto__){
var self__ = this;
var this__7462__auto____$1 = this;
return self__.__meta;
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__7458__auto__){
var self__ = this;
var this__7458__auto____$1 = this;
return (new burningswell.web.service_worker.ServiceWorker(self__.__meta,self__.__extmap,self__.__hash));
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__7468__auto__){
var self__ = this;
var this__7468__auto____$1 = this;
return (0 + cljs.core.count(self__.__extmap));
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__7459__auto__){
var self__ = this;
var this__7459__auto____$1 = this;
var h__7231__auto__ = self__.__hash;
if(!((h__7231__auto__ == null))){
return h__7231__auto__;
} else {
var h__7231__auto____$1 = cljs.core.hash_imap(this__7459__auto____$1);
self__.__hash = h__7231__auto____$1;

return h__7231__auto____$1;
}
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this__7460__auto__,other__7461__auto__){
var self__ = this;
var this__7460__auto____$1 = this;
if(cljs.core.truth_((function (){var and__6782__auto__ = other__7461__auto__;
if(cljs.core.truth_(and__6782__auto__)){
var and__6782__auto____$1 = (this__7460__auto____$1.constructor === other__7461__auto__.constructor);
if(and__6782__auto____$1){
return cljs.core.equiv_map(this__7460__auto____$1,other__7461__auto__);
} else {
return and__6782__auto____$1;
}
} else {
return and__6782__auto__;
}
})())){
return true;
} else {
return false;
}
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__7473__auto__,k__7474__auto__){
var self__ = this;
var this__7473__auto____$1 = this;
if(cljs.core.contains_QMARK_(cljs.core.PersistentHashSet.EMPTY,k__7474__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core.with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__7473__auto____$1),self__.__meta),k__7474__auto__);
} else {
return (new burningswell.web.service_worker.ServiceWorker(self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__7474__auto__)),null));
}
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__7471__auto__,k__7472__auto__,G__49746){
var self__ = this;
var this__7471__auto____$1 = this;
var pred__49750 = cljs.core.keyword_identical_QMARK_;
var expr__49751 = k__7472__auto__;
return (new burningswell.web.service_worker.ServiceWorker(self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__7472__auto__,G__49746),null));
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__7476__auto__){
var self__ = this;
var this__7476__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,self__.__extmap));
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__7463__auto__,G__49746){
var self__ = this;
var this__7463__auto____$1 = this;
return (new burningswell.web.service_worker.ServiceWorker(G__49746,self__.__extmap,self__.__hash));
});

burningswell.web.service_worker.ServiceWorker.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__7469__auto__,entry__7470__auto__){
var self__ = this;
var this__7469__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__7470__auto__)){
return cljs.core._assoc(this__7469__auto____$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7470__auto__,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry__7470__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__7469__auto____$1,entry__7470__auto__);
}
});

burningswell.web.service_worker.ServiceWorker.prototype.com$stuartsierra$component$Lifecycle$ = true;

burningswell.web.service_worker.ServiceWorker.prototype.com$stuartsierra$component$Lifecycle$start$arity$1 = (function (worker){
var self__ = this;
var worker__$1 = this;
if(cljs.core.truth_(burningswell.web.service_worker.service_worker_QMARK_())){
burningswell.web.service_worker.register_service_worker(burningswell.web.service_worker.service_worker_url);
} else {
}

burningswell.web.logging.info(burningswell.web.service_worker.logger,"Service worker started.");

return worker__$1;
});

burningswell.web.service_worker.ServiceWorker.prototype.com$stuartsierra$component$Lifecycle$stop$arity$1 = (function (worker){
var self__ = this;
var worker__$1 = this;
burningswell.web.logging.info(burningswell.web.service_worker.logger,"Service worker stopped.");

return worker__$1;
});

burningswell.web.service_worker.ServiceWorker.getBasis = (function (){
return cljs.core.PersistentVector.EMPTY;
});

burningswell.web.service_worker.ServiceWorker.cljs$lang$type = true;

burningswell.web.service_worker.ServiceWorker.cljs$lang$ctorPrSeq = (function (this__7500__auto__){
return cljs.core._conj(cljs.core.List.EMPTY,"burningswell.web.service-worker/ServiceWorker");
});

burningswell.web.service_worker.ServiceWorker.cljs$lang$ctorPrWriter = (function (this__7500__auto__,writer__7501__auto__){
return cljs.core._write(writer__7501__auto__,"burningswell.web.service-worker/ServiceWorker");
});

burningswell.web.service_worker.__GT_ServiceWorker = (function burningswell$web$service_worker$__GT_ServiceWorker(){
return (new burningswell.web.service_worker.ServiceWorker(null,null,null));
});

burningswell.web.service_worker.map__GT_ServiceWorker = (function burningswell$web$service_worker$map__GT_ServiceWorker(G__49748){
return (new burningswell.web.service_worker.ServiceWorker(null,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$1(G__49748),null));
});

/**
 * Return a new service worker component.
 */
burningswell.web.service_worker.service_worker = (function burningswell$web$service_worker$service_worker(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49781 = arguments.length;
var i__7978__auto___49782 = (0);
while(true){
if((i__7978__auto___49782 < len__7977__auto___49781)){
args__7984__auto__.push((arguments[i__7978__auto___49782]));

var G__49785 = (i__7978__auto___49782 + (1));
i__7978__auto___49782 = G__49785;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((0) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((0)),(0),null)):null);
return burningswell.web.service_worker.service_worker.cljs$core$IFn$_invoke$arity$variadic(argseq__7985__auto__);
});

burningswell.web.service_worker.service_worker.cljs$core$IFn$_invoke$arity$variadic = (function (p__49777){
var vec__49778 = p__49777;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49778,(0),null);
return burningswell.web.service_worker.map__GT_ServiceWorker(opts);
});

burningswell.web.service_worker.service_worker.cljs$lang$maxFixedArity = (0);

burningswell.web.service_worker.service_worker.cljs$lang$applyTo = (function (seq49776){
return burningswell.web.service_worker.service_worker.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49776));
});

