// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.api');
goog.require('cljs.core');
goog.require('burningswell.api.client');
goog.require('burningswell.web.getter.core');
goog.require('coolant.core');
goog.require('request.core');
/**
 * The pagination params based on breakpoint type.
 */
burningswell.web.api.pagination_params = new cljs.core.PersistentArrayMap(null, 3, [cljs.core.cst$kw$collection,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$xxl,(42),cljs.core.cst$kw$xl,(36),cljs.core.cst$kw$l,(30),cljs.core.cst$kw$m,(25),cljs.core.cst$kw$s,(18),cljs.core.cst$kw$xs,(12),cljs.core.cst$kw$xxs,(8)], null),cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$xxl,(28),cljs.core.cst$kw$xl,(24),cljs.core.cst$kw$l,(20),cljs.core.cst$kw$m,(16),cljs.core.cst$kw$s,(15),cljs.core.cst$kw$xs,(10),cljs.core.cst$kw$xxs,(8)], null),cljs.core.cst$kw$spots_DASH_around,new cljs.core.PersistentArrayMap(null, 7, [cljs.core.cst$kw$xxl,(15),cljs.core.cst$kw$xl,(12),cljs.core.cst$kw$l,(9),cljs.core.cst$kw$m,(6),cljs.core.cst$kw$s,(6),cljs.core.cst$kw$xs,(12),cljs.core.cst$kw$xxs,(1)], null)], null);
/**
 * Return the pagination params for the spots around a spot.
 */
burningswell.web.api.pagination = (function burningswell$web$api$pagination(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49806 = arguments.length;
var i__7978__auto___49807 = (0);
while(true){
if((i__7978__auto___49807 < len__7977__auto___49806)){
args__7984__auto__.push((arguments[i__7978__auto___49807]));

var G__49811 = (i__7978__auto___49807 + (1));
i__7978__auto___49807 = G__49811;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.pagination.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.pagination.cljs$core$IFn$_invoke$arity$variadic = (function (system,type,p__49802){
var vec__49803 = p__49802;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49803,(0),null);
var layout = cljs.core.cst$kw$layout.cljs$core$IFn$_invoke$arity$1(coolant.core.evaluate(cljs.core.cst$kw$coolant.cljs$core$IFn$_invoke$arity$1(system),burningswell.web.getter.core.layout));
var per_page = (function (){var or__6794__auto__ = cljs.core.get_in.cljs$core$IFn$_invoke$arity$2(burningswell.web.api.pagination_params,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [type,layout], null));
if(cljs.core.truth_(or__6794__auto__)){
return or__6794__auto__;
} else {
return (16);
}
})();
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$page,(1),cljs.core.cst$kw$per_DASH_page,per_page], null),params], 0));
});

burningswell.web.api.pagination.cljs$lang$maxFixedArity = (2);

burningswell.web.api.pagination.cljs$lang$applyTo = (function (seq49795){
var G__49796 = cljs.core.first(seq49795);
var seq49795__$1 = cljs.core.next(seq49795);
var G__49797 = cljs.core.first(seq49795__$1);
var seq49795__$2 = cljs.core.next(seq49795__$1);
return burningswell.web.api.pagination.cljs$core$IFn$_invoke$arity$variadic(G__49796,G__49797,seq49795__$2);
});

/**
 * Return the API client from `system`.
 */
burningswell.web.api.api = (function burningswell$web$api$api(system){
var temp__6367__auto__ = coolant.core.evaluate(cljs.core.cst$kw$coolant.cljs$core$IFn$_invoke$arity$1(system),burningswell.web.getter.core.auth_token);
if(cljs.core.truth_(temp__6367__auto__)){
var token = temp__6367__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.cst$kw$api_DASH_client.cljs$core$IFn$_invoke$arity$1(system),cljs.core.cst$kw$auth_DASH_token,token);
} else {
return cljs.core.cst$kw$api_DASH_client.cljs$core$IFn$_invoke$arity$1(system);
}
});
/**
 * Create a new user.
 */
burningswell.web.api.create_user = (function burningswell$web$api$create_user(system,user){
return request.core.post.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$api_DASH_client.cljs$core$IFn$_invoke$arity$1(system),cljs.core.array_seq([cljs.core.cst$kw$users,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transit_DASH_params,user], null)], 0));
});
/**
 * Create a new JWS token.
 */
burningswell.web.api.create_jws_token = (function burningswell$web$api$create_jws_token(system,user){
var auth = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.cst$kw$login.cljs$core$IFn$_invoke$arity$1(user),cljs.core.cst$kw$password.cljs$core$IFn$_invoke$arity$1(user)], null);
return request.core.post.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$api_DASH_client.cljs$core$IFn$_invoke$arity$1(system),cljs.core.array_seq([cljs.core.cst$kw$jwt_DASH_token,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$basic_DASH_auth,auth], null)], 0));
});
/**
 * Create a new surf session.
 */
burningswell.web.api.create_session = (function burningswell$web$api$create_session(system,session){
return request.core.post.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$sessions,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$transit_DASH_params,session], null)], 0));
});
/**
 * Create a new spot.
 */
burningswell.web.api.create_spot = (function burningswell$web$api$create_spot(system,user,spot){
return request.core.post.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spots,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$auth_DASH_token,cljs.core.cst$kw$auth_DASH_token.cljs$core$IFn$_invoke$arity$1(user),cljs.core.cst$kw$transit_DASH_params,spot], null)], 0));
});
/**
 * Fetch countries.
 */
burningswell.web.api.countries = (function burningswell$web$api$countries(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49887 = arguments.length;
var i__7978__auto___49888 = (0);
while(true){
if((i__7978__auto___49888 < len__7977__auto___49887)){
args__7984__auto__.push((arguments[i__7978__auto___49888]));

var G__49889 = (i__7978__auto___49888 + (1));
i__7978__auto___49888 = G__49889;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.api.countries.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.api.countries.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__49883){
var vec__49884 = p__49883;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49884,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$countries,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.countries.cljs$lang$maxFixedArity = (1);

burningswell.web.api.countries.cljs$lang$applyTo = (function (seq49879){
var G__49880 = cljs.core.first(seq49879);
var seq49879__$1 = cljs.core.next(seq49879);
return burningswell.web.api.countries.cljs$core$IFn$_invoke$arity$variadic(G__49880,seq49879__$1);
});

/**
 * Fetch the `country`.
 */
burningswell.web.api.country = (function burningswell$web$api$country(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49924 = arguments.length;
var i__7978__auto___49925 = (0);
while(true){
if((i__7978__auto___49925 < len__7977__auto___49924)){
args__7984__auto__.push((arguments[i__7978__auto___49925]));

var G__49926 = (i__7978__auto___49925 + (1));
i__7978__auto___49925 = G__49926;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.country.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.country.cljs$core$IFn$_invoke$arity$variadic = (function (system,country,p__49920){
var vec__49921 = p__49920;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49921,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$country,country,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.country.cljs$lang$maxFixedArity = (2);

burningswell.web.api.country.cljs$lang$applyTo = (function (seq49905){
var G__49906 = cljs.core.first(seq49905);
var seq49905__$1 = cljs.core.next(seq49905);
var G__49907 = cljs.core.first(seq49905__$1);
var seq49905__$2 = cljs.core.next(seq49905__$1);
return burningswell.web.api.country.cljs$core$IFn$_invoke$arity$variadic(G__49906,G__49907,seq49905__$2);
});

/**
 * Fetch countries, regions or spots based on the zoom query parameter.
 */
burningswell.web.api.map = (function burningswell$web$api$map(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49940 = arguments.length;
var i__7978__auto___49945 = (0);
while(true){
if((i__7978__auto___49945 < len__7977__auto___49940)){
args__7984__auto__.push((arguments[i__7978__auto___49945]));

var G__49951 = (i__7978__auto___49945 + (1));
i__7978__auto___49945 = G__49951;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.api.map.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.api.map.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__49933){
var vec__49934 = p__49933;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49934,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$map,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.map.cljs$lang$maxFixedArity = (1);

burningswell.web.api.map.cljs$lang$applyTo = (function (seq49931){
var G__49932 = cljs.core.first(seq49931);
var seq49931__$1 = cljs.core.next(seq49931);
return burningswell.web.api.map.cljs$core$IFn$_invoke$arity$variadic(G__49932,seq49931__$1);
});

/**
 * Fetch the currently logged in user.
 */
burningswell.web.api.me = (function burningswell$web$api$me(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49959 = arguments.length;
var i__7978__auto___49960 = (0);
while(true){
if((i__7978__auto___49960 < len__7977__auto___49959)){
args__7984__auto__.push((arguments[i__7978__auto___49960]));

var G__49961 = (i__7978__auto___49960 + (1));
i__7978__auto___49960 = G__49961;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.me.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.me.cljs$core$IFn$_invoke$arity$variadic = (function (system,token,p__49955){
var vec__49956 = p__49955;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49956,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$api_DASH_client.cljs$core$IFn$_invoke$arity$1(system),cljs.core.array_seq([cljs.core.cst$kw$me,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$headers,new cljs.core.PersistentArrayMap(null, 1, ["authorization",[cljs.core.str("Token "),cljs.core.str(token)].join('')], null)], null)], 0));
});

burningswell.web.api.me.cljs$lang$maxFixedArity = (2);

burningswell.web.api.me.cljs$lang$applyTo = (function (seq49952){
var G__49953 = cljs.core.first(seq49952);
var seq49952__$1 = cljs.core.next(seq49952);
var G__49954 = cljs.core.first(seq49952__$1);
var seq49952__$2 = cljs.core.next(seq49952__$1);
return burningswell.web.api.me.cljs$core$IFn$_invoke$arity$variadic(G__49953,G__49954,seq49952__$2);
});

/**
 * Fetch the `region`.
 */
burningswell.web.api.region = (function burningswell$web$api$region(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49971 = arguments.length;
var i__7978__auto___49973 = (0);
while(true){
if((i__7978__auto___49973 < len__7977__auto___49971)){
args__7984__auto__.push((arguments[i__7978__auto___49973]));

var G__49976 = (i__7978__auto___49973 + (1));
i__7978__auto___49973 = G__49976;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.region.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.region.cljs$core$IFn$_invoke$arity$variadic = (function (system,region,p__49965){
var vec__49966 = p__49965;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49966,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$region,region,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.region.cljs$lang$maxFixedArity = (2);

burningswell.web.api.region.cljs$lang$applyTo = (function (seq49962){
var G__49963 = cljs.core.first(seq49962);
var seq49962__$1 = cljs.core.next(seq49962);
var G__49964 = cljs.core.first(seq49962__$1);
var seq49962__$2 = cljs.core.next(seq49962__$1);
return burningswell.web.api.region.cljs$core$IFn$_invoke$arity$variadic(G__49963,G__49964,seq49962__$2);
});

/**
 * Fetch regions.
 */
burningswell.web.api.regions = (function burningswell$web$api$regions(var_args){
var args__7984__auto__ = [];
var len__7977__auto___49988 = arguments.length;
var i__7978__auto___49989 = (0);
while(true){
if((i__7978__auto___49989 < len__7977__auto___49988)){
args__7984__auto__.push((arguments[i__7978__auto___49989]));

var G__49990 = (i__7978__auto___49989 + (1));
i__7978__auto___49989 = G__49990;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.api.regions.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.api.regions.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__49982){
var vec__49983 = p__49982;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49983,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$regions,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.regions.cljs$lang$maxFixedArity = (1);

burningswell.web.api.regions.cljs$lang$applyTo = (function (seq49980){
var G__49981 = cljs.core.first(seq49980);
var seq49980__$1 = cljs.core.next(seq49980);
return burningswell.web.api.regions.cljs$core$IFn$_invoke$arity$variadic(G__49981,seq49980__$1);
});

/**
 * Fetch regions in `country`.
 */
burningswell.web.api.regions_in_country = (function burningswell$web$api$regions_in_country(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50009 = arguments.length;
var i__7978__auto___50010 = (0);
while(true){
if((i__7978__auto___50010 < len__7977__auto___50009)){
args__7984__auto__.push((arguments[i__7978__auto___50010]));

var G__50011 = (i__7978__auto___50010 + (1));
i__7978__auto___50010 = G__50011;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.regions_in_country.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.regions_in_country.cljs$core$IFn$_invoke$arity$variadic = (function (system,country,p__50005){
var vec__50006 = p__50005;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50006,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$regions_DASH_in_DASH_country,country,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.regions_in_country.cljs$lang$maxFixedArity = (2);

burningswell.web.api.regions_in_country.cljs$lang$applyTo = (function (seq50000){
var G__50001 = cljs.core.first(seq50000);
var seq50000__$1 = cljs.core.next(seq50000);
var G__50002 = cljs.core.first(seq50000__$1);
var seq50000__$2 = cljs.core.next(seq50000__$1);
return burningswell.web.api.regions_in_country.cljs$core$IFn$_invoke$arity$variadic(G__50001,G__50002,seq50000__$2);
});

/**
 * Search countries, regions and spots.
 */
burningswell.web.api.search_autocomplete = (function burningswell$web$api$search_autocomplete(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50027 = arguments.length;
var i__7978__auto___50028 = (0);
while(true){
if((i__7978__auto___50028 < len__7977__auto___50027)){
args__7984__auto__.push((arguments[i__7978__auto___50028]));

var G__50029 = (i__7978__auto___50028 + (1));
i__7978__auto___50028 = G__50029;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.api.search_autocomplete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.api.search_autocomplete.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__50022){
var vec__50024 = p__50022;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50024,(0),null);
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50024,(1),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$search_DASH_autocomplete,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0))], 0));
});

burningswell.web.api.search_autocomplete.cljs$lang$maxFixedArity = (1);

burningswell.web.api.search_autocomplete.cljs$lang$applyTo = (function (seq50017){
var G__50018 = cljs.core.first(seq50017);
var seq50017__$1 = cljs.core.next(seq50017);
return burningswell.web.api.search_autocomplete.cljs$core$IFn$_invoke$arity$variadic(G__50018,seq50017__$1);
});

/**
 * Search countries, regions and spots.
 */
burningswell.web.api.search_details = (function burningswell$web$api$search_details(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50041 = arguments.length;
var i__7978__auto___50042 = (0);
while(true){
if((i__7978__auto___50042 < len__7977__auto___50041)){
args__7984__auto__.push((arguments[i__7978__auto___50042]));

var G__50043 = (i__7978__auto___50042 + (1));
i__7978__auto___50042 = G__50043;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.api.search_details.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.api.search_details.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__50036){
var vec__50037 = p__50036;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50037,(0),null);
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50037,(1),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$search_DASH_details,cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([opts,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0))], 0));
});

burningswell.web.api.search_details.cljs$lang$maxFixedArity = (1);

burningswell.web.api.search_details.cljs$lang$applyTo = (function (seq50032){
var G__50033 = cljs.core.first(seq50032);
var seq50032__$1 = cljs.core.next(seq50032);
return burningswell.web.api.search_details.cljs$core$IFn$_invoke$arity$variadic(G__50033,seq50032__$1);
});

/**
 * Fetch the `spot`.
 */
burningswell.web.api.spot = (function burningswell$web$api$spot(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50062 = arguments.length;
var i__7978__auto___50063 = (0);
while(true){
if((i__7978__auto___50063 < len__7977__auto___50062)){
args__7984__auto__.push((arguments[i__7978__auto___50063]));

var G__50064 = (i__7978__auto___50063 + (1));
i__7978__auto___50063 = G__50064;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.spot.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.spot.cljs$core$IFn$_invoke$arity$variadic = (function (system,spot,p__50058){
var vec__50059 = p__50058;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50059,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spot,spot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.spot.cljs$lang$maxFixedArity = (2);

burningswell.web.api.spot.cljs$lang$applyTo = (function (seq50053){
var G__50054 = cljs.core.first(seq50053);
var seq50053__$1 = cljs.core.next(seq50053);
var G__50055 = cljs.core.first(seq50053__$1);
var seq50053__$2 = cljs.core.next(seq50053__$1);
return burningswell.web.api.spot.cljs$core$IFn$_invoke$arity$variadic(G__50054,G__50055,seq50053__$2);
});

/**
 * Fetch spots.
 */
burningswell.web.api.spots = (function burningswell$web$api$spots(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50072 = arguments.length;
var i__7978__auto___50073 = (0);
while(true){
if((i__7978__auto___50073 < len__7977__auto___50072)){
args__7984__auto__.push((arguments[i__7978__auto___50073]));

var G__50074 = (i__7978__auto___50073 + (1));
i__7978__auto___50073 = G__50074;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.api.spots.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.api.spots.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__50068){
var vec__50069 = p__50068;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50069,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spots,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.spots.cljs$lang$maxFixedArity = (1);

burningswell.web.api.spots.cljs$lang$applyTo = (function (seq50066){
var G__50067 = cljs.core.first(seq50066);
var seq50066__$1 = cljs.core.next(seq50066);
return burningswell.web.api.spots.cljs$core$IFn$_invoke$arity$variadic(G__50067,seq50066__$1);
});

/**
 * Fetch the spots around `spot`.
 */
burningswell.web.api.spots_around = (function burningswell$web$api$spots_around(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50084 = arguments.length;
var i__7978__auto___50085 = (0);
while(true){
if((i__7978__auto___50085 < len__7977__auto___50084)){
args__7984__auto__.push((arguments[i__7978__auto___50085]));

var G__50086 = (i__7978__auto___50085 + (1));
i__7978__auto___50085 = G__50086;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.spots_around.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.spots_around.cljs$core$IFn$_invoke$arity$variadic = (function (system,spot,p__50080){
var vec__50081 = p__50080;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50081,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spots_DASH_around_DASH_spot,spot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.spots_around.cljs$lang$maxFixedArity = (2);

burningswell.web.api.spots_around.cljs$lang$applyTo = (function (seq50077){
var G__50078 = cljs.core.first(seq50077);
var seq50077__$1 = cljs.core.next(seq50077);
var G__50079 = cljs.core.first(seq50077__$1);
var seq50077__$2 = cljs.core.next(seq50077__$1);
return burningswell.web.api.spots_around.cljs$core$IFn$_invoke$arity$variadic(G__50078,G__50079,seq50077__$2);
});

/**
 * Fetch spots in `region`.
 */
burningswell.web.api.spots_in_region = (function burningswell$web$api$spots_in_region(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50094 = arguments.length;
var i__7978__auto___50095 = (0);
while(true){
if((i__7978__auto___50095 < len__7977__auto___50094)){
args__7984__auto__.push((arguments[i__7978__auto___50095]));

var G__50096 = (i__7978__auto___50095 + (1));
i__7978__auto___50095 = G__50096;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.spots_in_region.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.spots_in_region.cljs$core$IFn$_invoke$arity$variadic = (function (system,region,p__50090){
var vec__50091 = p__50090;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50091,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spots_DASH_in_DASH_region,region,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.spots_in_region.cljs$lang$maxFixedArity = (2);

burningswell.web.api.spots_in_region.cljs$lang$applyTo = (function (seq50087){
var G__50088 = cljs.core.first(seq50087);
var seq50087__$1 = cljs.core.next(seq50087);
var G__50089 = cljs.core.first(seq50087__$1);
var seq50087__$2 = cljs.core.next(seq50087__$1);
return burningswell.web.api.spots_in_region.cljs$core$IFn$_invoke$arity$variadic(G__50088,G__50089,seq50087__$2);
});

/**
 * Fetch spots in `country`.
 */
burningswell.web.api.spots_in_country = (function burningswell$web$api$spots_in_country(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50119 = arguments.length;
var i__7978__auto___50120 = (0);
while(true){
if((i__7978__auto___50120 < len__7977__auto___50119)){
args__7984__auto__.push((arguments[i__7978__auto___50120]));

var G__50124 = (i__7978__auto___50120 + (1));
i__7978__auto___50120 = G__50124;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.spots_in_country.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.spots_in_country.cljs$core$IFn$_invoke$arity$variadic = (function (system,country,p__50112){
var vec__50113 = p__50112;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50113,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spots_DASH_in_DASH_country,country,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.spots_in_country.cljs$lang$maxFixedArity = (2);

burningswell.web.api.spots_in_country.cljs$lang$applyTo = (function (seq50104){
var G__50105 = cljs.core.first(seq50104);
var seq50104__$1 = cljs.core.next(seq50104);
var G__50106 = cljs.core.first(seq50104__$1);
var seq50104__$2 = cljs.core.next(seq50104__$1);
return burningswell.web.api.spots_in_country.cljs$core$IFn$_invoke$arity$variadic(G__50105,G__50106,seq50104__$2);
});

/**
 * Fetch the photos for `spot`.
 */
burningswell.web.api.spot_photos = (function burningswell$web$api$spot_photos(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50150 = arguments.length;
var i__7978__auto___50151 = (0);
while(true){
if((i__7978__auto___50151 < len__7977__auto___50150)){
args__7984__auto__.push((arguments[i__7978__auto___50151]));

var G__50152 = (i__7978__auto___50151 + (1));
i__7978__auto___50151 = G__50152;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.spot_photos.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.spot_photos.cljs$core$IFn$_invoke$arity$variadic = (function (system,spot,p__50146){
var vec__50147 = p__50146;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50147,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spot_DASH_photos,spot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.spot_photos.cljs$lang$maxFixedArity = (2);

burningswell.web.api.spot_photos.cljs$lang$applyTo = (function (seq50143){
var G__50144 = cljs.core.first(seq50143);
var seq50143__$1 = cljs.core.next(seq50143);
var G__50145 = cljs.core.first(seq50143__$1);
var seq50143__$2 = cljs.core.next(seq50143__$1);
return burningswell.web.api.spot_photos.cljs$core$IFn$_invoke$arity$variadic(G__50144,G__50145,seq50143__$2);
});

/**
 * Fetch the weather for `spot`.
 */
burningswell.web.api.spot_weather = (function burningswell$web$api$spot_weather(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50163 = arguments.length;
var i__7978__auto___50164 = (0);
while(true){
if((i__7978__auto___50164 < len__7977__auto___50163)){
args__7984__auto__.push((arguments[i__7978__auto___50164]));

var G__50166 = (i__7978__auto___50164 + (1));
i__7978__auto___50164 = G__50166;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.spot_weather.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.spot_weather.cljs$core$IFn$_invoke$arity$variadic = (function (system,spot,p__50158){
var vec__50159 = p__50158;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50159,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$spot_DASH_weather,spot,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.spot_weather.cljs$lang$maxFixedArity = (2);

burningswell.web.api.spot_weather.cljs$lang$applyTo = (function (seq50155){
var G__50156 = cljs.core.first(seq50155);
var seq50155__$1 = cljs.core.next(seq50155);
var G__50157 = cljs.core.first(seq50155__$1);
var seq50155__$2 = cljs.core.next(seq50155__$1);
return burningswell.web.api.spot_weather.cljs$core$IFn$_invoke$arity$variadic(G__50156,G__50157,seq50155__$2);
});

/**
 * Fetch the `user`.
 */
burningswell.web.api.user = (function burningswell$web$api$user(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50201 = arguments.length;
var i__7978__auto___50202 = (0);
while(true){
if((i__7978__auto___50202 < len__7977__auto___50201)){
args__7984__auto__.push((arguments[i__7978__auto___50202]));

var G__50203 = (i__7978__auto___50202 + (1));
i__7978__auto___50202 = G__50203;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.user.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.user.cljs$core$IFn$_invoke$arity$variadic = (function (system,user,p__50197){
var vec__50198 = p__50197;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50198,(0),null);
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$user,user,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.user.cljs$lang$maxFixedArity = (2);

burningswell.web.api.user.cljs$lang$applyTo = (function (seq50194){
var G__50195 = cljs.core.first(seq50194);
var seq50194__$1 = cljs.core.next(seq50194);
var G__50196 = cljs.core.first(seq50194__$1);
var seq50194__$2 = cljs.core.next(seq50194__$1);
return burningswell.web.api.user.cljs$core$IFn$_invoke$arity$variadic(G__50195,G__50196,seq50194__$2);
});

/**
 * Like a photo.
 */
burningswell.web.api.like_photo = (function burningswell$web$api$like_photo(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50229 = arguments.length;
var i__7978__auto___50230 = (0);
while(true){
if((i__7978__auto___50230 < len__7977__auto___50229)){
args__7984__auto__.push((arguments[i__7978__auto___50230]));

var G__50231 = (i__7978__auto___50230 + (1));
i__7978__auto___50230 = G__50231;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.like_photo.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.like_photo.cljs$core$IFn$_invoke$arity$variadic = (function (system,photo,p__50225){
var vec__50226 = p__50225;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50226,(0),null);
return request.core.post.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$photo_DASH_likes,photo,opts], 0));
});

burningswell.web.api.like_photo.cljs$lang$maxFixedArity = (2);

burningswell.web.api.like_photo.cljs$lang$applyTo = (function (seq50218){
var G__50219 = cljs.core.first(seq50218);
var seq50218__$1 = cljs.core.next(seq50218);
var G__50220 = cljs.core.first(seq50218__$1);
var seq50218__$2 = cljs.core.next(seq50218__$1);
return burningswell.web.api.like_photo.cljs$core$IFn$_invoke$arity$variadic(G__50219,G__50220,seq50218__$2);
});

/**
 * Like a photo.
 */
burningswell.web.api.dislike_photo = (function burningswell$web$api$dislike_photo(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50244 = arguments.length;
var i__7978__auto___50245 = (0);
while(true){
if((i__7978__auto___50245 < len__7977__auto___50244)){
args__7984__auto__.push((arguments[i__7978__auto___50245]));

var G__50250 = (i__7978__auto___50245 + (1));
i__7978__auto___50245 = G__50250;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.dislike_photo.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.dislike_photo.cljs$core$IFn$_invoke$arity$variadic = (function (system,photo,p__50240){
var vec__50241 = p__50240;
var opts = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50241,(0),null);
return request.core.delete$.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([cljs.core.cst$kw$photo_DASH_likes,photo,opts], 0));
});

burningswell.web.api.dislike_photo.cljs$lang$maxFixedArity = (2);

burningswell.web.api.dislike_photo.cljs$lang$applyTo = (function (seq50234){
var G__50235 = cljs.core.first(seq50234);
var seq50234__$1 = cljs.core.next(seq50234);
var G__50236 = cljs.core.first(seq50234__$1);
var seq50234__$2 = cljs.core.next(seq50234__$1);
return burningswell.web.api.dislike_photo.cljs$core$IFn$_invoke$arity$variadic(G__50235,G__50236,seq50234__$2);
});

/**
 * Return the wave heights chart for `spot`.
 */
burningswell.web.api.wave_heights_chart = (function burningswell$web$api$wave_heights_chart(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50269 = arguments.length;
var i__7978__auto___50270 = (0);
while(true){
if((i__7978__auto___50270 < len__7977__auto___50269)){
args__7984__auto__.push((arguments[i__7978__auto___50270]));

var G__50272 = (i__7978__auto___50270 + (1));
i__7978__auto___50270 = G__50272;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.api.wave_heights_chart.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.api.wave_heights_chart.cljs$core$IFn$_invoke$arity$variadic = (function (system,spot,p__50262){
var vec__50263 = p__50262;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50263,(0),null);
var url = [cljs.core.str((function (){var G__50266 = burningswell.web.api.api(system);
var G__50267 = cljs.core.cst$kw$spot;
var G__50268 = spot;
return (burningswell.api.client.url_for.cljs$core$IFn$_invoke$arity$3 ? burningswell.api.client.url_for.cljs$core$IFn$_invoke$arity$3(G__50266,G__50267,G__50268) : burningswell.api.client.url_for.call(null,G__50266,G__50267,G__50268));
})()),cljs.core.str("/wave-heights.svg")].join('');
return request.core.get.cljs$core$IFn$_invoke$arity$variadic(burningswell.web.api.api(system),cljs.core.array_seq([url,new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$query_DASH_params,params], null)], 0));
});

burningswell.web.api.wave_heights_chart.cljs$lang$maxFixedArity = (2);

burningswell.web.api.wave_heights_chart.cljs$lang$applyTo = (function (seq50259){
var G__50260 = cljs.core.first(seq50259);
var seq50259__$1 = cljs.core.next(seq50259);
var G__50261 = cljs.core.first(seq50259__$1);
var seq50259__$2 = cljs.core.next(seq50259__$1);
return burningswell.web.api.wave_heights_chart.cljs$core$IFn$_invoke$arity$variadic(G__50260,G__50261,seq50259__$2);
});

