// Compiled by ClojureScript 1.9.183 {:static-fns true, :optimize-constants true}
goog.provide('burningswell.web.actions');
goog.require('cljs.core');
goog.require('geo.core');
goog.require('burningswell.web.logging');
goog.require('goog.date.DateTime');
goog.require('burningswell.web.cookies');
goog.require('hal.core');
goog.require('coolant.core');
goog.require('no.en.core');
goog.require('burningswell.web.api');
goog.require('burningswell.web.router');
goog.require('cljs.core.async');
goog.require('burningswell.web.util');
goog.require('burningswell.web.history');
goog.require('goog.date.Interval');
goog.require('clojure.string');
goog.require('burningswell.web.getter.core');
/**
 * The logger of the current namespace.
 */
burningswell.web.actions.logger = burningswell.web.logging.logger("burningswell.web.actions");
/**
 * Dispatch a message to the registered stores to update
 *   state. Notifies observers if their watched value has
 *   changed. Returns updated system.
 */
burningswell.web.actions.dispatch_BANG_ = (function burningswell$web$actions$dispatch_BANG_(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50294 = arguments.length;
var i__7978__auto___50295 = (0);
while(true){
if((i__7978__auto___50295 < len__7977__auto___50294)){
args__7984__auto__.push((arguments[i__7978__auto___50295]));

var G__50296 = (i__7978__auto___50295 + (1));
i__7978__auto___50295 = G__50296;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (system,message_type,p__50290){
var vec__50291 = p__50290;
var message_value = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50291,(0),null);
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(system,cljs.core.cst$kw$coolant,coolant.core.dispatch_BANG_(cljs.core.cst$kw$coolant.cljs$core$IFn$_invoke$arity$1(system),coolant.core.message.cljs$core$IFn$_invoke$arity$2(message_type,message_value)));
});

burningswell.web.actions.dispatch_BANG_.cljs$lang$maxFixedArity = (2);

burningswell.web.actions.dispatch_BANG_.cljs$lang$applyTo = (function (seq50287){
var G__50288 = cljs.core.first(seq50287);
var seq50287__$1 = cljs.core.next(seq50287);
var G__50289 = cljs.core.first(seq50287__$1);
var seq50287__$2 = cljs.core.next(seq50287__$1);
return burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__50288,G__50289,seq50287__$2);
});

/**
 * Return the value of the input `element`.
 */
burningswell.web.actions.input_value = (function burningswell$web$actions$input_value(element){
var G__50300 = (((cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(element.type) instanceof cljs.core.Keyword))?cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(element.type).fqn:null);
switch (G__50300) {
case "checkbox":
return element.checked;

break;
default:
return element.value;

}
});
/**
 * Dispatch an input changed event.
 */
burningswell.web.actions.on_input_changed = (function burningswell$web$actions$on_input_changed(system,msg_type){
return (function (event){
return burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,msg_type,cljs.core.array_seq([burningswell.web.actions.input_value(event.target)], 0));
});
});
/**
 * Handle email changes in the signup form.
 */
burningswell.web.actions.on_signup_email_changed = (function burningswell$web$actions$on_signup_email_changed(system){
return (function (event){
var value = burningswell.web.actions.input_value(event.target);
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signup_SLASH_email,cljs.core.array_seq([value], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,value){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,value){
return (function (state_50397){
var state_val_50398 = (state_50397[(1)]);
if((state_val_50398 === (7))){
var state_50397__$1 = state_50397;
var statearr_50400_50422 = state_50397__$1;
(statearr_50400_50422[(2)] = false);

(statearr_50400_50422[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (1))){
var inst_50367 = [cljs.core.cst$kw$id];
var inst_50368 = [value];
var inst_50369 = cljs.core.PersistentHashMap.fromArrays(inst_50367,inst_50368);
var inst_50370 = burningswell.web.api.user(system,inst_50369);
var state_50397__$1 = state_50397;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50397__$1,(2),inst_50370);
} else {
if((state_val_50398 === (4))){
var state_50397__$1 = state_50397;
var statearr_50401_50424 = state_50397__$1;
(statearr_50401_50424[(2)] = false);

(statearr_50401_50424[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (6))){
var state_50397__$1 = state_50397;
var statearr_50402_50425 = state_50397__$1;
(statearr_50402_50425[(2)] = true);

(statearr_50402_50425[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (3))){
var inst_50372 = (state_50397[(7)]);
var inst_50377 = inst_50372.cljs$lang$protocol_mask$partition0$;
var inst_50378 = (inst_50377 & (64));
var inst_50379 = inst_50372.cljs$core$ISeq$;
var inst_50380 = (inst_50378) || (inst_50379);
var state_50397__$1 = state_50397;
if(cljs.core.truth_(inst_50380)){
var statearr_50403_50426 = state_50397__$1;
(statearr_50403_50426[(1)] = (6));

} else {
var statearr_50404_50427 = state_50397__$1;
(statearr_50404_50427[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (2))){
var inst_50372 = (state_50397[(7)]);
var inst_50372__$1 = (state_50397[(2)]);
var inst_50374 = (inst_50372__$1 == null);
var inst_50375 = cljs.core.not(inst_50374);
var state_50397__$1 = (function (){var statearr_50405 = state_50397;
(statearr_50405[(7)] = inst_50372__$1);

return statearr_50405;
})();
if(inst_50375){
var statearr_50406_50435 = state_50397__$1;
(statearr_50406_50435[(1)] = (3));

} else {
var statearr_50407_50437 = state_50397__$1;
(statearr_50407_50437[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (11))){
var inst_50392 = (state_50397[(2)]);
var inst_50393 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50392,cljs.core.cst$kw$status);
var inst_50394 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_50393,(404));
var inst_50395 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signup_SLASH_email_DASH_available,cljs.core.array_seq([inst_50394], 0));
var state_50397__$1 = state_50397;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50397__$1,inst_50395);
} else {
if((state_val_50398 === (9))){
var inst_50372 = (state_50397[(7)]);
var inst_50389 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_50372);
var state_50397__$1 = state_50397;
var statearr_50408_50439 = state_50397__$1;
(statearr_50408_50439[(2)] = inst_50389);

(statearr_50408_50439[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (5))){
var inst_50387 = (state_50397[(2)]);
var state_50397__$1 = state_50397;
if(cljs.core.truth_(inst_50387)){
var statearr_50409_50440 = state_50397__$1;
(statearr_50409_50440[(1)] = (9));

} else {
var statearr_50410_50441 = state_50397__$1;
(statearr_50410_50441[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (10))){
var inst_50372 = (state_50397[(7)]);
var state_50397__$1 = state_50397;
var statearr_50411_50442 = state_50397__$1;
(statearr_50411_50442[(2)] = inst_50372);

(statearr_50411_50442[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50398 === (8))){
var inst_50384 = (state_50397[(2)]);
var state_50397__$1 = state_50397;
var statearr_50412_50443 = state_50397__$1;
(statearr_50412_50443[(2)] = inst_50384);

(statearr_50412_50443[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,value))
;
return ((function (switch__43982__auto__,c__44280__auto__,value){
return (function() {
var burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto____0 = (function (){
var statearr_50416 = [null,null,null,null,null,null,null,null];
(statearr_50416[(0)] = burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto__);

(statearr_50416[(1)] = (1));

return statearr_50416;
});
var burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto____1 = (function (state_50397){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_50397);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e50417){if((e50417 instanceof Object)){
var ex__43986__auto__ = e50417;
var statearr_50418_50444 = state_50397;
(statearr_50418_50444[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50397);

return cljs.core.cst$kw$recur;
} else {
throw e50417;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__50446 = state_50397;
state_50397 = G__50446;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto__ = function(state_50397){
switch(arguments.length){
case 0:
return burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto____1.call(this,state_50397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto____0;
burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto____1;
return burningswell$web$actions$on_signup_email_changed_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,value))
})();
var state__44282__auto__ = (function (){var statearr_50419 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_50419[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_50419;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,value))
);

return c__44280__auto__;
});
});
/**
 * Handle username changes in the signup form.
 */
burningswell.web.actions.on_signup_username_changed = (function burningswell$web$actions$on_signup_username_changed(system){
return (function (event){
var value = burningswell.web.actions.input_value(event.target);
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signup_SLASH_username,cljs.core.array_seq([value], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,value){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,value){
return (function (state_50533){
var state_val_50534 = (state_50533[(1)]);
if((state_val_50534 === (7))){
var state_50533__$1 = state_50533;
var statearr_50535_50557 = state_50533__$1;
(statearr_50535_50557[(2)] = false);

(statearr_50535_50557[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (1))){
var inst_50503 = [cljs.core.cst$kw$id];
var inst_50504 = [value];
var inst_50505 = cljs.core.PersistentHashMap.fromArrays(inst_50503,inst_50504);
var inst_50506 = burningswell.web.api.user(system,inst_50505);
var state_50533__$1 = state_50533;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50533__$1,(2),inst_50506);
} else {
if((state_val_50534 === (4))){
var state_50533__$1 = state_50533;
var statearr_50536_50560 = state_50533__$1;
(statearr_50536_50560[(2)] = false);

(statearr_50536_50560[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (6))){
var state_50533__$1 = state_50533;
var statearr_50537_50561 = state_50533__$1;
(statearr_50537_50561[(2)] = true);

(statearr_50537_50561[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (3))){
var inst_50508 = (state_50533[(7)]);
var inst_50513 = inst_50508.cljs$lang$protocol_mask$partition0$;
var inst_50514 = (inst_50513 & (64));
var inst_50515 = inst_50508.cljs$core$ISeq$;
var inst_50516 = (inst_50514) || (inst_50515);
var state_50533__$1 = state_50533;
if(cljs.core.truth_(inst_50516)){
var statearr_50538_50562 = state_50533__$1;
(statearr_50538_50562[(1)] = (6));

} else {
var statearr_50539_50563 = state_50533__$1;
(statearr_50539_50563[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (2))){
var inst_50508 = (state_50533[(7)]);
var inst_50508__$1 = (state_50533[(2)]);
var inst_50510 = (inst_50508__$1 == null);
var inst_50511 = cljs.core.not(inst_50510);
var state_50533__$1 = (function (){var statearr_50540 = state_50533;
(statearr_50540[(7)] = inst_50508__$1);

return statearr_50540;
})();
if(inst_50511){
var statearr_50541_50565 = state_50533__$1;
(statearr_50541_50565[(1)] = (3));

} else {
var statearr_50542_50567 = state_50533__$1;
(statearr_50542_50567[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (11))){
var inst_50528 = (state_50533[(2)]);
var inst_50529 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50528,cljs.core.cst$kw$status);
var inst_50530 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_50529,(404));
var inst_50531 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signup_SLASH_username_DASH_available,cljs.core.array_seq([inst_50530], 0));
var state_50533__$1 = state_50533;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50533__$1,inst_50531);
} else {
if((state_val_50534 === (9))){
var inst_50508 = (state_50533[(7)]);
var inst_50525 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_50508);
var state_50533__$1 = state_50533;
var statearr_50543_50568 = state_50533__$1;
(statearr_50543_50568[(2)] = inst_50525);

(statearr_50543_50568[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (5))){
var inst_50523 = (state_50533[(2)]);
var state_50533__$1 = state_50533;
if(cljs.core.truth_(inst_50523)){
var statearr_50544_50569 = state_50533__$1;
(statearr_50544_50569[(1)] = (9));

} else {
var statearr_50545_50570 = state_50533__$1;
(statearr_50545_50570[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (10))){
var inst_50508 = (state_50533[(7)]);
var state_50533__$1 = state_50533;
var statearr_50546_50571 = state_50533__$1;
(statearr_50546_50571[(2)] = inst_50508);

(statearr_50546_50571[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50534 === (8))){
var inst_50520 = (state_50533[(2)]);
var state_50533__$1 = state_50533;
var statearr_50547_50572 = state_50533__$1;
(statearr_50547_50572[(2)] = inst_50520);

(statearr_50547_50572[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,value))
;
return ((function (switch__43982__auto__,c__44280__auto__,value){
return (function() {
var burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto____0 = (function (){
var statearr_50551 = [null,null,null,null,null,null,null,null];
(statearr_50551[(0)] = burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto__);

(statearr_50551[(1)] = (1));

return statearr_50551;
});
var burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto____1 = (function (state_50533){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_50533);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e50552){if((e50552 instanceof Object)){
var ex__43986__auto__ = e50552;
var statearr_50554_50573 = state_50533;
(statearr_50554_50573[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50533);

return cljs.core.cst$kw$recur;
} else {
throw e50552;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__50574 = state_50533;
state_50533 = G__50574;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto__ = function(state_50533){
switch(arguments.length){
case 0:
return burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto____1.call(this,state_50533);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto____0;
burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto____1;
return burningswell$web$actions$on_signup_username_changed_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,value))
})();
var state__44282__auto__ = (function (){var statearr_50556 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_50556[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_50556;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,value))
);

return c__44280__auto__;
});
});
/**
 * Dispatch an action to update an input value.
 */
burningswell.web.actions.update_value = (function burningswell$web$actions$update_value(system,p__50575){
var map__50578 = p__50575;
var map__50578__$1 = ((((!((map__50578 == null)))?((((map__50578.cljs$lang$protocol_mask$partition0$ & (64))) || (map__50578.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__50578):map__50578);
var event = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50578__$1,cljs.core.cst$kw$event);
var topic = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__50578__$1,cljs.core.cst$kw$topic);
var value = burningswell.web.actions.input_value(event.target);
return burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,topic,cljs.core.array_seq([value], 0));
});
/**
 * Return an on change handler for an input value.
 */
burningswell.web.actions.on_value_change = (function burningswell$web$actions$on_value_change(system,topic){
return (function (p1__50580_SHARP_){
return burningswell.web.actions.update_value(system,new cljs.core.PersistentArrayMap(null, 2, [cljs.core.cst$kw$event,p1__50580_SHARP_,cljs.core.cst$kw$topic,topic], null));
});
});
/**
 * Return the current location.
 */
burningswell.web.actions.current_location = (function burningswell$web$actions$current_location(system){
return coolant.core.evaluate(cljs.core.cst$kw$coolant.cljs$core$IFn$_invoke$arity$1(system),burningswell.web.getter.core.current_location);
});
/**
 * Return the current location as query params.
 */
burningswell.web.actions.current_location_params = (function burningswell$web$actions$current_location_params(system){
return burningswell.web.util.location_query_params(burningswell.web.actions.current_location(system));
});
/**
 * Change the current geo location.
 */
burningswell.web.actions.change_current_location = (function burningswell$web$actions$change_current_location(system,location){
burningswell.web.cookies.save_location(location);

if(cljs.core.truth_(burningswell.web.actions.current_location(system))){
return null;
} else {
return burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$current_SLASH_location,cljs.core.array_seq([location], 0));
}
});
/**
 * Fetch the wave heights chart for `spot`.
 */
burningswell.web.actions.wave_heights_chart = (function burningswell$web$actions$wave_heights_chart(system,spot){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_50679){
var state_val_50680 = (state_50679[(1)]);
if((state_val_50680 === (7))){
var state_50679__$1 = state_50679;
var statearr_50681_50707 = state_50679__$1;
(statearr_50681_50707[(2)] = false);

(statearr_50681_50707[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (1))){
var inst_50645 = burningswell.web.api.wave_heights_chart(system,spot);
var state_50679__$1 = state_50679;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50679__$1,(2),inst_50645);
} else {
if((state_val_50680 === (4))){
var state_50679__$1 = state_50679;
var statearr_50682_50708 = state_50679__$1;
(statearr_50682_50708[(2)] = false);

(statearr_50682_50708[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (13))){
var inst_50669 = (state_50679[(7)]);
var inst_50670 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$chart];
var inst_50671 = [spot,inst_50669];
var inst_50672 = cljs.core.PersistentHashMap.fromArrays(inst_50670,inst_50671);
var inst_50673 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_wave_DASH_heights_DASH_chart,cljs.core.array_seq([inst_50672], 0));
var state_50679__$1 = state_50679;
var statearr_50683_50709 = state_50679__$1;
(statearr_50683_50709[(2)] = inst_50673);

(statearr_50683_50709[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (6))){
var state_50679__$1 = state_50679;
var statearr_50684_50710 = state_50679__$1;
(statearr_50684_50710[(2)] = true);

(statearr_50684_50710[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (3))){
var inst_50647 = (state_50679[(8)]);
var inst_50652 = inst_50647.cljs$lang$protocol_mask$partition0$;
var inst_50653 = (inst_50652 & (64));
var inst_50654 = inst_50647.cljs$core$ISeq$;
var inst_50655 = (inst_50653) || (inst_50654);
var state_50679__$1 = state_50679;
if(cljs.core.truth_(inst_50655)){
var statearr_50685_50711 = state_50679__$1;
(statearr_50685_50711[(1)] = (6));

} else {
var statearr_50686_50712 = state_50679__$1;
(statearr_50686_50712[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (12))){
var inst_50677 = (state_50679[(2)]);
var state_50679__$1 = state_50679;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50679__$1,inst_50677);
} else {
if((state_val_50680 === (2))){
var inst_50647 = (state_50679[(8)]);
var inst_50647__$1 = (state_50679[(2)]);
var inst_50649 = (inst_50647__$1 == null);
var inst_50650 = cljs.core.not(inst_50649);
var state_50679__$1 = (function (){var statearr_50687 = state_50679;
(statearr_50687[(8)] = inst_50647__$1);

return statearr_50687;
})();
if(inst_50650){
var statearr_50688_50713 = state_50679__$1;
(statearr_50688_50713[(1)] = (3));

} else {
var statearr_50689_50714 = state_50679__$1;
(statearr_50689_50714[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (11))){
var inst_50667 = (state_50679[(2)]);
var inst_50668 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50667,cljs.core.cst$kw$status);
var inst_50669 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50667,cljs.core.cst$kw$body);
var state_50679__$1 = (function (){var statearr_50690 = state_50679;
(statearr_50690[(7)] = inst_50669);

return statearr_50690;
})();
var G__50691_50715 = inst_50668;
switch (G__50691_50715) {
case (200):
var statearr_50692_50717 = state_50679__$1;
(statearr_50692_50717[(1)] = (13));


break;
case (404):
var statearr_50693_50718 = state_50679__$1;
(statearr_50693_50718[(1)] = (14));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_50668)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (9))){
var inst_50647 = (state_50679[(8)]);
var inst_50664 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_50647);
var state_50679__$1 = state_50679;
var statearr_50694_50719 = state_50679__$1;
(statearr_50694_50719[(2)] = inst_50664);

(statearr_50694_50719[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (5))){
var inst_50662 = (state_50679[(2)]);
var state_50679__$1 = state_50679;
if(cljs.core.truth_(inst_50662)){
var statearr_50695_50720 = state_50679__$1;
(statearr_50695_50720[(1)] = (9));

} else {
var statearr_50696_50721 = state_50679__$1;
(statearr_50696_50721[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (14))){
var state_50679__$1 = state_50679;
var statearr_50697_50722 = state_50679__$1;
(statearr_50697_50722[(2)] = null);

(statearr_50697_50722[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (10))){
var inst_50647 = (state_50679[(8)]);
var state_50679__$1 = state_50679;
var statearr_50698_50723 = state_50679__$1;
(statearr_50698_50723[(2)] = inst_50647);

(statearr_50698_50723[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50680 === (8))){
var inst_50659 = (state_50679[(2)]);
var state_50679__$1 = state_50679;
var statearr_50699_50724 = state_50679__$1;
(statearr_50699_50724[(2)] = inst_50659);

(statearr_50699_50724[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto____0 = (function (){
var statearr_50703 = [null,null,null,null,null,null,null,null,null];
(statearr_50703[(0)] = burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto__);

(statearr_50703[(1)] = (1));

return statearr_50703;
});
var burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto____1 = (function (state_50679){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_50679);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e50704){if((e50704 instanceof Object)){
var ex__43986__auto__ = e50704;
var statearr_50705_50725 = state_50679;
(statearr_50705_50725[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50679);

return cljs.core.cst$kw$recur;
} else {
throw e50704;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__50726 = state_50679;
state_50679 = G__50726;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto__ = function(state_50679){
switch(arguments.length){
case 0:
return burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto____1.call(this,state_50679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto____0;
burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto____1;
return burningswell$web$actions$wave_heights_chart_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_50706 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_50706[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_50706;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Fetch the wave heights charts for all `spots`.
 */
burningswell.web.actions.wave_heights_charts = (function burningswell$web$actions$wave_heights_charts(system,spots){
var seq__50731 = cljs.core.seq(spots);
var chunk__50732 = null;
var count__50733 = (0);
var i__50734 = (0);
while(true){
if((i__50734 < count__50733)){
var spot = chunk__50732.cljs$core$IIndexed$_nth$arity$2(null,i__50734);
burningswell.web.actions.wave_heights_chart(system,spot);

var G__50735 = seq__50731;
var G__50736 = chunk__50732;
var G__50737 = count__50733;
var G__50738 = (i__50734 + (1));
seq__50731 = G__50735;
chunk__50732 = G__50736;
count__50733 = G__50737;
i__50734 = G__50738;
continue;
} else {
var temp__6369__auto__ = cljs.core.seq(seq__50731);
if(temp__6369__auto__){
var seq__50731__$1 = temp__6369__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__50731__$1)){
var c__7697__auto__ = cljs.core.chunk_first(seq__50731__$1);
var G__50739 = cljs.core.chunk_rest(seq__50731__$1);
var G__50740 = c__7697__auto__;
var G__50741 = cljs.core.count(c__7697__auto__);
var G__50742 = (0);
seq__50731 = G__50739;
chunk__50732 = G__50740;
count__50733 = G__50741;
i__50734 = G__50742;
continue;
} else {
var spot = cljs.core.first(seq__50731__$1);
burningswell.web.actions.wave_heights_chart(system,spot);

var G__50743 = cljs.core.next(seq__50731__$1);
var G__50744 = null;
var G__50745 = (0);
var G__50746 = (0);
seq__50731 = G__50743;
chunk__50732 = G__50744;
count__50733 = G__50745;
i__50734 = G__50746;
continue;
}
} else {
return null;
}
}
break;
}
});
/**
 * Return the query params for the countries page.
 */
burningswell.web.actions.countries_params = (function burningswell$web$actions$countries_params(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50753 = arguments.length;
var i__7978__auto___50754 = (0);
while(true){
if((i__7978__auto___50754 < len__7977__auto___50753)){
args__7984__auto__.push((arguments[i__7978__auto___50754]));

var G__50755 = (i__7978__auto___50754 + (1));
i__7978__auto___50754 = G__50755;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.actions.countries_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.actions.countries_params.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__50749){
var vec__50750 = p__50749;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50750,(0),null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$min_DASH_spots,(1)], null),burningswell.web.actions.current_location_params(system),burningswell.web.api.pagination.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$collection,cljs.core.array_seq([params], 0)),params], 0));
});

burningswell.web.actions.countries_params.cljs$lang$maxFixedArity = (1);

burningswell.web.actions.countries_params.cljs$lang$applyTo = (function (seq50747){
var G__50748 = cljs.core.first(seq50747);
var seq50747__$1 = cljs.core.next(seq50747);
return burningswell.web.actions.countries_params.cljs$core$IFn$_invoke$arity$variadic(G__50748,seq50747__$1);
});

/**
 * Fetch the countries.
 */
burningswell.web.actions.countries = (function burningswell$web$actions$countries(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50822 = arguments.length;
var i__7978__auto___50823 = (0);
while(true){
if((i__7978__auto___50823 < len__7977__auto___50822)){
args__7984__auto__.push((arguments[i__7978__auto___50823]));

var G__50824 = (i__7978__auto___50823 + (1));
i__7978__auto___50823 = G__50824;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.actions.countries.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.actions.countries.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__50758){
var vec__50759 = p__50758;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50759,(0),null);
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([true], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__50759,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__50759,params){
return (function (state_50795){
var state_val_50796 = (state_50795[(1)]);
if((state_val_50796 === (7))){
var state_50795__$1 = state_50795;
var statearr_50797_50825 = state_50795__$1;
(statearr_50797_50825[(2)] = false);

(statearr_50797_50825[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (1))){
var inst_50763 = burningswell.web.actions.countries_params.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([params], 0));
var inst_50764 = burningswell.web.api.countries.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([inst_50763], 0));
var state_50795__$1 = state_50795;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50795__$1,(2),inst_50764);
} else {
if((state_val_50796 === (4))){
var state_50795__$1 = state_50795;
var statearr_50798_50826 = state_50795__$1;
(statearr_50798_50826[(2)] = false);

(statearr_50798_50826[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (13))){
var inst_50788 = (state_50795[(7)]);
var inst_50789 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$countries_SLASH_list,cljs.core.array_seq([inst_50788], 0));
var state_50795__$1 = state_50795;
var statearr_50799_50827 = state_50795__$1;
(statearr_50799_50827[(2)] = inst_50789);

(statearr_50799_50827[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (6))){
var state_50795__$1 = state_50795;
var statearr_50800_50828 = state_50795__$1;
(statearr_50800_50828[(2)] = true);

(statearr_50800_50828[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (3))){
var inst_50766 = (state_50795[(8)]);
var inst_50771 = inst_50766.cljs$lang$protocol_mask$partition0$;
var inst_50772 = (inst_50771 & (64));
var inst_50773 = inst_50766.cljs$core$ISeq$;
var inst_50774 = (inst_50772) || (inst_50773);
var state_50795__$1 = state_50795;
if(cljs.core.truth_(inst_50774)){
var statearr_50801_50829 = state_50795__$1;
(statearr_50801_50829[(1)] = (6));

} else {
var statearr_50802_50830 = state_50795__$1;
(statearr_50802_50830[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (12))){
var inst_50792 = (state_50795[(2)]);
var inst_50793 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([false], 0));
var state_50795__$1 = (function (){var statearr_50803 = state_50795;
(statearr_50803[(9)] = inst_50792);

return statearr_50803;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50795__$1,inst_50793);
} else {
if((state_val_50796 === (2))){
var inst_50766 = (state_50795[(8)]);
var inst_50766__$1 = (state_50795[(2)]);
var inst_50768 = (inst_50766__$1 == null);
var inst_50769 = cljs.core.not(inst_50768);
var state_50795__$1 = (function (){var statearr_50804 = state_50795;
(statearr_50804[(8)] = inst_50766__$1);

return statearr_50804;
})();
if(inst_50769){
var statearr_50805_50831 = state_50795__$1;
(statearr_50805_50831[(1)] = (3));

} else {
var statearr_50806_50832 = state_50795__$1;
(statearr_50806_50832[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (11))){
var inst_50786 = (state_50795[(2)]);
var inst_50787 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50786,cljs.core.cst$kw$status);
var inst_50788 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_50786,cljs.core.cst$kw$body);
var state_50795__$1 = (function (){var statearr_50807 = state_50795;
(statearr_50807[(7)] = inst_50788);

return statearr_50807;
})();
var G__50808_50833 = inst_50787;
switch (G__50808_50833) {
case (200):
var statearr_50809_50835 = state_50795__$1;
(statearr_50809_50835[(1)] = (13));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_50787)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (9))){
var inst_50766 = (state_50795[(8)]);
var inst_50783 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_50766);
var state_50795__$1 = state_50795;
var statearr_50810_50836 = state_50795__$1;
(statearr_50810_50836[(2)] = inst_50783);

(statearr_50810_50836[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (5))){
var inst_50781 = (state_50795[(2)]);
var state_50795__$1 = state_50795;
if(cljs.core.truth_(inst_50781)){
var statearr_50811_50837 = state_50795__$1;
(statearr_50811_50837[(1)] = (9));

} else {
var statearr_50812_50838 = state_50795__$1;
(statearr_50812_50838[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (10))){
var inst_50766 = (state_50795[(8)]);
var state_50795__$1 = state_50795;
var statearr_50813_50839 = state_50795__$1;
(statearr_50813_50839[(2)] = inst_50766);

(statearr_50813_50839[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_50796 === (8))){
var inst_50778 = (state_50795[(2)]);
var state_50795__$1 = state_50795;
var statearr_50814_50840 = state_50795__$1;
(statearr_50814_50840[(2)] = inst_50778);

(statearr_50814_50840[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__50759,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__50759,params){
return (function() {
var burningswell$web$actions$state_machine__43983__auto__ = null;
var burningswell$web$actions$state_machine__43983__auto____0 = (function (){
var statearr_50818 = [null,null,null,null,null,null,null,null,null,null];
(statearr_50818[(0)] = burningswell$web$actions$state_machine__43983__auto__);

(statearr_50818[(1)] = (1));

return statearr_50818;
});
var burningswell$web$actions$state_machine__43983__auto____1 = (function (state_50795){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_50795);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e50819){if((e50819 instanceof Object)){
var ex__43986__auto__ = e50819;
var statearr_50820_50841 = state_50795;
(statearr_50820_50841[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50795);

return cljs.core.cst$kw$recur;
} else {
throw e50819;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__50842 = state_50795;
state_50795 = G__50842;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$state_machine__43983__auto__ = function(state_50795){
switch(arguments.length){
case 0:
return burningswell$web$actions$state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$state_machine__43983__auto____1.call(this,state_50795);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$state_machine__43983__auto____0;
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$state_machine__43983__auto____1;
return burningswell$web$actions$state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__50759,params))
})();
var state__44282__auto__ = (function (){var statearr_50821 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_50821[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_50821;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__50759,params))
);

return c__44280__auto__;
});

burningswell.web.actions.countries.cljs$lang$maxFixedArity = (1);

burningswell.web.actions.countries.cljs$lang$applyTo = (function (seq50756){
var G__50757 = cljs.core.first(seq50756);
var seq50756__$1 = cljs.core.next(seq50756);
return burningswell.web.actions.countries.cljs$core$IFn$_invoke$arity$variadic(G__50757,seq50756__$1);
});

/**
 * Fetch the spots of `country`.
 */
burningswell.web.actions.country_spots = (function burningswell$web$actions$country_spots(system,p__50843){
var vec__50867 = p__50843;
var country = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50867,(0),null);
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50867,(1),null);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__50867,country,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__50867,country,params){
return (function (state_50880){
var state_val_50881 = (state_50880[(1)]);
if((state_val_50881 === (1))){
var inst_50870 = burningswell.web.api.spots_in_country.cljs$core$IFn$_invoke$arity$variadic(system,country,cljs.core.array_seq([params], 0));
var state_50880__$1 = state_50880;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50880__$1,(2),inst_50870);
} else {
if((state_val_50881 === (2))){
var inst_50872 = (state_50880[(2)]);
var inst_50873 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_50872);
var inst_50874 = [cljs.core.cst$kw$country,cljs.core.cst$kw$spots];
var inst_50875 = [country,inst_50873];
var inst_50876 = cljs.core.PersistentHashMap.fromArrays(inst_50874,inst_50875);
var inst_50877 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$country_SLASH_spots,cljs.core.array_seq([inst_50876], 0));
var inst_50878 = burningswell.web.actions.wave_heights_charts(system,inst_50873);
var state_50880__$1 = (function (){var statearr_50882 = state_50880;
(statearr_50882[(7)] = inst_50877);

return statearr_50882;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50880__$1,inst_50878);
} else {
return null;
}
}
});})(c__44280__auto__,vec__50867,country,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__50867,country,params){
return (function() {
var burningswell$web$actions$country_spots_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$country_spots_$_state_machine__43983__auto____0 = (function (){
var statearr_50886 = [null,null,null,null,null,null,null,null];
(statearr_50886[(0)] = burningswell$web$actions$country_spots_$_state_machine__43983__auto__);

(statearr_50886[(1)] = (1));

return statearr_50886;
});
var burningswell$web$actions$country_spots_$_state_machine__43983__auto____1 = (function (state_50880){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_50880);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e50887){if((e50887 instanceof Object)){
var ex__43986__auto__ = e50887;
var statearr_50888_50890 = state_50880;
(statearr_50888_50890[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50880);

return cljs.core.cst$kw$recur;
} else {
throw e50887;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__50891 = state_50880;
state_50880 = G__50891;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$country_spots_$_state_machine__43983__auto__ = function(state_50880){
switch(arguments.length){
case 0:
return burningswell$web$actions$country_spots_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$country_spots_$_state_machine__43983__auto____1.call(this,state_50880);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$country_spots_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$country_spots_$_state_machine__43983__auto____0;
burningswell$web$actions$country_spots_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$country_spots_$_state_machine__43983__auto____1;
return burningswell$web$actions$country_spots_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__50867,country,params))
})();
var state__44282__auto__ = (function (){var statearr_50889 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_50889[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_50889;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__50867,country,params))
);

return c__44280__auto__;
});
/**
 * Fetch the regions in `country`.
 */
burningswell.web.actions.country_regions = (function burningswell$web$actions$country_regions(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50918 = arguments.length;
var i__7978__auto___50919 = (0);
while(true){
if((i__7978__auto___50919 < len__7977__auto___50918)){
args__7984__auto__.push((arguments[i__7978__auto___50919]));

var G__50920 = (i__7978__auto___50919 + (1));
i__7978__auto___50919 = G__50920;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.actions.country_regions.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.actions.country_regions.cljs$core$IFn$_invoke$arity$variadic = (function (system,country,p__50895){
var vec__50896 = p__50895;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50896,(0),null);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__50896,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__50896,params){
return (function (state_50909){
var state_val_50910 = (state_50909[(1)]);
if((state_val_50910 === (1))){
var inst_50899 = [cljs.core.cst$kw$min_DASH_spots];
var inst_50900 = [(1)];
var inst_50901 = cljs.core.PersistentHashMap.fromArrays(inst_50899,inst_50900);
var inst_50902 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_50901,params], 0));
var inst_50903 = burningswell.web.api.regions_in_country.cljs$core$IFn$_invoke$arity$variadic(system,country,cljs.core.array_seq([inst_50902], 0));
var state_50909__$1 = state_50909;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50909__$1,(2),inst_50903);
} else {
if((state_val_50910 === (2))){
var inst_50905 = (state_50909[(2)]);
var inst_50906 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_50905);
var inst_50907 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$country_SLASH_regions,cljs.core.array_seq([inst_50906], 0));
var state_50909__$1 = state_50909;
return cljs.core.async.impl.ioc_helpers.return_chan(state_50909__$1,inst_50907);
} else {
return null;
}
}
});})(c__44280__auto__,vec__50896,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__50896,params){
return (function() {
var burningswell$web$actions$state_machine__43983__auto__ = null;
var burningswell$web$actions$state_machine__43983__auto____0 = (function (){
var statearr_50914 = [null,null,null,null,null,null,null];
(statearr_50914[(0)] = burningswell$web$actions$state_machine__43983__auto__);

(statearr_50914[(1)] = (1));

return statearr_50914;
});
var burningswell$web$actions$state_machine__43983__auto____1 = (function (state_50909){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_50909);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e50915){if((e50915 instanceof Object)){
var ex__43986__auto__ = e50915;
var statearr_50916_50921 = state_50909;
(statearr_50916_50921[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50909);

return cljs.core.cst$kw$recur;
} else {
throw e50915;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__50922 = state_50909;
state_50909 = G__50922;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$state_machine__43983__auto__ = function(state_50909){
switch(arguments.length){
case 0:
return burningswell$web$actions$state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$state_machine__43983__auto____1.call(this,state_50909);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$state_machine__43983__auto____0;
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$state_machine__43983__auto____1;
return burningswell$web$actions$state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__50896,params))
})();
var state__44282__auto__ = (function (){var statearr_50917 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_50917[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_50917;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__50896,params))
);

return c__44280__auto__;
});

burningswell.web.actions.country_regions.cljs$lang$maxFixedArity = (2);

burningswell.web.actions.country_regions.cljs$lang$applyTo = (function (seq50892){
var G__50893 = cljs.core.first(seq50892);
var seq50892__$1 = cljs.core.next(seq50892);
var G__50894 = cljs.core.first(seq50892__$1);
var seq50892__$2 = cljs.core.next(seq50892__$1);
return burningswell.web.actions.country_regions.cljs$core$IFn$_invoke$arity$variadic(G__50893,G__50894,seq50892__$2);
});

/**
 * Fetch the country.
 */
burningswell.web.actions.country = (function burningswell$web$actions$country(system,country__$1){
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([true], 0));

burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$country_SLASH_country,cljs.core.array_seq([country__$1], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_50949){
var state_val_50950 = (state_50949[(1)]);
if((state_val_50950 === (1))){
var inst_50941 = burningswell.web.api.country(system,country__$1);
var state_50949__$1 = state_50949;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_50949__$1,(2),inst_50941);
} else {
if((state_val_50950 === (2))){
var inst_50943 = (state_50949[(2)]);
var inst_50944 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_50943);
var inst_50945 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$country_SLASH_country,cljs.core.array_seq([inst_50944], 0));
var inst_50946 = burningswell.web.actions.country_regions(system,inst_50944);
var inst_50947 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([false], 0));
var state_50949__$1 = (function (){var statearr_50951 = state_50949;
(statearr_50951[(7)] = inst_50945);

(statearr_50951[(8)] = inst_50946);

return statearr_50951;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_50949__$1,inst_50947);
} else {
return null;
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$country_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$country_$_state_machine__43983__auto____0 = (function (){
var statearr_50955 = [null,null,null,null,null,null,null,null,null];
(statearr_50955[(0)] = burningswell$web$actions$country_$_state_machine__43983__auto__);

(statearr_50955[(1)] = (1));

return statearr_50955;
});
var burningswell$web$actions$country_$_state_machine__43983__auto____1 = (function (state_50949){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_50949);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e50956){if((e50956 instanceof Object)){
var ex__43986__auto__ = e50956;
var statearr_50957_50959 = state_50949;
(statearr_50957_50959[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_50949);

return cljs.core.cst$kw$recur;
} else {
throw e50956;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__50960 = state_50949;
state_50949 = G__50960;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$country_$_state_machine__43983__auto__ = function(state_50949){
switch(arguments.length){
case 0:
return burningswell$web$actions$country_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$country_$_state_machine__43983__auto____1.call(this,state_50949);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$country_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$country_$_state_machine__43983__auto____0;
burningswell$web$actions$country_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$country_$_state_machine__43983__auto____1;
return burningswell$web$actions$country_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_50958 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_50958[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_50958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Navigate to a link in the application.
 */
burningswell.web.actions.history = (function burningswell$web$actions$history(system,p__50961){
var vec__50968 = p__50961;
var seq__50969 = cljs.core.seq(vec__50968);
var first__50970 = cljs.core.first(seq__50969);
var seq__50969__$1 = cljs.core.next(seq__50969);
var path = first__50970;
var vec__50971 = seq__50969__$1;
var query_params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50971,(0),null);
return burningswell.web.router.navigate.cljs$core$IFn$_invoke$arity$variadic(cljs.core.cst$kw$router.cljs$core$IFn$_invoke$arity$1(system),path,cljs.core.array_seq([query_params], 0));
});
/**
 * Navigate to a link in the application.
 */
burningswell.web.actions.navigate = (function burningswell$web$actions$navigate(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50981 = arguments.length;
var i__7978__auto___50982 = (0);
while(true){
if((i__7978__auto___50982 < len__7977__auto___50981)){
args__7984__auto__.push((arguments[i__7978__auto___50982]));

var G__50983 = (i__7978__auto___50982 + (1));
i__7978__auto___50982 = G__50983;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.actions.navigate.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.actions.navigate.cljs$core$IFn$_invoke$arity$variadic = (function (system,url,p__50977){
var vec__50978 = p__50977;
var query_params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50978,(0),null);
var temp__6367__auto__ = burningswell.web.router.match(cljs.core.cst$kw$router.cljs$core$IFn$_invoke$arity$1(system),url);
if(cljs.core.truth_(temp__6367__auto__)){
var route = temp__6367__auto__;
return burningswell.web.actions.history(system,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [url,query_params], null));
} else {
return burningswell.web.logging.error(burningswell.web.actions.logger,[cljs.core.str("Can't match route for url: "),cljs.core.str(url)].join(''));
}
});

burningswell.web.actions.navigate.cljs$lang$maxFixedArity = (2);

burningswell.web.actions.navigate.cljs$lang$applyTo = (function (seq50974){
var G__50975 = cljs.core.first(seq50974);
var seq50974__$1 = cljs.core.next(seq50974);
var G__50976 = cljs.core.first(seq50974__$1);
var seq50974__$2 = cljs.core.next(seq50974__$1);
return burningswell.web.actions.navigate.cljs$core$IFn$_invoke$arity$variadic(G__50975,G__50976,seq50974__$2);
});

/**
 * Navigate to `url` with `query-params`.
 */
burningswell.web.actions.navigate_BANG_ = (function burningswell$web$actions$navigate_BANG_(var_args){
var args__7984__auto__ = [];
var len__7977__auto___50991 = arguments.length;
var i__7978__auto___50992 = (0);
while(true){
if((i__7978__auto___50992 < len__7977__auto___50991)){
args__7984__auto__.push((arguments[i__7978__auto___50992]));

var G__50993 = (i__7978__auto___50992 + (1));
i__7978__auto___50992 = G__50993;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.actions.navigate_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.actions.navigate_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (system,url,p__50987){
var vec__50988 = p__50987;
var query_params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50988,(0),null);
return burningswell.web.actions.navigate.cljs$core$IFn$_invoke$arity$variadic(system,url,cljs.core.array_seq([query_params], 0));
});

burningswell.web.actions.navigate_BANG_.cljs$lang$maxFixedArity = (2);

burningswell.web.actions.navigate_BANG_.cljs$lang$applyTo = (function (seq50984){
var G__50985 = cljs.core.first(seq50984);
var seq50984__$1 = cljs.core.next(seq50984);
var G__50986 = cljs.core.first(seq50984__$1);
var seq50984__$2 = cljs.core.next(seq50984__$1);
return burningswell.web.actions.navigate_BANG_.cljs$core$IFn$_invoke$arity$variadic(G__50985,G__50986,seq50984__$2);
});

/**
 * Fetch the countries.
 */
burningswell.web.actions.region_spots = (function burningswell$web$actions$region_spots(var_args){
var args__7984__auto__ = [];
var len__7977__auto___51021 = arguments.length;
var i__7978__auto___51022 = (0);
while(true){
if((i__7978__auto___51022 < len__7977__auto___51021)){
args__7984__auto__.push((arguments[i__7978__auto___51022]));

var G__51023 = (i__7978__auto___51022 + (1));
i__7978__auto___51022 = G__51023;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((2) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((2)),(0),null)):null);
return burningswell.web.actions.region_spots.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),argseq__7985__auto__);
});

burningswell.web.actions.region_spots.cljs$core$IFn$_invoke$arity$variadic = (function (system,region,p__50997){
var vec__50998 = p__50997;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50998,(0),null);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__50998,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__50998,params){
return (function (state_51011){
var state_val_51012 = (state_51011[(1)]);
if((state_val_51012 === (1))){
var inst_51001 = burningswell.web.api.spots_in_region.cljs$core$IFn$_invoke$arity$variadic(system,region,cljs.core.array_seq([params], 0));
var state_51011__$1 = state_51011;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51011__$1,(2),inst_51001);
} else {
if((state_val_51012 === (2))){
var inst_51003 = (state_51011[(2)]);
var inst_51004 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_51003);
var inst_51005 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_51006 = [region,inst_51004];
var inst_51007 = (new cljs.core.PersistentVector(null,2,(5),inst_51005,inst_51006,null));
var inst_51008 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$region_SLASH_spots,cljs.core.array_seq([inst_51007], 0));
var inst_51009 = burningswell.web.actions.wave_heights_charts(system,inst_51004);
var state_51011__$1 = (function (){var statearr_51013 = state_51011;
(statearr_51013[(7)] = inst_51008);

return statearr_51013;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_51011__$1,inst_51009);
} else {
return null;
}
}
});})(c__44280__auto__,vec__50998,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__50998,params){
return (function() {
var burningswell$web$actions$state_machine__43983__auto__ = null;
var burningswell$web$actions$state_machine__43983__auto____0 = (function (){
var statearr_51017 = [null,null,null,null,null,null,null,null];
(statearr_51017[(0)] = burningswell$web$actions$state_machine__43983__auto__);

(statearr_51017[(1)] = (1));

return statearr_51017;
});
var burningswell$web$actions$state_machine__43983__auto____1 = (function (state_51011){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51011);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51018){if((e51018 instanceof Object)){
var ex__43986__auto__ = e51018;
var statearr_51019_51024 = state_51011;
(statearr_51019_51024[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51011);

return cljs.core.cst$kw$recur;
} else {
throw e51018;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51025 = state_51011;
state_51011 = G__51025;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$state_machine__43983__auto__ = function(state_51011){
switch(arguments.length){
case 0:
return burningswell$web$actions$state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$state_machine__43983__auto____1.call(this,state_51011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$state_machine__43983__auto____0;
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$state_machine__43983__auto____1;
return burningswell$web$actions$state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__50998,params))
})();
var state__44282__auto__ = (function (){var statearr_51020 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51020[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51020;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__50998,params))
);

return c__44280__auto__;
});

burningswell.web.actions.region_spots.cljs$lang$maxFixedArity = (2);

burningswell.web.actions.region_spots.cljs$lang$applyTo = (function (seq50994){
var G__50995 = cljs.core.first(seq50994);
var seq50994__$1 = cljs.core.next(seq50994);
var G__50996 = cljs.core.first(seq50994__$1);
var seq50994__$2 = cljs.core.next(seq50994__$1);
return burningswell.web.actions.region_spots.cljs$core$IFn$_invoke$arity$variadic(G__50995,G__50996,seq50994__$2);
});

/**
 * Fetch the region.
 */
burningswell.web.actions.region = (function burningswell$web$actions$region(system,region__$1){
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([true], 0));

burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$region_SLASH_region,cljs.core.array_seq([region__$1], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_51052){
var state_val_51053 = (state_51052[(1)]);
if((state_val_51053 === (1))){
var inst_51044 = burningswell.web.api.region(system,region__$1);
var state_51052__$1 = state_51052;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51052__$1,(2),inst_51044);
} else {
if((state_val_51053 === (2))){
var inst_51046 = (state_51052[(2)]);
var inst_51047 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_51046);
var inst_51048 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$region_SLASH_region,cljs.core.array_seq([inst_51047], 0));
var inst_51049 = burningswell.web.actions.region_spots(system,inst_51047);
var inst_51050 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([false], 0));
var state_51052__$1 = (function (){var statearr_51054 = state_51052;
(statearr_51054[(7)] = inst_51048);

(statearr_51054[(8)] = inst_51049);

return statearr_51054;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_51052__$1,inst_51050);
} else {
return null;
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$region_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$region_$_state_machine__43983__auto____0 = (function (){
var statearr_51058 = [null,null,null,null,null,null,null,null,null];
(statearr_51058[(0)] = burningswell$web$actions$region_$_state_machine__43983__auto__);

(statearr_51058[(1)] = (1));

return statearr_51058;
});
var burningswell$web$actions$region_$_state_machine__43983__auto____1 = (function (state_51052){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51052);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51059){if((e51059 instanceof Object)){
var ex__43986__auto__ = e51059;
var statearr_51060_51062 = state_51052;
(statearr_51060_51062[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51052);

return cljs.core.cst$kw$recur;
} else {
throw e51059;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51063 = state_51052;
state_51052 = G__51063;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$region_$_state_machine__43983__auto__ = function(state_51052){
switch(arguments.length){
case 0:
return burningswell$web$actions$region_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$region_$_state_machine__43983__auto____1.call(this,state_51052);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$region_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$region_$_state_machine__43983__auto____0;
burningswell$web$actions$region_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$region_$_state_machine__43983__auto____1;
return burningswell$web$actions$region_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_51061 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51061[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51061;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Return the query params for the regions page.
 */
burningswell.web.actions.regions_params = (function burningswell$web$actions$regions_params(var_args){
var args__7984__auto__ = [];
var len__7977__auto___51070 = arguments.length;
var i__7978__auto___51071 = (0);
while(true){
if((i__7978__auto___51071 < len__7977__auto___51070)){
args__7984__auto__.push((arguments[i__7978__auto___51071]));

var G__51072 = (i__7978__auto___51071 + (1));
i__7978__auto___51071 = G__51072;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.actions.regions_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.actions.regions_params.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__51066){
var vec__51067 = p__51066;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51067,(0),null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [cljs.core.cst$kw$min_DASH_spots,(1)], null),burningswell.web.actions.current_location_params(system),burningswell.web.api.pagination(system,cljs.core.cst$kw$collection),params], 0));
});

burningswell.web.actions.regions_params.cljs$lang$maxFixedArity = (1);

burningswell.web.actions.regions_params.cljs$lang$applyTo = (function (seq51064){
var G__51065 = cljs.core.first(seq51064);
var seq51064__$1 = cljs.core.next(seq51064);
return burningswell.web.actions.regions_params.cljs$core$IFn$_invoke$arity$variadic(G__51065,seq51064__$1);
});

/**
 * Fetch the regions.
 */
burningswell.web.actions.regions = (function burningswell$web$actions$regions(var_args){
var args__7984__auto__ = [];
var len__7977__auto___51139 = arguments.length;
var i__7978__auto___51140 = (0);
while(true){
if((i__7978__auto___51140 < len__7977__auto___51139)){
args__7984__auto__.push((arguments[i__7978__auto___51140]));

var G__51141 = (i__7978__auto___51140 + (1));
i__7978__auto___51140 = G__51141;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.actions.regions.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.actions.regions.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__51075){
var vec__51076 = p__51075;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51076,(0),null);
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([true], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__51076,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__51076,params){
return (function (state_51112){
var state_val_51113 = (state_51112[(1)]);
if((state_val_51113 === (7))){
var state_51112__$1 = state_51112;
var statearr_51114_51142 = state_51112__$1;
(statearr_51114_51142[(2)] = false);

(statearr_51114_51142[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (1))){
var inst_51080 = burningswell.web.actions.regions_params.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([params], 0));
var inst_51081 = burningswell.web.api.regions.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([inst_51080], 0));
var state_51112__$1 = state_51112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51112__$1,(2),inst_51081);
} else {
if((state_val_51113 === (4))){
var state_51112__$1 = state_51112;
var statearr_51115_51143 = state_51112__$1;
(statearr_51115_51143[(2)] = false);

(statearr_51115_51143[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (13))){
var inst_51105 = (state_51112[(7)]);
var inst_51106 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$regions_SLASH_list,cljs.core.array_seq([inst_51105], 0));
var state_51112__$1 = state_51112;
var statearr_51116_51144 = state_51112__$1;
(statearr_51116_51144[(2)] = inst_51106);

(statearr_51116_51144[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (6))){
var state_51112__$1 = state_51112;
var statearr_51117_51145 = state_51112__$1;
(statearr_51117_51145[(2)] = true);

(statearr_51117_51145[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (3))){
var inst_51083 = (state_51112[(8)]);
var inst_51088 = inst_51083.cljs$lang$protocol_mask$partition0$;
var inst_51089 = (inst_51088 & (64));
var inst_51090 = inst_51083.cljs$core$ISeq$;
var inst_51091 = (inst_51089) || (inst_51090);
var state_51112__$1 = state_51112;
if(cljs.core.truth_(inst_51091)){
var statearr_51118_51146 = state_51112__$1;
(statearr_51118_51146[(1)] = (6));

} else {
var statearr_51119_51147 = state_51112__$1;
(statearr_51119_51147[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (12))){
var inst_51109 = (state_51112[(2)]);
var inst_51110 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([false], 0));
var state_51112__$1 = (function (){var statearr_51120 = state_51112;
(statearr_51120[(9)] = inst_51109);

return statearr_51120;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_51112__$1,inst_51110);
} else {
if((state_val_51113 === (2))){
var inst_51083 = (state_51112[(8)]);
var inst_51083__$1 = (state_51112[(2)]);
var inst_51085 = (inst_51083__$1 == null);
var inst_51086 = cljs.core.not(inst_51085);
var state_51112__$1 = (function (){var statearr_51121 = state_51112;
(statearr_51121[(8)] = inst_51083__$1);

return statearr_51121;
})();
if(inst_51086){
var statearr_51122_51148 = state_51112__$1;
(statearr_51122_51148[(1)] = (3));

} else {
var statearr_51123_51149 = state_51112__$1;
(statearr_51123_51149[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (11))){
var inst_51103 = (state_51112[(2)]);
var inst_51104 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51103,cljs.core.cst$kw$status);
var inst_51105 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51103,cljs.core.cst$kw$body);
var state_51112__$1 = (function (){var statearr_51124 = state_51112;
(statearr_51124[(7)] = inst_51105);

return statearr_51124;
})();
var G__51125_51150 = inst_51104;
switch (G__51125_51150) {
case (200):
var statearr_51126_51152 = state_51112__$1;
(statearr_51126_51152[(1)] = (13));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_51104)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (9))){
var inst_51083 = (state_51112[(8)]);
var inst_51100 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51083);
var state_51112__$1 = state_51112;
var statearr_51127_51153 = state_51112__$1;
(statearr_51127_51153[(2)] = inst_51100);

(statearr_51127_51153[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (5))){
var inst_51098 = (state_51112[(2)]);
var state_51112__$1 = state_51112;
if(cljs.core.truth_(inst_51098)){
var statearr_51128_51154 = state_51112__$1;
(statearr_51128_51154[(1)] = (9));

} else {
var statearr_51129_51155 = state_51112__$1;
(statearr_51129_51155[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (10))){
var inst_51083 = (state_51112[(8)]);
var state_51112__$1 = state_51112;
var statearr_51130_51156 = state_51112__$1;
(statearr_51130_51156[(2)] = inst_51083);

(statearr_51130_51156[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51113 === (8))){
var inst_51095 = (state_51112[(2)]);
var state_51112__$1 = state_51112;
var statearr_51131_51157 = state_51112__$1;
(statearr_51131_51157[(2)] = inst_51095);

(statearr_51131_51157[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__51076,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__51076,params){
return (function() {
var burningswell$web$actions$state_machine__43983__auto__ = null;
var burningswell$web$actions$state_machine__43983__auto____0 = (function (){
var statearr_51135 = [null,null,null,null,null,null,null,null,null,null];
(statearr_51135[(0)] = burningswell$web$actions$state_machine__43983__auto__);

(statearr_51135[(1)] = (1));

return statearr_51135;
});
var burningswell$web$actions$state_machine__43983__auto____1 = (function (state_51112){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51112);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51136){if((e51136 instanceof Object)){
var ex__43986__auto__ = e51136;
var statearr_51137_51158 = state_51112;
(statearr_51137_51158[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51112);

return cljs.core.cst$kw$recur;
} else {
throw e51136;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51159 = state_51112;
state_51112 = G__51159;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$state_machine__43983__auto__ = function(state_51112){
switch(arguments.length){
case 0:
return burningswell$web$actions$state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$state_machine__43983__auto____1.call(this,state_51112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$state_machine__43983__auto____0;
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$state_machine__43983__auto____1;
return burningswell$web$actions$state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__51076,params))
})();
var state__44282__auto__ = (function (){var statearr_51138 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51138[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51138;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__51076,params))
);

return c__44280__auto__;
});

burningswell.web.actions.regions.cljs$lang$maxFixedArity = (1);

burningswell.web.actions.regions.cljs$lang$applyTo = (function (seq51073){
var G__51074 = cljs.core.first(seq51073);
var seq51073__$1 = cljs.core.next(seq51073);
return burningswell.web.actions.regions.cljs$core$IFn$_invoke$arity$variadic(G__51074,seq51073__$1);
});

/**
 * Search countries, regions and spots.
 */
burningswell.web.actions.auto_complete = (function burningswell$web$actions$auto_complete(var_args){
var args__7984__auto__ = [];
var len__7977__auto___51246 = arguments.length;
var i__7978__auto___51247 = (0);
while(true){
if((i__7978__auto___51247 < len__7977__auto___51246)){
args__7984__auto__.push((arguments[i__7978__auto___51247]));

var G__51248 = (i__7978__auto___51247 + (1));
i__7978__auto___51247 = G__51248;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((3) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((3)),(0),null)):null);
return burningswell.web.actions.auto_complete.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__7985__auto__);
});

burningswell.web.actions.auto_complete.cljs$core$IFn$_invoke$arity$variadic = (function (system,query,cancel,p__51164){
var vec__51165 = p__51164;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51165,(0),null);
var G__51168_51249 = cancel;
if((G__51168_51249 == null)){
} else {
cljs.core.async.close_BANG_(G__51168_51249);
}

if(clojure.string.blank_QMARK_(query)){
burningswell.web.actions.dispatch_BANG_(system,cljs.core.cst$kw$auto_DASH_complete_SLASH_clear);
} else {
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$auto_DASH_complete_SLASH_query,cljs.core.array_seq([query], 0));
}

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__51165,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__51165,params){
return (function (state_51213){
var state_val_51214 = (state_51213[(1)]);
if((state_val_51214 === (7))){
var state_51213__$1 = state_51213;
var statearr_51215_51250 = state_51213__$1;
(statearr_51215_51250[(2)] = false);

(statearr_51215_51250[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (1))){
var inst_51169 = clojure.string.blank_QMARK_(query);
var state_51213__$1 = state_51213;
if(inst_51169){
var statearr_51216_51251 = state_51213__$1;
(statearr_51216_51251[(1)] = (2));

} else {
var statearr_51217_51252 = state_51213__$1;
(statearr_51217_51252[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (4))){
var inst_51211 = (state_51213[(2)]);
var state_51213__$1 = state_51213;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51213__$1,inst_51211);
} else {
if((state_val_51214 === (15))){
var inst_51209 = (state_51213[(2)]);
var state_51213__$1 = state_51213;
var statearr_51218_51253 = state_51213__$1;
(statearr_51218_51253[(2)] = inst_51209);

(statearr_51218_51253[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (13))){
var inst_51182 = (state_51213[(7)]);
var state_51213__$1 = state_51213;
var statearr_51219_51254 = state_51213__$1;
(statearr_51219_51254[(2)] = inst_51182);

(statearr_51219_51254[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (6))){
var inst_51182 = (state_51213[(7)]);
var inst_51187 = inst_51182.cljs$lang$protocol_mask$partition0$;
var inst_51188 = (inst_51187 & (64));
var inst_51189 = inst_51182.cljs$core$ISeq$;
var inst_51190 = (inst_51188) || (inst_51189);
var state_51213__$1 = state_51213;
if(cljs.core.truth_(inst_51190)){
var statearr_51220_51255 = state_51213__$1;
(statearr_51220_51255[(1)] = (9));

} else {
var statearr_51221_51256 = state_51213__$1;
(statearr_51221_51256[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (17))){
var state_51213__$1 = state_51213;
var statearr_51222_51257 = state_51213__$1;
(statearr_51222_51257[(2)] = null);

(statearr_51222_51257[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (3))){
var inst_51172 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(params,cljs.core.cst$kw$query,query);
var inst_51173 = [cljs.core.cst$kw$cancel];
var inst_51174 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();
var inst_51175 = [inst_51174];
var inst_51176 = cljs.core.PersistentHashMap.fromArrays(inst_51173,inst_51175);
var inst_51177 = cljs.core.cst$kw$cancel.cljs$core$IFn$_invoke$arity$1(inst_51176);
var inst_51178 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$auto_DASH_complete_SLASH_cancel,cljs.core.array_seq([inst_51177], 0));
var inst_51180 = burningswell.web.api.search_autocomplete.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([inst_51172,inst_51176], 0));
var state_51213__$1 = (function (){var statearr_51223 = state_51213;
(statearr_51223[(8)] = inst_51178);

return statearr_51223;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51213__$1,(5),inst_51180);
} else {
if((state_val_51214 === (12))){
var inst_51182 = (state_51213[(7)]);
var inst_51199 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51182);
var state_51213__$1 = state_51213;
var statearr_51224_51258 = state_51213__$1;
(statearr_51224_51258[(2)] = inst_51199);

(statearr_51224_51258[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (2))){
var state_51213__$1 = state_51213;
var statearr_51225_51259 = state_51213__$1;
(statearr_51225_51259[(2)] = null);

(statearr_51225_51259[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (11))){
var inst_51194 = (state_51213[(2)]);
var state_51213__$1 = state_51213;
var statearr_51226_51260 = state_51213__$1;
(statearr_51226_51260[(2)] = inst_51194);

(statearr_51226_51260[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (9))){
var state_51213__$1 = state_51213;
var statearr_51227_51261 = state_51213__$1;
(statearr_51227_51261[(2)] = true);

(statearr_51227_51261[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (5))){
var inst_51182 = (state_51213[(7)]);
var inst_51182__$1 = (state_51213[(2)]);
var inst_51184 = (inst_51182__$1 == null);
var inst_51185 = cljs.core.not(inst_51184);
var state_51213__$1 = (function (){var statearr_51228 = state_51213;
(statearr_51228[(7)] = inst_51182__$1);

return statearr_51228;
})();
if(inst_51185){
var statearr_51229_51262 = state_51213__$1;
(statearr_51229_51262[(1)] = (6));

} else {
var statearr_51230_51263 = state_51213__$1;
(statearr_51230_51263[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (14))){
var inst_51202 = (state_51213[(2)]);
var inst_51203 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51202,cljs.core.cst$kw$status);
var inst_51204 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51202,cljs.core.cst$kw$body);
var state_51213__$1 = (function (){var statearr_51231 = state_51213;
(statearr_51231[(9)] = inst_51204);

return statearr_51231;
})();
var G__51232_51264 = inst_51203;
switch (G__51232_51264) {
case (200):
var statearr_51233_51266 = state_51213__$1;
(statearr_51233_51266[(1)] = (16));


break;
default:
var statearr_51234_51267 = state_51213__$1;
(statearr_51234_51267[(1)] = (17));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (16))){
var inst_51204 = (state_51213[(9)]);
var inst_51205 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$auto_DASH_complete_SLASH_results,cljs.core.array_seq([inst_51204], 0));
var state_51213__$1 = state_51213;
var statearr_51235_51268 = state_51213__$1;
(statearr_51235_51268[(2)] = inst_51205);

(statearr_51235_51268[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (10))){
var state_51213__$1 = state_51213;
var statearr_51236_51269 = state_51213__$1;
(statearr_51236_51269[(2)] = false);

(statearr_51236_51269[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51214 === (8))){
var inst_51197 = (state_51213[(2)]);
var state_51213__$1 = state_51213;
if(cljs.core.truth_(inst_51197)){
var statearr_51237_51270 = state_51213__$1;
(statearr_51237_51270[(1)] = (12));

} else {
var statearr_51238_51271 = state_51213__$1;
(statearr_51238_51271[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__51165,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__51165,params){
return (function() {
var burningswell$web$actions$state_machine__43983__auto__ = null;
var burningswell$web$actions$state_machine__43983__auto____0 = (function (){
var statearr_51242 = [null,null,null,null,null,null,null,null,null,null];
(statearr_51242[(0)] = burningswell$web$actions$state_machine__43983__auto__);

(statearr_51242[(1)] = (1));

return statearr_51242;
});
var burningswell$web$actions$state_machine__43983__auto____1 = (function (state_51213){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51213);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51243){if((e51243 instanceof Object)){
var ex__43986__auto__ = e51243;
var statearr_51244_51272 = state_51213;
(statearr_51244_51272[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51213);

return cljs.core.cst$kw$recur;
} else {
throw e51243;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51273 = state_51213;
state_51213 = G__51273;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$state_machine__43983__auto__ = function(state_51213){
switch(arguments.length){
case 0:
return burningswell$web$actions$state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$state_machine__43983__auto____1.call(this,state_51213);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$state_machine__43983__auto____0;
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$state_machine__43983__auto____1;
return burningswell$web$actions$state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__51165,params))
})();
var state__44282__auto__ = (function (){var statearr_51245 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51245[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51245;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__51165,params))
);

return c__44280__auto__;
});

burningswell.web.actions.auto_complete.cljs$lang$maxFixedArity = (3);

burningswell.web.actions.auto_complete.cljs$lang$applyTo = (function (seq51160){
var G__51161 = cljs.core.first(seq51160);
var seq51160__$1 = cljs.core.next(seq51160);
var G__51162 = cljs.core.first(seq51160__$1);
var seq51160__$2 = cljs.core.next(seq51160__$1);
var G__51163 = cljs.core.first(seq51160__$2);
var seq51160__$3 = cljs.core.next(seq51160__$2);
return burningswell.web.actions.auto_complete.cljs$core$IFn$_invoke$arity$variadic(G__51161,G__51162,G__51163,seq51160__$3);
});

/**
 * Search countries, regions and spots.
 */
burningswell.web.actions.search = (function burningswell$web$actions$search(var_args){
var args__7984__auto__ = [];
var len__7977__auto___51351 = arguments.length;
var i__7978__auto___51352 = (0);
while(true){
if((i__7978__auto___51352 < len__7977__auto___51351)){
args__7984__auto__.push((arguments[i__7978__auto___51352]));

var G__51353 = (i__7978__auto___51352 + (1));
i__7978__auto___51352 = G__51353;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.actions.search.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.actions.search.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__51276){
var vec__51277 = p__51276;
var map__51280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51277,(0),null);
var map__51280__$1 = ((((!((map__51280 == null)))?((((map__51280.cljs$lang$protocol_mask$partition0$ & (64))) || (map__51280.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__51280):map__51280);
var params = map__51280__$1;
var query = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__51280__$1,cljs.core.cst$kw$query);
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$search_SLASH_query,cljs.core.array_seq([query], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__51277,map__51280,map__51280__$1,params,query){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__51277,map__51280,map__51280__$1,params,query){
return (function (state_51319){
var state_val_51320 = (state_51319[(1)]);
if((state_val_51320 === (7))){
var state_51319__$1 = state_51319;
var statearr_51321_51354 = state_51319__$1;
(statearr_51321_51354[(2)] = false);

(statearr_51321_51354[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (1))){
var inst_51282 = clojure.string.blank_QMARK_(query);
var state_51319__$1 = state_51319;
if(inst_51282){
var statearr_51322_51355 = state_51319__$1;
(statearr_51322_51355[(1)] = (2));

} else {
var statearr_51323_51356 = state_51319__$1;
(statearr_51323_51356[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (4))){
var inst_51317 = (state_51319[(2)]);
var state_51319__$1 = state_51319;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51319__$1,inst_51317);
} else {
if((state_val_51320 === (15))){
var inst_51315 = (state_51319[(2)]);
var state_51319__$1 = state_51319;
var statearr_51324_51357 = state_51319__$1;
(statearr_51324_51357[(2)] = inst_51315);

(statearr_51324_51357[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (13))){
var inst_51288 = (state_51319[(7)]);
var state_51319__$1 = state_51319;
var statearr_51325_51358 = state_51319__$1;
(statearr_51325_51358[(2)] = inst_51288);

(statearr_51325_51358[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (6))){
var inst_51288 = (state_51319[(7)]);
var inst_51293 = inst_51288.cljs$lang$protocol_mask$partition0$;
var inst_51294 = (inst_51293 & (64));
var inst_51295 = inst_51288.cljs$core$ISeq$;
var inst_51296 = (inst_51294) || (inst_51295);
var state_51319__$1 = state_51319;
if(cljs.core.truth_(inst_51296)){
var statearr_51326_51359 = state_51319__$1;
(statearr_51326_51359[(1)] = (9));

} else {
var statearr_51327_51360 = state_51319__$1;
(statearr_51327_51360[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (17))){
var state_51319__$1 = state_51319;
var statearr_51328_51361 = state_51319__$1;
(statearr_51328_51361[(2)] = null);

(statearr_51328_51361[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (3))){
var inst_51286 = burningswell.web.api.search_details.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([params], 0));
var state_51319__$1 = state_51319;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51319__$1,(5),inst_51286);
} else {
if((state_val_51320 === (12))){
var inst_51288 = (state_51319[(7)]);
var inst_51305 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51288);
var state_51319__$1 = state_51319;
var statearr_51329_51362 = state_51319__$1;
(statearr_51329_51362[(2)] = inst_51305);

(statearr_51329_51362[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (2))){
var state_51319__$1 = state_51319;
var statearr_51330_51363 = state_51319__$1;
(statearr_51330_51363[(2)] = null);

(statearr_51330_51363[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (11))){
var inst_51300 = (state_51319[(2)]);
var state_51319__$1 = state_51319;
var statearr_51331_51364 = state_51319__$1;
(statearr_51331_51364[(2)] = inst_51300);

(statearr_51331_51364[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (9))){
var state_51319__$1 = state_51319;
var statearr_51332_51365 = state_51319__$1;
(statearr_51332_51365[(2)] = true);

(statearr_51332_51365[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (5))){
var inst_51288 = (state_51319[(7)]);
var inst_51288__$1 = (state_51319[(2)]);
var inst_51290 = (inst_51288__$1 == null);
var inst_51291 = cljs.core.not(inst_51290);
var state_51319__$1 = (function (){var statearr_51333 = state_51319;
(statearr_51333[(7)] = inst_51288__$1);

return statearr_51333;
})();
if(inst_51291){
var statearr_51334_51366 = state_51319__$1;
(statearr_51334_51366[(1)] = (6));

} else {
var statearr_51335_51367 = state_51319__$1;
(statearr_51335_51367[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (14))){
var inst_51308 = (state_51319[(2)]);
var inst_51309 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51308,cljs.core.cst$kw$status);
var inst_51310 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51308,cljs.core.cst$kw$body);
var state_51319__$1 = (function (){var statearr_51336 = state_51319;
(statearr_51336[(8)] = inst_51310);

return statearr_51336;
})();
var G__51337_51368 = inst_51309;
switch (G__51337_51368) {
case (200):
var statearr_51338_51370 = state_51319__$1;
(statearr_51338_51370[(1)] = (16));


break;
default:
var statearr_51339_51371 = state_51319__$1;
(statearr_51339_51371[(1)] = (17));



}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (16))){
var inst_51310 = (state_51319[(8)]);
var inst_51311 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$search_SLASH_results,cljs.core.array_seq([inst_51310], 0));
var state_51319__$1 = state_51319;
var statearr_51340_51372 = state_51319__$1;
(statearr_51340_51372[(2)] = inst_51311);

(statearr_51340_51372[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (10))){
var state_51319__$1 = state_51319;
var statearr_51341_51373 = state_51319__$1;
(statearr_51341_51373[(2)] = false);

(statearr_51341_51373[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51320 === (8))){
var inst_51303 = (state_51319[(2)]);
var state_51319__$1 = state_51319;
if(cljs.core.truth_(inst_51303)){
var statearr_51342_51374 = state_51319__$1;
(statearr_51342_51374[(1)] = (12));

} else {
var statearr_51343_51375 = state_51319__$1;
(statearr_51343_51375[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__51277,map__51280,map__51280__$1,params,query))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__51277,map__51280,map__51280__$1,params,query){
return (function() {
var burningswell$web$actions$state_machine__43983__auto__ = null;
var burningswell$web$actions$state_machine__43983__auto____0 = (function (){
var statearr_51347 = [null,null,null,null,null,null,null,null,null];
(statearr_51347[(0)] = burningswell$web$actions$state_machine__43983__auto__);

(statearr_51347[(1)] = (1));

return statearr_51347;
});
var burningswell$web$actions$state_machine__43983__auto____1 = (function (state_51319){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51319);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51348){if((e51348 instanceof Object)){
var ex__43986__auto__ = e51348;
var statearr_51349_51376 = state_51319;
(statearr_51349_51376[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51319);

return cljs.core.cst$kw$recur;
} else {
throw e51348;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51377 = state_51319;
state_51319 = G__51377;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$state_machine__43983__auto__ = function(state_51319){
switch(arguments.length){
case 0:
return burningswell$web$actions$state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$state_machine__43983__auto____1.call(this,state_51319);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$state_machine__43983__auto____0;
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$state_machine__43983__auto____1;
return burningswell$web$actions$state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__51277,map__51280,map__51280__$1,params,query))
})();
var state__44282__auto__ = (function (){var statearr_51350 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51350[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51350;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__51277,map__51280,map__51280__$1,params,query))
);

return c__44280__auto__;
});

burningswell.web.actions.search.cljs$lang$maxFixedArity = (1);

burningswell.web.actions.search.cljs$lang$applyTo = (function (seq51274){
var G__51275 = cljs.core.first(seq51274);
var seq51274__$1 = cljs.core.next(seq51274);
return burningswell.web.actions.search.cljs$core$IFn$_invoke$arity$variadic(G__51275,seq51274__$1);
});

/**
 * Search spots nearby.
 */
burningswell.web.actions.search_nearby = (function burningswell$web$actions$search_nearby(system){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_51476){
var state_val_51477 = (state_51476[(1)]);
if((state_val_51477 === (7))){
var state_51476__$1 = state_51476;
var statearr_51478_51502 = state_51476__$1;
(statearr_51478_51502[(2)] = false);

(statearr_51478_51502[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (1))){
var inst_51441 = [cljs.core.cst$kw$page,cljs.core.cst$kw$per_DASH_page];
var inst_51442 = [(1),(8)];
var inst_51443 = cljs.core.PersistentHashMap.fromArrays(inst_51441,inst_51442);
var inst_51444 = burningswell.web.actions.current_location_params(system);
var inst_51445 = cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([inst_51443,inst_51444], 0));
var inst_51446 = burningswell.web.api.spots.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([inst_51445], 0));
var state_51476__$1 = state_51476;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51476__$1,(2),inst_51446);
} else {
if((state_val_51477 === (4))){
var state_51476__$1 = state_51476;
var statearr_51479_51503 = state_51476__$1;
(statearr_51479_51503[(2)] = false);

(statearr_51479_51503[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (13))){
var inst_51470 = (state_51476[(7)]);
var inst_51471 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$search_SLASH_nearby,cljs.core.array_seq([inst_51470], 0));
var state_51476__$1 = state_51476;
var statearr_51480_51504 = state_51476__$1;
(statearr_51480_51504[(2)] = inst_51471);

(statearr_51480_51504[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (6))){
var state_51476__$1 = state_51476;
var statearr_51481_51505 = state_51476__$1;
(statearr_51481_51505[(2)] = true);

(statearr_51481_51505[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (3))){
var inst_51448 = (state_51476[(8)]);
var inst_51453 = inst_51448.cljs$lang$protocol_mask$partition0$;
var inst_51454 = (inst_51453 & (64));
var inst_51455 = inst_51448.cljs$core$ISeq$;
var inst_51456 = (inst_51454) || (inst_51455);
var state_51476__$1 = state_51476;
if(cljs.core.truth_(inst_51456)){
var statearr_51482_51506 = state_51476__$1;
(statearr_51482_51506[(1)] = (6));

} else {
var statearr_51483_51507 = state_51476__$1;
(statearr_51483_51507[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (12))){
var inst_51474 = (state_51476[(2)]);
var state_51476__$1 = state_51476;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51476__$1,inst_51474);
} else {
if((state_val_51477 === (2))){
var inst_51448 = (state_51476[(8)]);
var inst_51448__$1 = (state_51476[(2)]);
var inst_51450 = (inst_51448__$1 == null);
var inst_51451 = cljs.core.not(inst_51450);
var state_51476__$1 = (function (){var statearr_51484 = state_51476;
(statearr_51484[(8)] = inst_51448__$1);

return statearr_51484;
})();
if(inst_51451){
var statearr_51485_51508 = state_51476__$1;
(statearr_51485_51508[(1)] = (3));

} else {
var statearr_51486_51509 = state_51476__$1;
(statearr_51486_51509[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (11))){
var inst_51468 = (state_51476[(2)]);
var inst_51469 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51468,cljs.core.cst$kw$status);
var inst_51470 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51468,cljs.core.cst$kw$body);
var state_51476__$1 = (function (){var statearr_51487 = state_51476;
(statearr_51487[(7)] = inst_51470);

return statearr_51487;
})();
var G__51488_51510 = inst_51469;
switch (G__51488_51510) {
case (200):
var statearr_51489_51512 = state_51476__$1;
(statearr_51489_51512[(1)] = (13));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_51469)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (9))){
var inst_51448 = (state_51476[(8)]);
var inst_51465 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51448);
var state_51476__$1 = state_51476;
var statearr_51490_51513 = state_51476__$1;
(statearr_51490_51513[(2)] = inst_51465);

(statearr_51490_51513[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (5))){
var inst_51463 = (state_51476[(2)]);
var state_51476__$1 = state_51476;
if(cljs.core.truth_(inst_51463)){
var statearr_51491_51514 = state_51476__$1;
(statearr_51491_51514[(1)] = (9));

} else {
var statearr_51492_51515 = state_51476__$1;
(statearr_51492_51515[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (10))){
var inst_51448 = (state_51476[(8)]);
var state_51476__$1 = state_51476;
var statearr_51493_51516 = state_51476__$1;
(statearr_51493_51516[(2)] = inst_51448);

(statearr_51493_51516[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51477 === (8))){
var inst_51460 = (state_51476[(2)]);
var state_51476__$1 = state_51476;
var statearr_51494_51517 = state_51476__$1;
(statearr_51494_51517[(2)] = inst_51460);

(statearr_51494_51517[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$search_nearby_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$search_nearby_$_state_machine__43983__auto____0 = (function (){
var statearr_51498 = [null,null,null,null,null,null,null,null,null];
(statearr_51498[(0)] = burningswell$web$actions$search_nearby_$_state_machine__43983__auto__);

(statearr_51498[(1)] = (1));

return statearr_51498;
});
var burningswell$web$actions$search_nearby_$_state_machine__43983__auto____1 = (function (state_51476){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51476);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51499){if((e51499 instanceof Object)){
var ex__43986__auto__ = e51499;
var statearr_51500_51518 = state_51476;
(statearr_51500_51518[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51476);

return cljs.core.cst$kw$recur;
} else {
throw e51499;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51519 = state_51476;
state_51476 = G__51519;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$search_nearby_$_state_machine__43983__auto__ = function(state_51476){
switch(arguments.length){
case 0:
return burningswell$web$actions$search_nearby_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$search_nearby_$_state_machine__43983__auto____1.call(this,state_51476);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$search_nearby_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$search_nearby_$_state_machine__43983__auto____0;
burningswell$web$actions$search_nearby_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$search_nearby_$_state_machine__43983__auto____1;
return burningswell$web$actions$search_nearby_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_51501 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51501[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51501;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Search countries, regions and spots.
 */
burningswell.web.actions.search_details = (function burningswell$web$actions$search_details(system,p__51520){
var vec__51604 = p__51520;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__51604,(0),null);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__51604,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__51604,params){
return (function (state_51652){
var state_val_51653 = (state_51652[(1)]);
if((state_val_51653 === (7))){
var state_51652__$1 = state_51652;
var statearr_51654_51687 = state_51652__$1;
(statearr_51654_51687[(2)] = false);

(statearr_51654_51687[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (1))){
var inst_51607 = cljs.core.cst$kw$query.cljs$core$IFn$_invoke$arity$1(params);
var inst_51608 = clojure.string.blank_QMARK_(inst_51607);
var state_51652__$1 = state_51652;
if(inst_51608){
var statearr_51655_51688 = state_51652__$1;
(statearr_51655_51688[(1)] = (2));

} else {
var statearr_51656_51689 = state_51652__$1;
(statearr_51656_51689[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (4))){
var inst_51650 = (state_51652[(2)]);
var state_51652__$1 = state_51652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51652__$1,inst_51650);
} else {
if((state_val_51653 === (15))){
var inst_51648 = (state_51652[(2)]);
var state_51652__$1 = state_51652;
var statearr_51657_51690 = state_51652__$1;
(statearr_51657_51690[(2)] = inst_51648);

(statearr_51657_51690[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (13))){
var inst_51614 = (state_51652[(7)]);
var state_51652__$1 = state_51652;
var statearr_51658_51691 = state_51652__$1;
(statearr_51658_51691[(2)] = inst_51614);

(statearr_51658_51691[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (6))){
var inst_51614 = (state_51652[(7)]);
var inst_51619 = inst_51614.cljs$lang$protocol_mask$partition0$;
var inst_51620 = (inst_51619 & (64));
var inst_51621 = inst_51614.cljs$core$ISeq$;
var inst_51622 = (inst_51620) || (inst_51621);
var state_51652__$1 = state_51652;
if(cljs.core.truth_(inst_51622)){
var statearr_51659_51692 = state_51652__$1;
(statearr_51659_51692[(1)] = (9));

} else {
var statearr_51660_51693 = state_51652__$1;
(statearr_51660_51693[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (17))){
var inst_51640 = burningswell.web.actions.search_nearby(system);
var state_51652__$1 = state_51652;
var statearr_51661_51694 = state_51652__$1;
(statearr_51661_51694[(2)] = inst_51640);

(statearr_51661_51694[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (3))){
var inst_51612 = burningswell.web.api.search_details.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([params], 0));
var state_51652__$1 = state_51652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51652__$1,(5),inst_51612);
} else {
if((state_val_51653 === (12))){
var inst_51614 = (state_51652[(7)]);
var inst_51631 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51614);
var state_51652__$1 = state_51652;
var statearr_51662_51695 = state_51652__$1;
(statearr_51662_51695[(2)] = inst_51631);

(statearr_51662_51695[(1)] = (14));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (2))){
var state_51652__$1 = state_51652;
var statearr_51663_51696 = state_51652__$1;
(statearr_51663_51696[(2)] = null);

(statearr_51663_51696[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (19))){
var inst_51645 = (state_51652[(2)]);
var state_51652__$1 = state_51652;
var statearr_51664_51697 = state_51652__$1;
(statearr_51664_51697[(2)] = inst_51645);

(statearr_51664_51697[(1)] = (15));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (11))){
var inst_51626 = (state_51652[(2)]);
var state_51652__$1 = state_51652;
var statearr_51665_51698 = state_51652__$1;
(statearr_51665_51698[(2)] = inst_51626);

(statearr_51665_51698[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (9))){
var state_51652__$1 = state_51652;
var statearr_51666_51699 = state_51652__$1;
(statearr_51666_51699[(2)] = true);

(statearr_51666_51699[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (5))){
var inst_51614 = (state_51652[(7)]);
var inst_51614__$1 = (state_51652[(2)]);
var inst_51616 = (inst_51614__$1 == null);
var inst_51617 = cljs.core.not(inst_51616);
var state_51652__$1 = (function (){var statearr_51667 = state_51652;
(statearr_51667[(7)] = inst_51614__$1);

return statearr_51667;
})();
if(inst_51617){
var statearr_51668_51700 = state_51652__$1;
(statearr_51668_51700[(1)] = (6));

} else {
var statearr_51669_51701 = state_51652__$1;
(statearr_51669_51701[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (14))){
var inst_51634 = (state_51652[(2)]);
var inst_51635 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51634,cljs.core.cst$kw$status);
var inst_51636 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51634,cljs.core.cst$kw$body);
var state_51652__$1 = (function (){var statearr_51670 = state_51652;
(statearr_51670[(8)] = inst_51636);

return statearr_51670;
})();
var G__51671_51702 = inst_51635;
switch (G__51671_51702) {
case (200):
var statearr_51672_51704 = state_51652__$1;
(statearr_51672_51704[(1)] = (16));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_51635)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (16))){
var inst_51636 = (state_51652[(8)]);
var inst_51637 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$search_SLASH_details,cljs.core.array_seq([inst_51636], 0));
var inst_51638 = cljs.core.empty_QMARK_(inst_51636);
var state_51652__$1 = (function (){var statearr_51673 = state_51652;
(statearr_51673[(9)] = inst_51637);

return statearr_51673;
})();
if(inst_51638){
var statearr_51674_51705 = state_51652__$1;
(statearr_51674_51705[(1)] = (17));

} else {
var statearr_51675_51706 = state_51652__$1;
(statearr_51675_51706[(1)] = (18));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (10))){
var state_51652__$1 = state_51652;
var statearr_51676_51707 = state_51652__$1;
(statearr_51676_51707[(2)] = false);

(statearr_51676_51707[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (18))){
var inst_51642 = cljs.core.PersistentVector.EMPTY;
var inst_51643 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$search_SLASH_nearby,cljs.core.array_seq([inst_51642], 0));
var state_51652__$1 = state_51652;
var statearr_51677_51708 = state_51652__$1;
(statearr_51677_51708[(2)] = inst_51643);

(statearr_51677_51708[(1)] = (19));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51653 === (8))){
var inst_51629 = (state_51652[(2)]);
var state_51652__$1 = state_51652;
if(cljs.core.truth_(inst_51629)){
var statearr_51678_51709 = state_51652__$1;
(statearr_51678_51709[(1)] = (12));

} else {
var statearr_51679_51710 = state_51652__$1;
(statearr_51679_51710[(1)] = (13));

}

return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__51604,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__51604,params){
return (function() {
var burningswell$web$actions$search_details_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$search_details_$_state_machine__43983__auto____0 = (function (){
var statearr_51683 = [null,null,null,null,null,null,null,null,null,null];
(statearr_51683[(0)] = burningswell$web$actions$search_details_$_state_machine__43983__auto__);

(statearr_51683[(1)] = (1));

return statearr_51683;
});
var burningswell$web$actions$search_details_$_state_machine__43983__auto____1 = (function (state_51652){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51652);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51684){if((e51684 instanceof Object)){
var ex__43986__auto__ = e51684;
var statearr_51685_51711 = state_51652;
(statearr_51685_51711[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51652);

return cljs.core.cst$kw$recur;
} else {
throw e51684;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51712 = state_51652;
state_51652 = G__51712;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$search_details_$_state_machine__43983__auto__ = function(state_51652){
switch(arguments.length){
case 0:
return burningswell$web$actions$search_details_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$search_details_$_state_machine__43983__auto____1.call(this,state_51652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$search_details_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$search_details_$_state_machine__43983__auto____0;
burningswell$web$actions$search_details_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$search_details_$_state_machine__43983__auto____1;
return burningswell$web$actions$search_details_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__51604,params))
})();
var state__44282__auto__ = (function (){var statearr_51686 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51686[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51686;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__51604,params))
);

return c__44280__auto__;
});
/**
 * Fetch and set the current user.
 */
burningswell.web.actions.signin_with_token = (function burningswell$web$actions$signin_with_token(system,token){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_51822){
var state_val_51823 = (state_51822[(1)]);
if((state_val_51823 === (7))){
var state_51822__$1 = state_51822;
var statearr_51824_51855 = state_51822__$1;
(statearr_51824_51855[(2)] = false);

(statearr_51824_51855[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (1))){
var inst_51785 = cljs.core.cst$kw$local_DASH_storage.cljs$core$IFn$_invoke$arity$1(system);
var inst_51786 = burningswell.web.api.me(system,token);
var state_51822__$1 = (function (){var statearr_51825 = state_51822;
(statearr_51825[(7)] = inst_51785);

return statearr_51825;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51822__$1,(2),inst_51786);
} else {
if((state_val_51823 === (4))){
var state_51822__$1 = state_51822;
var statearr_51826_51856 = state_51822__$1;
(statearr_51826_51856[(2)] = false);

(statearr_51826_51856[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (15))){
var inst_51785 = (state_51822[(7)]);
var inst_51817 = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(inst_51785,cljs.core.cst$kw$user);
var state_51822__$1 = (function (){var statearr_51827 = state_51822;
(statearr_51827[(8)] = inst_51817);

return statearr_51827;
})();
var statearr_51828_51857 = state_51822__$1;
(statearr_51828_51857[(2)] = false);

(statearr_51828_51857[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (13))){
var inst_51811 = (state_51822[(9)]);
var inst_51785 = (state_51822[(7)]);
var inst_51812 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(inst_51785,cljs.core.cst$kw$user,inst_51811);
var inst_51813 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$user_SLASH_received,cljs.core.array_seq([inst_51811], 0));
var inst_51814 = burningswell.web.actions.navigate(system,"/spots");
var state_51822__$1 = (function (){var statearr_51829 = state_51822;
(statearr_51829[(10)] = inst_51812);

(statearr_51829[(11)] = inst_51813);

(statearr_51829[(12)] = inst_51814);

return statearr_51829;
})();
var statearr_51830_51858 = state_51822__$1;
(statearr_51830_51858[(2)] = true);

(statearr_51830_51858[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (6))){
var state_51822__$1 = state_51822;
var statearr_51831_51859 = state_51822__$1;
(statearr_51831_51859[(2)] = true);

(statearr_51831_51859[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (3))){
var inst_51788 = (state_51822[(13)]);
var inst_51793 = inst_51788.cljs$lang$protocol_mask$partition0$;
var inst_51794 = (inst_51793 & (64));
var inst_51795 = inst_51788.cljs$core$ISeq$;
var inst_51796 = (inst_51794) || (inst_51795);
var state_51822__$1 = state_51822;
if(cljs.core.truth_(inst_51796)){
var statearr_51832_51860 = state_51822__$1;
(statearr_51832_51860[(1)] = (6));

} else {
var statearr_51833_51861 = state_51822__$1;
(statearr_51833_51861[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (12))){
var inst_51820 = (state_51822[(2)]);
var state_51822__$1 = state_51822;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51822__$1,inst_51820);
} else {
if((state_val_51823 === (2))){
var inst_51788 = (state_51822[(13)]);
var inst_51788__$1 = (state_51822[(2)]);
var inst_51790 = (inst_51788__$1 == null);
var inst_51791 = cljs.core.not(inst_51790);
var state_51822__$1 = (function (){var statearr_51834 = state_51822;
(statearr_51834[(13)] = inst_51788__$1);

return statearr_51834;
})();
if(inst_51791){
var statearr_51835_51862 = state_51822__$1;
(statearr_51835_51862[(1)] = (3));

} else {
var statearr_51836_51863 = state_51822__$1;
(statearr_51836_51863[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (11))){
var inst_51808 = (state_51822[(2)]);
var inst_51809 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51808,cljs.core.cst$kw$status);
var inst_51810 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_51808,cljs.core.cst$kw$body);
var inst_51811 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(inst_51810,cljs.core.cst$kw$auth_DASH_token,token);
var state_51822__$1 = (function (){var statearr_51837 = state_51822;
(statearr_51837[(9)] = inst_51811);

return statearr_51837;
})();
var G__51838_51864 = inst_51809;
switch (G__51838_51864) {
case (200):
var statearr_51839_51866 = state_51822__$1;
(statearr_51839_51866[(1)] = (13));


break;
case (401):
var statearr_51840_51867 = state_51822__$1;
(statearr_51840_51867[(1)] = (14));


break;
case (422):
var statearr_51841_51868 = state_51822__$1;
(statearr_51841_51868[(1)] = (15));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_51809)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (9))){
var inst_51788 = (state_51822[(13)]);
var inst_51805 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_51788);
var state_51822__$1 = state_51822;
var statearr_51842_51869 = state_51822__$1;
(statearr_51842_51869[(2)] = inst_51805);

(statearr_51842_51869[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (5))){
var inst_51803 = (state_51822[(2)]);
var state_51822__$1 = state_51822;
if(cljs.core.truth_(inst_51803)){
var statearr_51843_51870 = state_51822__$1;
(statearr_51843_51870[(1)] = (9));

} else {
var statearr_51844_51871 = state_51822__$1;
(statearr_51844_51871[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (14))){
var state_51822__$1 = state_51822;
var statearr_51845_51872 = state_51822__$1;
(statearr_51845_51872[(2)] = false);

(statearr_51845_51872[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (10))){
var inst_51788 = (state_51822[(13)]);
var state_51822__$1 = state_51822;
var statearr_51846_51873 = state_51822__$1;
(statearr_51846_51873[(2)] = inst_51788);

(statearr_51846_51873[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51823 === (8))){
var inst_51800 = (state_51822[(2)]);
var state_51822__$1 = state_51822;
var statearr_51847_51874 = state_51822__$1;
(statearr_51847_51874[(2)] = inst_51800);

(statearr_51847_51874[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$signin_with_token_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$signin_with_token_$_state_machine__43983__auto____0 = (function (){
var statearr_51851 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_51851[(0)] = burningswell$web$actions$signin_with_token_$_state_machine__43983__auto__);

(statearr_51851[(1)] = (1));

return statearr_51851;
});
var burningswell$web$actions$signin_with_token_$_state_machine__43983__auto____1 = (function (state_51822){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51822);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51852){if((e51852 instanceof Object)){
var ex__43986__auto__ = e51852;
var statearr_51853_51875 = state_51822;
(statearr_51853_51875[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51822);

return cljs.core.cst$kw$recur;
} else {
throw e51852;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51876 = state_51822;
state_51822 = G__51876;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$signin_with_token_$_state_machine__43983__auto__ = function(state_51822){
switch(arguments.length){
case 0:
return burningswell$web$actions$signin_with_token_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$signin_with_token_$_state_machine__43983__auto____1.call(this,state_51822);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$signin_with_token_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$signin_with_token_$_state_machine__43983__auto____0;
burningswell$web$actions$signin_with_token_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$signin_with_token_$_state_machine__43983__auto____1;
return burningswell$web$actions$signin_with_token_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_51854 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51854[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51854;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Sign a user in using the query params.
 */
burningswell.web.actions.signin_query_params = (function burningswell$web$actions$signin_query_params(system){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_51940){
var state_val_51941 = (state_51940[(1)]);
if((state_val_51941 === (1))){
var inst_51920 = (state_51940[(7)]);
var inst_51918 = cljs.core.cst$kw$coolant.cljs$core$IFn$_invoke$arity$1(system);
var inst_51919 = coolant.core.evaluate(inst_51918,burningswell.web.getter.core.route);
var inst_51920__$1 = cljs.core.cst$kw$query_DASH_params.cljs$core$IFn$_invoke$arity$1(inst_51919);
var inst_51921 = cljs.core.cst$kw$token.cljs$core$IFn$_invoke$arity$1(inst_51920__$1);
var state_51940__$1 = (function (){var statearr_51942 = state_51940;
(statearr_51942[(7)] = inst_51920__$1);

return statearr_51942;
})();
if(cljs.core.truth_(inst_51921)){
var statearr_51943_51959 = state_51940__$1;
(statearr_51943_51959[(1)] = (2));

} else {
var statearr_51944_51960 = state_51940__$1;
(statearr_51944_51960[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51941 === (2))){
var inst_51920 = (state_51940[(7)]);
var inst_51923 = cljs.core.cst$kw$token.cljs$core$IFn$_invoke$arity$1(inst_51920);
var inst_51924 = burningswell.web.actions.signin_with_token(system,inst_51923);
var state_51940__$1 = state_51940;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_51940__$1,(5),inst_51924);
} else {
if((state_val_51941 === (3))){
var inst_51920 = (state_51940[(7)]);
var inst_51928 = cljs.core.cst$kw$error.cljs$core$IFn$_invoke$arity$1(inst_51920);
var state_51940__$1 = state_51940;
if(cljs.core.truth_(inst_51928)){
var statearr_51945_51961 = state_51940__$1;
(statearr_51945_51961[(1)] = (6));

} else {
var statearr_51946_51962 = state_51940__$1;
(statearr_51946_51962[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_51941 === (4))){
var inst_51938 = (state_51940[(2)]);
var state_51940__$1 = state_51940;
return cljs.core.async.impl.ioc_helpers.return_chan(state_51940__$1,inst_51938);
} else {
if((state_val_51941 === (5))){
var inst_51926 = (state_51940[(2)]);
var state_51940__$1 = state_51940;
var statearr_51947_51963 = state_51940__$1;
(statearr_51947_51963[(2)] = inst_51926);

(statearr_51947_51963[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51941 === (6))){
var inst_51920 = (state_51940[(7)]);
var inst_51930 = [cljs.core.cst$kw$oauth];
var inst_51931 = [inst_51920];
var inst_51932 = cljs.core.PersistentHashMap.fromArrays(inst_51930,inst_51931);
var inst_51933 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signin_SLASH_failed,cljs.core.array_seq([inst_51932], 0));
var state_51940__$1 = (function (){var statearr_51948 = state_51940;
(statearr_51948[(8)] = inst_51933);

return statearr_51948;
})();
var statearr_51949_51964 = state_51940__$1;
(statearr_51949_51964[(2)] = false);

(statearr_51949_51964[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51941 === (7))){
var state_51940__$1 = state_51940;
var statearr_51950_51965 = state_51940__$1;
(statearr_51950_51965[(2)] = null);

(statearr_51950_51965[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_51941 === (8))){
var inst_51936 = (state_51940[(2)]);
var state_51940__$1 = state_51940;
var statearr_51951_51966 = state_51940__$1;
(statearr_51951_51966[(2)] = inst_51936);

(statearr_51951_51966[(1)] = (4));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$signin_query_params_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$signin_query_params_$_state_machine__43983__auto____0 = (function (){
var statearr_51955 = [null,null,null,null,null,null,null,null,null];
(statearr_51955[(0)] = burningswell$web$actions$signin_query_params_$_state_machine__43983__auto__);

(statearr_51955[(1)] = (1));

return statearr_51955;
});
var burningswell$web$actions$signin_query_params_$_state_machine__43983__auto____1 = (function (state_51940){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_51940);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e51956){if((e51956 instanceof Object)){
var ex__43986__auto__ = e51956;
var statearr_51957_51967 = state_51940;
(statearr_51957_51967[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_51940);

return cljs.core.cst$kw$recur;
} else {
throw e51956;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__51968 = state_51940;
state_51940 = G__51968;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$signin_query_params_$_state_machine__43983__auto__ = function(state_51940){
switch(arguments.length){
case 0:
return burningswell$web$actions$signin_query_params_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$signin_query_params_$_state_machine__43983__auto____1.call(this,state_51940);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$signin_query_params_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$signin_query_params_$_state_machine__43983__auto____0;
burningswell$web$actions$signin_query_params_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$signin_query_params_$_state_machine__43983__auto____1;
return burningswell$web$actions$signin_query_params_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_51958 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_51958[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_51958;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Sign a user in.
 */
burningswell.web.actions.signin = (function burningswell$web$actions$signin(system,user){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_52074){
var state_val_52075 = (state_52074[(1)]);
if((state_val_52075 === (7))){
var state_52074__$1 = state_52074;
var statearr_52076_52103 = state_52074__$1;
(statearr_52076_52103[(2)] = false);

(statearr_52076_52103[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (1))){
var inst_52037 = burningswell.web.api.create_jws_token(system,user);
var state_52074__$1 = state_52074;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52074__$1,(2),inst_52037);
} else {
if((state_val_52075 === (4))){
var state_52074__$1 = state_52074;
var statearr_52077_52104 = state_52074__$1;
(statearr_52077_52104[(2)] = false);

(statearr_52077_52104[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (13))){
var inst_52061 = (state_52074[(7)]);
var inst_52062 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signin_SLASH_clear,cljs.core.array_seq([inst_52061], 0));
var inst_52063 = cljs.core.cst$kw$token.cljs$core$IFn$_invoke$arity$1(inst_52061);
var inst_52064 = burningswell.web.actions.signin_with_token(system,inst_52063);
var state_52074__$1 = (function (){var statearr_52078 = state_52074;
(statearr_52078[(8)] = inst_52062);

return statearr_52078;
})();
var statearr_52079_52105 = state_52074__$1;
(statearr_52079_52105[(2)] = inst_52064);

(statearr_52079_52105[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (6))){
var state_52074__$1 = state_52074;
var statearr_52080_52106 = state_52074__$1;
(statearr_52080_52106[(2)] = true);

(statearr_52080_52106[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (3))){
var inst_52039 = (state_52074[(9)]);
var inst_52044 = inst_52039.cljs$lang$protocol_mask$partition0$;
var inst_52045 = (inst_52044 & (64));
var inst_52046 = inst_52039.cljs$core$ISeq$;
var inst_52047 = (inst_52045) || (inst_52046);
var state_52074__$1 = state_52074;
if(cljs.core.truth_(inst_52047)){
var statearr_52081_52107 = state_52074__$1;
(statearr_52081_52107[(1)] = (6));

} else {
var statearr_52082_52108 = state_52074__$1;
(statearr_52082_52108[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (12))){
var inst_52072 = (state_52074[(2)]);
var state_52074__$1 = state_52074;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52074__$1,inst_52072);
} else {
if((state_val_52075 === (2))){
var inst_52039 = (state_52074[(9)]);
var inst_52039__$1 = (state_52074[(2)]);
var inst_52041 = (inst_52039__$1 == null);
var inst_52042 = cljs.core.not(inst_52041);
var state_52074__$1 = (function (){var statearr_52083 = state_52074;
(statearr_52083[(9)] = inst_52039__$1);

return statearr_52083;
})();
if(inst_52042){
var statearr_52084_52109 = state_52074__$1;
(statearr_52084_52109[(1)] = (3));

} else {
var statearr_52085_52110 = state_52074__$1;
(statearr_52085_52110[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (11))){
var inst_52059 = (state_52074[(2)]);
var inst_52060 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52059,cljs.core.cst$kw$status);
var inst_52061 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52059,cljs.core.cst$kw$body);
var state_52074__$1 = (function (){var statearr_52086 = state_52074;
(statearr_52086[(7)] = inst_52061);

return statearr_52086;
})();
var G__52087_52111 = inst_52060;
switch (G__52087_52111) {
case (201):
var statearr_52088_52113 = state_52074__$1;
(statearr_52088_52113[(1)] = (13));


break;
case (401):
var statearr_52089_52114 = state_52074__$1;
(statearr_52089_52114[(1)] = (14));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_52060)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (9))){
var inst_52039 = (state_52074[(9)]);
var inst_52056 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52039);
var state_52074__$1 = state_52074;
var statearr_52090_52115 = state_52074__$1;
(statearr_52090_52115[(2)] = inst_52056);

(statearr_52090_52115[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (5))){
var inst_52054 = (state_52074[(2)]);
var state_52074__$1 = state_52074;
if(cljs.core.truth_(inst_52054)){
var statearr_52091_52116 = state_52074__$1;
(statearr_52091_52116[(1)] = (9));

} else {
var statearr_52092_52117 = state_52074__$1;
(statearr_52092_52117[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (14))){
var inst_52066 = [cljs.core.cst$kw$password];
var inst_52067 = [cljs.core.cst$kw$incorrect_DASH_credentials];
var inst_52068 = cljs.core.PersistentHashMap.fromArrays(inst_52066,inst_52067);
var inst_52069 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signin_SLASH_errors,cljs.core.array_seq([inst_52068], 0));
var state_52074__$1 = state_52074;
var statearr_52093_52118 = state_52074__$1;
(statearr_52093_52118[(2)] = inst_52069);

(statearr_52093_52118[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (10))){
var inst_52039 = (state_52074[(9)]);
var state_52074__$1 = state_52074;
var statearr_52094_52119 = state_52074__$1;
(statearr_52094_52119[(2)] = inst_52039);

(statearr_52094_52119[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52075 === (8))){
var inst_52051 = (state_52074[(2)]);
var state_52074__$1 = state_52074;
var statearr_52095_52120 = state_52074__$1;
(statearr_52095_52120[(2)] = inst_52051);

(statearr_52095_52120[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$signin_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$signin_$_state_machine__43983__auto____0 = (function (){
var statearr_52099 = [null,null,null,null,null,null,null,null,null,null];
(statearr_52099[(0)] = burningswell$web$actions$signin_$_state_machine__43983__auto__);

(statearr_52099[(1)] = (1));

return statearr_52099;
});
var burningswell$web$actions$signin_$_state_machine__43983__auto____1 = (function (state_52074){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52074);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52100){if((e52100 instanceof Object)){
var ex__43986__auto__ = e52100;
var statearr_52101_52121 = state_52074;
(statearr_52101_52121[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52074);

return cljs.core.cst$kw$recur;
} else {
throw e52100;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52122 = state_52074;
state_52074 = G__52122;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$signin_$_state_machine__43983__auto__ = function(state_52074){
switch(arguments.length){
case 0:
return burningswell$web$actions$signin_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$signin_$_state_machine__43983__auto____1.call(this,state_52074);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$signin_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$signin_$_state_machine__43983__auto____0;
burningswell$web$actions$signin_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$signin_$_state_machine__43983__auto____1;
return burningswell$web$actions$signin_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_52102 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52102[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52102;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Sign a user up.
 */
burningswell.web.actions.signup = (function burningswell$web$actions$signup(system,user){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_52232){
var state_val_52233 = (state_52232[(1)]);
if((state_val_52233 === (7))){
var state_52232__$1 = state_52232;
var statearr_52234_52261 = state_52232__$1;
(statearr_52234_52261[(2)] = false);

(statearr_52234_52261[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (1))){
var inst_52193 = burningswell.web.api.create_user(system,user);
var state_52232__$1 = state_52232;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52232__$1,(2),inst_52193);
} else {
if((state_val_52233 === (4))){
var state_52232__$1 = state_52232;
var statearr_52235_52262 = state_52232__$1;
(statearr_52235_52262[(2)] = false);

(statearr_52235_52262[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (13))){
var inst_52217 = (state_52232[(7)]);
var inst_52218 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signup_SLASH_complete,cljs.core.array_seq([inst_52217], 0));
var inst_52219 = [cljs.core.cst$kw$login,cljs.core.cst$kw$password];
var inst_52220 = cljs.core.cst$kw$username.cljs$core$IFn$_invoke$arity$1(user);
var inst_52221 = cljs.core.cst$kw$password.cljs$core$IFn$_invoke$arity$1(user);
var inst_52222 = [inst_52220,inst_52221];
var inst_52223 = cljs.core.PersistentHashMap.fromArrays(inst_52219,inst_52222);
var inst_52224 = burningswell.web.actions.signin(system,inst_52223);
var state_52232__$1 = (function (){var statearr_52236 = state_52232;
(statearr_52236[(8)] = inst_52218);

return statearr_52236;
})();
var statearr_52237_52263 = state_52232__$1;
(statearr_52237_52263[(2)] = inst_52224);

(statearr_52237_52263[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (6))){
var state_52232__$1 = state_52232;
var statearr_52238_52264 = state_52232__$1;
(statearr_52238_52264[(2)] = true);

(statearr_52238_52264[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (3))){
var inst_52195 = (state_52232[(9)]);
var inst_52200 = inst_52195.cljs$lang$protocol_mask$partition0$;
var inst_52201 = (inst_52200 & (64));
var inst_52202 = inst_52195.cljs$core$ISeq$;
var inst_52203 = (inst_52201) || (inst_52202);
var state_52232__$1 = state_52232;
if(cljs.core.truth_(inst_52203)){
var statearr_52239_52265 = state_52232__$1;
(statearr_52239_52265[(1)] = (6));

} else {
var statearr_52240_52266 = state_52232__$1;
(statearr_52240_52266[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (12))){
var inst_52230 = (state_52232[(2)]);
var state_52232__$1 = state_52232;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52232__$1,inst_52230);
} else {
if((state_val_52233 === (2))){
var inst_52195 = (state_52232[(9)]);
var inst_52195__$1 = (state_52232[(2)]);
var inst_52197 = (inst_52195__$1 == null);
var inst_52198 = cljs.core.not(inst_52197);
var state_52232__$1 = (function (){var statearr_52241 = state_52232;
(statearr_52241[(9)] = inst_52195__$1);

return statearr_52241;
})();
if(inst_52198){
var statearr_52242_52267 = state_52232__$1;
(statearr_52242_52267[(1)] = (3));

} else {
var statearr_52243_52268 = state_52232__$1;
(statearr_52243_52268[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (11))){
var inst_52215 = (state_52232[(2)]);
var inst_52216 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52215,cljs.core.cst$kw$status);
var inst_52217 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52215,cljs.core.cst$kw$body);
var state_52232__$1 = (function (){var statearr_52244 = state_52232;
(statearr_52244[(7)] = inst_52217);

return statearr_52244;
})();
var G__52245_52269 = inst_52216;
switch (G__52245_52269) {
case (201):
var statearr_52246_52271 = state_52232__$1;
(statearr_52246_52271[(1)] = (13));


break;
case (422):
var statearr_52247_52272 = state_52232__$1;
(statearr_52247_52272[(1)] = (14));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_52216)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (9))){
var inst_52195 = (state_52232[(9)]);
var inst_52212 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52195);
var state_52232__$1 = state_52232;
var statearr_52248_52273 = state_52232__$1;
(statearr_52248_52273[(2)] = inst_52212);

(statearr_52248_52273[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (5))){
var inst_52210 = (state_52232[(2)]);
var state_52232__$1 = state_52232;
if(cljs.core.truth_(inst_52210)){
var statearr_52249_52274 = state_52232__$1;
(statearr_52249_52274[(1)] = (9));

} else {
var statearr_52250_52275 = state_52232__$1;
(statearr_52250_52275[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (14))){
var inst_52217 = (state_52232[(7)]);
var inst_52226 = cljs.core.cst$kw$errors.cljs$core$IFn$_invoke$arity$1(inst_52217);
var inst_52227 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$signup_SLASH_errors,cljs.core.array_seq([inst_52226], 0));
var state_52232__$1 = state_52232;
var statearr_52251_52276 = state_52232__$1;
(statearr_52251_52276[(2)] = inst_52227);

(statearr_52251_52276[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (10))){
var inst_52195 = (state_52232[(9)]);
var state_52232__$1 = state_52232;
var statearr_52252_52277 = state_52232__$1;
(statearr_52252_52277[(2)] = inst_52195);

(statearr_52252_52277[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52233 === (8))){
var inst_52207 = (state_52232[(2)]);
var state_52232__$1 = state_52232;
var statearr_52253_52278 = state_52232__$1;
(statearr_52253_52278[(2)] = inst_52207);

(statearr_52253_52278[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$signup_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$signup_$_state_machine__43983__auto____0 = (function (){
var statearr_52257 = [null,null,null,null,null,null,null,null,null,null];
(statearr_52257[(0)] = burningswell$web$actions$signup_$_state_machine__43983__auto__);

(statearr_52257[(1)] = (1));

return statearr_52257;
});
var burningswell$web$actions$signup_$_state_machine__43983__auto____1 = (function (state_52232){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52232);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52258){if((e52258 instanceof Object)){
var ex__43986__auto__ = e52258;
var statearr_52259_52279 = state_52232;
(statearr_52259_52279[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52232);

return cljs.core.cst$kw$recur;
} else {
throw e52258;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52280 = state_52232;
state_52232 = G__52280;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$signup_$_state_machine__43983__auto__ = function(state_52232){
switch(arguments.length){
case 0:
return burningswell$web$actions$signup_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$signup_$_state_machine__43983__auto____1.call(this,state_52232);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$signup_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$signup_$_state_machine__43983__auto____0;
burningswell$web$actions$signup_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$signup_$_state_machine__43983__auto____1;
return burningswell$web$actions$signup_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_52260 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52260[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52260;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Fetch a spot.
 */
burningswell.web.actions.spot = (function burningswell$web$actions$spot(system,spot__$1){
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([true], 0));

burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_spot,cljs.core.array_seq([spot__$1], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_52360){
var state_val_52361 = (state_52360[(1)]);
if((state_val_52361 === (1))){
var inst_52327 = burningswell.web.api.pagination(system,cljs.core.cst$kw$collection);
var inst_52328 = burningswell.web.api.spot.cljs$core$IFn$_invoke$arity$variadic(system,spot__$1,cljs.core.array_seq([inst_52327], 0));
var state_52360__$1 = state_52360;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52360__$1,(2),inst_52328);
} else {
if((state_val_52361 === (2))){
var inst_52330 = (state_52360[(2)]);
var inst_52331 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_52330);
var inst_52332 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_spot,cljs.core.array_seq([inst_52331], 0));
var inst_52333 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52334 = burningswell.web.api.spot_photos(system,spot__$1);
var state_52360__$1 = (function (){var statearr_52362 = state_52360;
(statearr_52362[(7)] = inst_52332);

(statearr_52362[(8)] = inst_52333);

return statearr_52362;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52360__$1,(3),inst_52334);
} else {
if((state_val_52361 === (3))){
var inst_52333 = (state_52360[(8)]);
var inst_52336 = (state_52360[(2)]);
var inst_52337 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_52336);
var inst_52338 = [spot__$1,inst_52337];
var inst_52339 = (new cljs.core.PersistentVector(null,2,(5),inst_52333,inst_52338,null));
var inst_52340 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_photos,cljs.core.array_seq([inst_52339], 0));
var inst_52341 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52342 = burningswell.web.api.spot_weather(system,spot__$1);
var state_52360__$1 = (function (){var statearr_52363 = state_52360;
(statearr_52363[(9)] = inst_52340);

(statearr_52363[(10)] = inst_52341);

return statearr_52363;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52360__$1,(4),inst_52342);
} else {
if((state_val_52361 === (4))){
var inst_52341 = (state_52360[(10)]);
var inst_52344 = (state_52360[(2)]);
var inst_52345 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_52344);
var inst_52346 = [spot__$1,inst_52345];
var inst_52347 = (new cljs.core.PersistentVector(null,2,(5),inst_52341,inst_52346,null));
var inst_52348 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_weather,cljs.core.array_seq([inst_52347], 0));
var inst_52349 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52350 = burningswell.web.api.pagination(system,cljs.core.cst$kw$spots_DASH_around);
var inst_52351 = burningswell.web.api.spots_around.cljs$core$IFn$_invoke$arity$variadic(system,spot__$1,cljs.core.array_seq([inst_52350], 0));
var state_52360__$1 = (function (){var statearr_52364 = state_52360;
(statearr_52364[(11)] = inst_52349);

(statearr_52364[(12)] = inst_52348);

return statearr_52364;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52360__$1,(5),inst_52351);
} else {
if((state_val_52361 === (5))){
var inst_52349 = (state_52360[(11)]);
var inst_52353 = (state_52360[(2)]);
var inst_52354 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_52353);
var inst_52355 = [spot__$1,inst_52354];
var inst_52356 = (new cljs.core.PersistentVector(null,2,(5),inst_52349,inst_52355,null));
var inst_52357 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_spots,cljs.core.array_seq([inst_52356], 0));
var inst_52358 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([false], 0));
var state_52360__$1 = (function (){var statearr_52365 = state_52360;
(statearr_52365[(13)] = inst_52357);

return statearr_52365;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52360__$1,inst_52358);
} else {
return null;
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$spot_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$spot_$_state_machine__43983__auto____0 = (function (){
var statearr_52369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52369[(0)] = burningswell$web$actions$spot_$_state_machine__43983__auto__);

(statearr_52369[(1)] = (1));

return statearr_52369;
});
var burningswell$web$actions$spot_$_state_machine__43983__auto____1 = (function (state_52360){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52360);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52370){if((e52370 instanceof Object)){
var ex__43986__auto__ = e52370;
var statearr_52371_52373 = state_52360;
(statearr_52371_52373[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52360);

return cljs.core.cst$kw$recur;
} else {
throw e52370;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52374 = state_52360;
state_52360 = G__52374;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$spot_$_state_machine__43983__auto__ = function(state_52360){
switch(arguments.length){
case 0:
return burningswell$web$actions$spot_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$spot_$_state_machine__43983__auto____1.call(this,state_52360);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$spot_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$spot_$_state_machine__43983__auto____0;
burningswell$web$actions$spot_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$spot_$_state_machine__43983__auto____1;
return burningswell$web$actions$spot_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_52372 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52372[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52372;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Return the query params for the spots page.
 */
burningswell.web.actions.spots_params = (function burningswell$web$actions$spots_params(var_args){
var args__7984__auto__ = [];
var len__7977__auto___52381 = arguments.length;
var i__7978__auto___52382 = (0);
while(true){
if((i__7978__auto___52382 < len__7977__auto___52381)){
args__7984__auto__.push((arguments[i__7978__auto___52382]));

var G__52383 = (i__7978__auto___52382 + (1));
i__7978__auto___52382 = G__52383;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.actions.spots_params.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.actions.spots_params.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__52377){
var vec__52378 = p__52377;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52378,(0),null);
return cljs.core.merge.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([burningswell.web.actions.current_location_params(system),burningswell.web.api.pagination(system,cljs.core.cst$kw$collection),params], 0));
});

burningswell.web.actions.spots_params.cljs$lang$maxFixedArity = (1);

burningswell.web.actions.spots_params.cljs$lang$applyTo = (function (seq52375){
var G__52376 = cljs.core.first(seq52375);
var seq52375__$1 = cljs.core.next(seq52375);
return burningswell.web.actions.spots_params.cljs$core$IFn$_invoke$arity$variadic(G__52376,seq52375__$1);
});

/**
 * Fetch the spots.
 */
burningswell.web.actions.spots = (function burningswell$web$actions$spots(var_args){
var args__7984__auto__ = [];
var len__7977__auto___52450 = arguments.length;
var i__7978__auto___52451 = (0);
while(true){
if((i__7978__auto___52451 < len__7977__auto___52450)){
args__7984__auto__.push((arguments[i__7978__auto___52451]));

var G__52452 = (i__7978__auto___52451 + (1));
i__7978__auto___52451 = G__52452;
continue;
} else {
}
break;
}

var argseq__7985__auto__ = ((((1) < args__7984__auto__.length))?(new cljs.core.IndexedSeq(args__7984__auto__.slice((1)),(0),null)):null);
return burningswell.web.actions.spots.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__7985__auto__);
});

burningswell.web.actions.spots.cljs$core$IFn$_invoke$arity$variadic = (function (system,p__52386){
var vec__52387 = p__52386;
var params = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52387,(0),null);
burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([true], 0));

var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__52387,params){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__52387,params){
return (function (state_52423){
var state_val_52424 = (state_52423[(1)]);
if((state_val_52424 === (7))){
var state_52423__$1 = state_52423;
var statearr_52425_52453 = state_52423__$1;
(statearr_52425_52453[(2)] = false);

(statearr_52425_52453[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (1))){
var inst_52391 = burningswell.web.actions.spots_params.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([params], 0));
var inst_52392 = burningswell.web.api.spots.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.array_seq([inst_52391], 0));
var state_52423__$1 = state_52423;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52423__$1,(2),inst_52392);
} else {
if((state_val_52424 === (4))){
var state_52423__$1 = state_52423;
var statearr_52426_52454 = state_52423__$1;
(statearr_52426_52454[(2)] = false);

(statearr_52426_52454[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (13))){
var inst_52416 = (state_52423[(7)]);
var inst_52417 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spots_SLASH_list,cljs.core.array_seq([inst_52416], 0));
var state_52423__$1 = state_52423;
var statearr_52427_52455 = state_52423__$1;
(statearr_52427_52455[(2)] = inst_52417);

(statearr_52427_52455[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (6))){
var state_52423__$1 = state_52423;
var statearr_52428_52456 = state_52423__$1;
(statearr_52428_52456[(2)] = true);

(statearr_52428_52456[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (3))){
var inst_52394 = (state_52423[(8)]);
var inst_52399 = inst_52394.cljs$lang$protocol_mask$partition0$;
var inst_52400 = (inst_52399 & (64));
var inst_52401 = inst_52394.cljs$core$ISeq$;
var inst_52402 = (inst_52400) || (inst_52401);
var state_52423__$1 = state_52423;
if(cljs.core.truth_(inst_52402)){
var statearr_52429_52457 = state_52423__$1;
(statearr_52429_52457[(1)] = (6));

} else {
var statearr_52430_52458 = state_52423__$1;
(statearr_52430_52458[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (12))){
var inst_52420 = (state_52423[(2)]);
var inst_52421 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$page_SLASH_loading,cljs.core.array_seq([false], 0));
var state_52423__$1 = (function (){var statearr_52431 = state_52423;
(statearr_52431[(9)] = inst_52420);

return statearr_52431;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52423__$1,inst_52421);
} else {
if((state_val_52424 === (2))){
var inst_52394 = (state_52423[(8)]);
var inst_52394__$1 = (state_52423[(2)]);
var inst_52396 = (inst_52394__$1 == null);
var inst_52397 = cljs.core.not(inst_52396);
var state_52423__$1 = (function (){var statearr_52432 = state_52423;
(statearr_52432[(8)] = inst_52394__$1);

return statearr_52432;
})();
if(inst_52397){
var statearr_52433_52459 = state_52423__$1;
(statearr_52433_52459[(1)] = (3));

} else {
var statearr_52434_52460 = state_52423__$1;
(statearr_52434_52460[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (11))){
var inst_52414 = (state_52423[(2)]);
var inst_52415 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52414,cljs.core.cst$kw$status);
var inst_52416 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52414,cljs.core.cst$kw$body);
var state_52423__$1 = (function (){var statearr_52435 = state_52423;
(statearr_52435[(7)] = inst_52416);

return statearr_52435;
})();
var G__52436_52461 = inst_52415;
switch (G__52436_52461) {
case (200):
var statearr_52437_52463 = state_52423__$1;
(statearr_52437_52463[(1)] = (13));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_52415)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (9))){
var inst_52394 = (state_52423[(8)]);
var inst_52411 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52394);
var state_52423__$1 = state_52423;
var statearr_52438_52464 = state_52423__$1;
(statearr_52438_52464[(2)] = inst_52411);

(statearr_52438_52464[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (5))){
var inst_52409 = (state_52423[(2)]);
var state_52423__$1 = state_52423;
if(cljs.core.truth_(inst_52409)){
var statearr_52439_52465 = state_52423__$1;
(statearr_52439_52465[(1)] = (9));

} else {
var statearr_52440_52466 = state_52423__$1;
(statearr_52440_52466[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (10))){
var inst_52394 = (state_52423[(8)]);
var state_52423__$1 = state_52423;
var statearr_52441_52467 = state_52423__$1;
(statearr_52441_52467[(2)] = inst_52394);

(statearr_52441_52467[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52424 === (8))){
var inst_52406 = (state_52423[(2)]);
var state_52423__$1 = state_52423;
var statearr_52442_52468 = state_52423__$1;
(statearr_52442_52468[(2)] = inst_52406);

(statearr_52442_52468[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__52387,params))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__52387,params){
return (function() {
var burningswell$web$actions$state_machine__43983__auto__ = null;
var burningswell$web$actions$state_machine__43983__auto____0 = (function (){
var statearr_52446 = [null,null,null,null,null,null,null,null,null,null];
(statearr_52446[(0)] = burningswell$web$actions$state_machine__43983__auto__);

(statearr_52446[(1)] = (1));

return statearr_52446;
});
var burningswell$web$actions$state_machine__43983__auto____1 = (function (state_52423){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52423);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52447){if((e52447 instanceof Object)){
var ex__43986__auto__ = e52447;
var statearr_52448_52469 = state_52423;
(statearr_52448_52469[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52423);

return cljs.core.cst$kw$recur;
} else {
throw e52447;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52470 = state_52423;
state_52423 = G__52470;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$state_machine__43983__auto__ = function(state_52423){
switch(arguments.length){
case 0:
return burningswell$web$actions$state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$state_machine__43983__auto____1.call(this,state_52423);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$state_machine__43983__auto____0;
burningswell$web$actions$state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$state_machine__43983__auto____1;
return burningswell$web$actions$state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__52387,params))
})();
var state__44282__auto__ = (function (){var statearr_52449 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52449[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52449;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__52387,params))
);

return c__44280__auto__;
});

burningswell.web.actions.spots.cljs$lang$maxFixedArity = (1);

burningswell.web.actions.spots.cljs$lang$applyTo = (function (seq52384){
var G__52385 = cljs.core.first(seq52384);
var seq52384__$1 = cljs.core.next(seq52384);
return burningswell.web.actions.spots.cljs$core$IFn$_invoke$arity$variadic(G__52385,seq52384__$1);
});

/**
 * Like a spot photo.
 */
burningswell.web.actions.like_spot_photo = (function burningswell$web$actions$like_spot_photo(system,p__52471){
var vec__52539 = p__52471;
var spot = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52539,(0),null);
var photo = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52539,(1),null);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__52539,spot,photo){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__52539,spot,photo){
return (function (state_52578){
var state_val_52579 = (state_52578[(1)]);
if((state_val_52579 === (7))){
var state_52578__$1 = state_52578;
var statearr_52580_52606 = state_52578__$1;
(statearr_52580_52606[(2)] = false);

(statearr_52580_52606[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (1))){
var inst_52543 = burningswell.web.api.like_photo(system,photo);
var state_52578__$1 = state_52578;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52578__$1,(2),inst_52543);
} else {
if((state_val_52579 === (4))){
var state_52578__$1 = state_52578;
var statearr_52581_52607 = state_52578__$1;
(statearr_52581_52607[(2)] = false);

(statearr_52581_52607[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (13))){
var inst_52567 = (state_52578[(7)]);
var inst_52568 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52569 = [spot,inst_52567];
var inst_52570 = (new cljs.core.PersistentVector(null,2,(5),inst_52568,inst_52569,null));
var inst_52571 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_like_DASH_photo,cljs.core.array_seq([inst_52570], 0));
var state_52578__$1 = state_52578;
var statearr_52582_52608 = state_52578__$1;
(statearr_52582_52608[(2)] = inst_52571);

(statearr_52582_52608[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (6))){
var state_52578__$1 = state_52578;
var statearr_52583_52609 = state_52578__$1;
(statearr_52583_52609[(2)] = true);

(statearr_52583_52609[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (3))){
var inst_52545 = (state_52578[(8)]);
var inst_52550 = inst_52545.cljs$lang$protocol_mask$partition0$;
var inst_52551 = (inst_52550 & (64));
var inst_52552 = inst_52545.cljs$core$ISeq$;
var inst_52553 = (inst_52551) || (inst_52552);
var state_52578__$1 = state_52578;
if(cljs.core.truth_(inst_52553)){
var statearr_52584_52610 = state_52578__$1;
(statearr_52584_52610[(1)] = (6));

} else {
var statearr_52585_52611 = state_52578__$1;
(statearr_52585_52611[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (12))){
var inst_52576 = (state_52578[(2)]);
var state_52578__$1 = state_52578;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52578__$1,inst_52576);
} else {
if((state_val_52579 === (2))){
var inst_52545 = (state_52578[(8)]);
var inst_52545__$1 = (state_52578[(2)]);
var inst_52547 = (inst_52545__$1 == null);
var inst_52548 = cljs.core.not(inst_52547);
var state_52578__$1 = (function (){var statearr_52586 = state_52578;
(statearr_52586[(8)] = inst_52545__$1);

return statearr_52586;
})();
if(inst_52548){
var statearr_52587_52612 = state_52578__$1;
(statearr_52587_52612[(1)] = (3));

} else {
var statearr_52588_52613 = state_52578__$1;
(statearr_52588_52613[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (11))){
var inst_52565 = (state_52578[(2)]);
var inst_52566 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52565,cljs.core.cst$kw$status);
var inst_52567 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52565,cljs.core.cst$kw$body);
var state_52578__$1 = (function (){var statearr_52589 = state_52578;
(statearr_52589[(7)] = inst_52567);

return statearr_52589;
})();
var G__52590_52614 = inst_52566;
switch (G__52590_52614) {
case (200):
var statearr_52591_52616 = state_52578__$1;
(statearr_52591_52616[(1)] = (13));


break;
case (401):
var statearr_52592_52617 = state_52578__$1;
(statearr_52592_52617[(1)] = (14));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_52566)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (9))){
var inst_52545 = (state_52578[(8)]);
var inst_52562 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52545);
var state_52578__$1 = state_52578;
var statearr_52593_52618 = state_52578__$1;
(statearr_52593_52618[(2)] = inst_52562);

(statearr_52593_52618[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (5))){
var inst_52560 = (state_52578[(2)]);
var state_52578__$1 = state_52578;
if(cljs.core.truth_(inst_52560)){
var statearr_52594_52619 = state_52578__$1;
(statearr_52594_52619[(1)] = (9));

} else {
var statearr_52595_52620 = state_52578__$1;
(statearr_52595_52620[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (14))){
var inst_52573 = burningswell.web.actions.navigate(system,"/signin");
var state_52578__$1 = state_52578;
var statearr_52596_52621 = state_52578__$1;
(statearr_52596_52621[(2)] = inst_52573);

(statearr_52596_52621[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (10))){
var inst_52545 = (state_52578[(8)]);
var state_52578__$1 = state_52578;
var statearr_52597_52622 = state_52578__$1;
(statearr_52597_52622[(2)] = inst_52545);

(statearr_52597_52622[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52579 === (8))){
var inst_52557 = (state_52578[(2)]);
var state_52578__$1 = state_52578;
var statearr_52598_52623 = state_52578__$1;
(statearr_52598_52623[(2)] = inst_52557);

(statearr_52598_52623[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__52539,spot,photo))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__52539,spot,photo){
return (function() {
var burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto____0 = (function (){
var statearr_52602 = [null,null,null,null,null,null,null,null,null];
(statearr_52602[(0)] = burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto__);

(statearr_52602[(1)] = (1));

return statearr_52602;
});
var burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto____1 = (function (state_52578){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52578);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52603){if((e52603 instanceof Object)){
var ex__43986__auto__ = e52603;
var statearr_52604_52624 = state_52578;
(statearr_52604_52624[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52578);

return cljs.core.cst$kw$recur;
} else {
throw e52603;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52625 = state_52578;
state_52578 = G__52625;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto__ = function(state_52578){
switch(arguments.length){
case 0:
return burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto____1.call(this,state_52578);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto____0;
burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto____1;
return burningswell$web$actions$like_spot_photo_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__52539,spot,photo))
})();
var state__44282__auto__ = (function (){var statearr_52605 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52605[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52605;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__52539,spot,photo))
);

return c__44280__auto__;
});
/**
 * Dislike a spot photo.
 */
burningswell.web.actions.dislike_spot_photo = (function burningswell$web$actions$dislike_spot_photo(system,p__52626){
var vec__52694 = p__52626;
var spot = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52694,(0),null);
var photo = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52694,(1),null);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,vec__52694,spot,photo){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,vec__52694,spot,photo){
return (function (state_52733){
var state_val_52734 = (state_52733[(1)]);
if((state_val_52734 === (7))){
var state_52733__$1 = state_52733;
var statearr_52735_52761 = state_52733__$1;
(statearr_52735_52761[(2)] = false);

(statearr_52735_52761[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (1))){
var inst_52698 = burningswell.web.api.dislike_photo(system,photo);
var state_52733__$1 = state_52733;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52733__$1,(2),inst_52698);
} else {
if((state_val_52734 === (4))){
var state_52733__$1 = state_52733;
var statearr_52736_52762 = state_52733__$1;
(statearr_52736_52762[(2)] = false);

(statearr_52736_52762[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (13))){
var inst_52722 = (state_52733[(7)]);
var inst_52723 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52724 = [spot,inst_52722];
var inst_52725 = (new cljs.core.PersistentVector(null,2,(5),inst_52723,inst_52724,null));
var inst_52726 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_dislike_DASH_photo,cljs.core.array_seq([inst_52725], 0));
var state_52733__$1 = state_52733;
var statearr_52737_52763 = state_52733__$1;
(statearr_52737_52763[(2)] = inst_52726);

(statearr_52737_52763[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (6))){
var state_52733__$1 = state_52733;
var statearr_52738_52764 = state_52733__$1;
(statearr_52738_52764[(2)] = true);

(statearr_52738_52764[(1)] = (8));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (3))){
var inst_52700 = (state_52733[(8)]);
var inst_52705 = inst_52700.cljs$lang$protocol_mask$partition0$;
var inst_52706 = (inst_52705 & (64));
var inst_52707 = inst_52700.cljs$core$ISeq$;
var inst_52708 = (inst_52706) || (inst_52707);
var state_52733__$1 = state_52733;
if(cljs.core.truth_(inst_52708)){
var statearr_52739_52765 = state_52733__$1;
(statearr_52739_52765[(1)] = (6));

} else {
var statearr_52740_52766 = state_52733__$1;
(statearr_52740_52766[(1)] = (7));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (12))){
var inst_52731 = (state_52733[(2)]);
var state_52733__$1 = state_52733;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52733__$1,inst_52731);
} else {
if((state_val_52734 === (2))){
var inst_52700 = (state_52733[(8)]);
var inst_52700__$1 = (state_52733[(2)]);
var inst_52702 = (inst_52700__$1 == null);
var inst_52703 = cljs.core.not(inst_52702);
var state_52733__$1 = (function (){var statearr_52741 = state_52733;
(statearr_52741[(8)] = inst_52700__$1);

return statearr_52741;
})();
if(inst_52703){
var statearr_52742_52767 = state_52733__$1;
(statearr_52742_52767[(1)] = (3));

} else {
var statearr_52743_52768 = state_52733__$1;
(statearr_52743_52768[(1)] = (4));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (11))){
var inst_52720 = (state_52733[(2)]);
var inst_52721 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52720,cljs.core.cst$kw$status);
var inst_52722 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_52720,cljs.core.cst$kw$body);
var state_52733__$1 = (function (){var statearr_52744 = state_52733;
(statearr_52744[(7)] = inst_52722);

return statearr_52744;
})();
var G__52745_52769 = inst_52721;
switch (G__52745_52769) {
case (200):
var statearr_52746_52771 = state_52733__$1;
(statearr_52746_52771[(1)] = (13));


break;
case (401):
var statearr_52747_52772 = state_52733__$1;
(statearr_52747_52772[(1)] = (14));


break;
default:
throw (new Error([cljs.core.str("No matching clause: "),cljs.core.str(inst_52721)].join('')));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (9))){
var inst_52700 = (state_52733[(8)]);
var inst_52717 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,inst_52700);
var state_52733__$1 = state_52733;
var statearr_52748_52773 = state_52733__$1;
(statearr_52748_52773[(2)] = inst_52717);

(statearr_52748_52773[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (5))){
var inst_52715 = (state_52733[(2)]);
var state_52733__$1 = state_52733;
if(cljs.core.truth_(inst_52715)){
var statearr_52749_52774 = state_52733__$1;
(statearr_52749_52774[(1)] = (9));

} else {
var statearr_52750_52775 = state_52733__$1;
(statearr_52750_52775[(1)] = (10));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (14))){
var inst_52728 = burningswell.web.actions.navigate_BANG_(system,"/signin");
var state_52733__$1 = state_52733;
var statearr_52751_52776 = state_52733__$1;
(statearr_52751_52776[(2)] = inst_52728);

(statearr_52751_52776[(1)] = (12));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (10))){
var inst_52700 = (state_52733[(8)]);
var state_52733__$1 = state_52733;
var statearr_52752_52777 = state_52733__$1;
(statearr_52752_52777[(2)] = inst_52700);

(statearr_52752_52777[(1)] = (11));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52734 === (8))){
var inst_52712 = (state_52733[(2)]);
var state_52733__$1 = state_52733;
var statearr_52753_52778 = state_52733__$1;
(statearr_52753_52778[(2)] = inst_52712);

(statearr_52753_52778[(1)] = (5));


return cljs.core.cst$kw$recur;
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});})(c__44280__auto__,vec__52694,spot,photo))
;
return ((function (switch__43982__auto__,c__44280__auto__,vec__52694,spot,photo){
return (function() {
var burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto____0 = (function (){
var statearr_52757 = [null,null,null,null,null,null,null,null,null];
(statearr_52757[(0)] = burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto__);

(statearr_52757[(1)] = (1));

return statearr_52757;
});
var burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto____1 = (function (state_52733){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52733);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52758){if((e52758 instanceof Object)){
var ex__43986__auto__ = e52758;
var statearr_52759_52779 = state_52733;
(statearr_52759_52779[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52733);

return cljs.core.cst$kw$recur;
} else {
throw e52758;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52780 = state_52733;
state_52733 = G__52780;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto__ = function(state_52733){
switch(arguments.length){
case 0:
return burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto____1.call(this,state_52733);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto____0;
burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto____1;
return burningswell$web$actions$dislike_spot_photo_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,vec__52694,spot,photo))
})();
var state__44282__auto__ = (function (){var statearr_52760 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52760[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52760;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,vec__52694,spot,photo))
);

return c__44280__auto__;
});
/**
 * Open the session dialog.
 */
burningswell.web.actions.open_session_dialog = (function burningswell$web$actions$open_session_dialog(system,spot){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_52859){
var state_val_52860 = (state_52859[(1)]);
if((state_val_52860 === (1))){
var inst_52837 = (state_52859[(7)]);
var inst_52828 = [cljs.core.cst$kw$start,cljs.core.cst$kw$end];
var inst_52830 = (new goog.date.DateTime());
var inst_52831 = (new goog.date.Interval((0),(0),(-7)));
var inst_52832 = inst_52830.add(inst_52831);
var inst_52833 = inst_52830.toXmlDateTime();
var inst_52834 = (new goog.date.DateTime());
var inst_52835 = inst_52834.toXmlDateTime();
var inst_52836 = [inst_52833,inst_52835];
var inst_52837__$1 = cljs.core.PersistentHashMap.fromArrays(inst_52828,inst_52836);
var inst_52838 = burningswell.web.api.spot_weather.cljs$core$IFn$_invoke$arity$variadic(system,spot,cljs.core.array_seq([inst_52837__$1], 0));
var state_52859__$1 = (function (){var statearr_52861 = state_52859;
(statearr_52861[(8)] = inst_52832);

(statearr_52861[(7)] = inst_52837__$1);

return statearr_52861;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52859__$1,(2),inst_52838);
} else {
if((state_val_52860 === (2))){
var inst_52837 = (state_52859[(7)]);
var inst_52840 = (state_52859[(2)]);
var inst_52841 = burningswell.web.api.wave_heights_chart.cljs$core$IFn$_invoke$arity$variadic(system,spot,cljs.core.array_seq([inst_52837], 0));
var state_52859__$1 = (function (){var statearr_52862 = state_52859;
(statearr_52862[(9)] = inst_52840);

return statearr_52862;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52859__$1,(3),inst_52841);
} else {
if((state_val_52860 === (3))){
var inst_52843 = (state_52859[(10)]);
var inst_52840 = (state_52859[(9)]);
var inst_52843__$1 = (state_52859[(2)]);
var inst_52844 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_52840);
var inst_52845 = cljs.core.cst$kw$status.cljs$core$IFn$_invoke$arity$1(inst_52843__$1);
var inst_52846 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$variadic((200),inst_52844,cljs.core.array_seq([inst_52845], 0));
var state_52859__$1 = (function (){var statearr_52863 = state_52859;
(statearr_52863[(10)] = inst_52843__$1);

return statearr_52863;
})();
if(inst_52846){
var statearr_52864_52875 = state_52859__$1;
(statearr_52864_52875[(1)] = (4));

} else {
var statearr_52865_52876 = state_52859__$1;
(statearr_52865_52876[(1)] = (5));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_52860 === (4))){
var inst_52843 = (state_52859[(10)]);
var inst_52840 = (state_52859[(9)]);
var inst_52848 = [cljs.core.cst$kw$spot,cljs.core.cst$kw$weather,cljs.core.cst$kw$wave_DASH_heights];
var inst_52849 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_52840);
var inst_52850 = cljs.core.cst$kw$body.cljs$core$IFn$_invoke$arity$1(inst_52843);
var inst_52851 = [spot,inst_52849,inst_52850];
var inst_52852 = cljs.core.PersistentHashMap.fromArrays(inst_52848,inst_52851);
var inst_52853 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$session_SLASH_open_DASH_dialog,cljs.core.array_seq([inst_52852], 0));
var state_52859__$1 = state_52859;
var statearr_52866_52877 = state_52859__$1;
(statearr_52866_52877[(2)] = inst_52853);

(statearr_52866_52877[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52860 === (5))){
var inst_52855 = cljs.core.println.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq(["Can't fetch data for session dialog!"], 0));
var state_52859__$1 = state_52859;
var statearr_52867_52878 = state_52859__$1;
(statearr_52867_52878[(2)] = inst_52855);

(statearr_52867_52878[(1)] = (6));


return cljs.core.cst$kw$recur;
} else {
if((state_val_52860 === (6))){
var inst_52857 = (state_52859[(2)]);
var state_52859__$1 = state_52859;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52859__$1,inst_52857);
} else {
return null;
}
}
}
}
}
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto____0 = (function (){
var statearr_52871 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_52871[(0)] = burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto__);

(statearr_52871[(1)] = (1));

return statearr_52871;
});
var burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto____1 = (function (state_52859){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52859);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52872){if((e52872 instanceof Object)){
var ex__43986__auto__ = e52872;
var statearr_52873_52879 = state_52859;
(statearr_52873_52879[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52859);

return cljs.core.cst$kw$recur;
} else {
throw e52872;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52880 = state_52859;
state_52859 = G__52880;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto__ = function(state_52859){
switch(arguments.length){
case 0:
return burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto____1.call(this,state_52859);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto____0;
burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto____1;
return burningswell$web$actions$open_session_dialog_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_52874 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52874[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52874;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Close the session dialog.
 */
burningswell.web.actions.close_session_dialog = (function burningswell$web$actions$close_session_dialog(system,spot){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_52900){
var state_val_52901 = (state_52900[(1)]);
if((state_val_52901 === (1))){
var inst_52895 = [cljs.core.cst$kw$spot];
var inst_52896 = [spot];
var inst_52897 = cljs.core.PersistentHashMap.fromArrays(inst_52895,inst_52896);
var inst_52898 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$session_SLASH_close_DASH_dialog,cljs.core.array_seq([inst_52897], 0));
var state_52900__$1 = state_52900;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52900__$1,inst_52898);
} else {
return null;
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto____0 = (function (){
var statearr_52905 = [null,null,null,null,null,null,null];
(statearr_52905[(0)] = burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto__);

(statearr_52905[(1)] = (1));

return statearr_52905;
});
var burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto____1 = (function (state_52900){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52900);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52906){if((e52906 instanceof Object)){
var ex__43986__auto__ = e52906;
var statearr_52907_52909 = state_52900;
(statearr_52907_52909[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52900);

return cljs.core.cst$kw$recur;
} else {
throw e52906;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52910 = state_52900;
state_52900 = G__52910;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto__ = function(state_52900){
switch(arguments.length){
case 0:
return burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto____1.call(this,state_52900);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto____0;
burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto____1;
return burningswell$web$actions$close_session_dialog_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_52908 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52908[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52908;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Submit a surf session.
 */
burningswell.web.actions.submit_session = (function burningswell$web$actions$submit_session(system,p__52911){
var map__52914 = p__52911;
var map__52914__$1 = ((((!((map__52914 == null)))?((((map__52914.cljs$lang$protocol_mask$partition0$ & (64))) || (map__52914.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52914):map__52914);
var spot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52914__$1,cljs.core.cst$kw$spot);
var session = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52914__$1,cljs.core.cst$kw$session);
return null;
});
/**
 * Load the weather forecast for `spot`.
 */
burningswell.web.actions.load_weather = (function burningswell$web$actions$load_weather(system,spot){
return null;
});
/**
 * Change the weather summary `time` for `spot`.
 */
burningswell.web.actions.display_weather_at_time = (function burningswell$web$actions$display_weather_at_time(system,p__52916){
var map__52930 = p__52916;
var map__52930__$1 = ((((!((map__52930 == null)))?((((map__52930.cljs$lang$protocol_mask$partition0$ & (64))) || (map__52930.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__52930):map__52930);
var msg = map__52930__$1;
var spot = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52930__$1,cljs.core.cst$kw$spot);
var time = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__52930__$1,cljs.core.cst$kw$time);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,map__52930,map__52930__$1,msg,spot,time){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,map__52930,map__52930__$1,msg,spot,time){
return (function (state_52934){
var state_val_52935 = (state_52934[(1)]);
if((state_val_52935 === (1))){
var inst_52932 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_weather_DASH_time,cljs.core.array_seq([msg], 0));
var state_52934__$1 = state_52934;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52934__$1,inst_52932);
} else {
return null;
}
});})(c__44280__auto__,map__52930,map__52930__$1,msg,spot,time))
;
return ((function (switch__43982__auto__,c__44280__auto__,map__52930,map__52930__$1,msg,spot,time){
return (function() {
var burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto____0 = (function (){
var statearr_52939 = [null,null,null,null,null,null,null];
(statearr_52939[(0)] = burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto__);

(statearr_52939[(1)] = (1));

return statearr_52939;
});
var burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto____1 = (function (state_52934){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52934);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52940){if((e52940 instanceof Object)){
var ex__43986__auto__ = e52940;
var statearr_52941_52943 = state_52934;
(statearr_52941_52943[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52934);

return cljs.core.cst$kw$recur;
} else {
throw e52940;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52944 = state_52934;
state_52934 = G__52944;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto__ = function(state_52934){
switch(arguments.length){
case 0:
return burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto____1.call(this,state_52934);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto____0;
burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto____1;
return burningswell$web$actions$display_weather_at_time_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,map__52930,map__52930__$1,msg,spot,time))
})();
var state__44282__auto__ = (function (){var statearr_52942 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52942[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52942;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,map__52930,map__52930__$1,msg,spot,time))
);

return c__44280__auto__;
});
/**
 * Change the create session dialog `time` for `spot`.
 */
burningswell.web.actions.change_session_time = (function burningswell$web$actions$change_session_time(system,time){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_52958){
var state_val_52959 = (state_52958[(1)]);
if((state_val_52959 === (1))){
var inst_52956 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$session_SLASH_change_DASH_time,cljs.core.array_seq([time], 0));
var state_52958__$1 = state_52958;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52958__$1,inst_52956);
} else {
return null;
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$change_session_time_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$change_session_time_$_state_machine__43983__auto____0 = (function (){
var statearr_52963 = [null,null,null,null,null,null,null];
(statearr_52963[(0)] = burningswell$web$actions$change_session_time_$_state_machine__43983__auto__);

(statearr_52963[(1)] = (1));

return statearr_52963;
});
var burningswell$web$actions$change_session_time_$_state_machine__43983__auto____1 = (function (state_52958){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52958);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52964){if((e52964 instanceof Object)){
var ex__43986__auto__ = e52964;
var statearr_52965_52967 = state_52958;
(statearr_52965_52967[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52958);

return cljs.core.cst$kw$recur;
} else {
throw e52964;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52968 = state_52958;
state_52958 = G__52968;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$change_session_time_$_state_machine__43983__auto__ = function(state_52958){
switch(arguments.length){
case 0:
return burningswell$web$actions$change_session_time_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$change_session_time_$_state_machine__43983__auto____1.call(this,state_52958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$change_session_time_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$change_session_time_$_state_machine__43983__auto____0;
burningswell$web$actions$change_session_time_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$change_session_time_$_state_machine__43983__auto____1;
return burningswell$web$actions$change_session_time_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_52966 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52966[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52966;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
/**
 * Change the create session dialog `time` for `spot`.
 */
burningswell.web.actions.change_session_rating = (function burningswell$web$actions$change_session_rating(system,rating){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_52982){
var state_val_52983 = (state_52982[(1)]);
if((state_val_52983 === (1))){
var inst_52980 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$session_SLASH_change_DASH_rating,cljs.core.array_seq([rating], 0));
var state_52982__$1 = state_52982;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52982__$1,inst_52980);
} else {
return null;
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$change_session_rating_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$change_session_rating_$_state_machine__43983__auto____0 = (function (){
var statearr_52987 = [null,null,null,null,null,null,null];
(statearr_52987[(0)] = burningswell$web$actions$change_session_rating_$_state_machine__43983__auto__);

(statearr_52987[(1)] = (1));

return statearr_52987;
});
var burningswell$web$actions$change_session_rating_$_state_machine__43983__auto____1 = (function (state_52982){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_52982);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e52988){if((e52988 instanceof Object)){
var ex__43986__auto__ = e52988;
var statearr_52989_52991 = state_52982;
(statearr_52989_52991[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_52982);

return cljs.core.cst$kw$recur;
} else {
throw e52988;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__52992 = state_52982;
state_52982 = G__52992;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$change_session_rating_$_state_machine__43983__auto__ = function(state_52982){
switch(arguments.length){
case 0:
return burningswell$web$actions$change_session_rating_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$change_session_rating_$_state_machine__43983__auto____1.call(this,state_52982);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$change_session_rating_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$change_session_rating_$_state_machine__43983__auto____0;
burningswell$web$actions$change_session_rating_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$change_session_rating_$_state_machine__43983__auto____1;
return burningswell$web$actions$change_session_rating_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_52990 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_52990[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_52990;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
burningswell.web.actions.show_spot_header = (function burningswell$web$actions$show_spot_header(system,p__52993){
var map__53007 = p__52993;
var map__53007__$1 = ((((!((map__53007 == null)))?((((map__53007.cljs$lang$protocol_mask$partition0$ & (64))) || (map__53007.cljs$core$ISeq$))?true:false):false))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__53007):map__53007);
var msg = map__53007__$1;
var type = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__53007__$1,cljs.core.cst$kw$type);
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__,map__53007,map__53007__$1,msg,type){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__,map__53007,map__53007__$1,msg,type){
return (function (state_53011){
var state_val_53012 = (state_53011[(1)]);
if((state_val_53012 === (1))){
var inst_53009 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$spot_SLASH_header,cljs.core.array_seq([msg], 0));
var state_53011__$1 = state_53011;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53011__$1,inst_53009);
} else {
return null;
}
});})(c__44280__auto__,map__53007,map__53007__$1,msg,type))
;
return ((function (switch__43982__auto__,c__44280__auto__,map__53007,map__53007__$1,msg,type){
return (function() {
var burningswell$web$actions$show_spot_header_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$show_spot_header_$_state_machine__43983__auto____0 = (function (){
var statearr_53016 = [null,null,null,null,null,null,null];
(statearr_53016[(0)] = burningswell$web$actions$show_spot_header_$_state_machine__43983__auto__);

(statearr_53016[(1)] = (1));

return statearr_53016;
});
var burningswell$web$actions$show_spot_header_$_state_machine__43983__auto____1 = (function (state_53011){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_53011);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e53017){if((e53017 instanceof Object)){
var ex__43986__auto__ = e53017;
var statearr_53018_53020 = state_53011;
(statearr_53018_53020[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_53011);

return cljs.core.cst$kw$recur;
} else {
throw e53017;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__53021 = state_53011;
state_53011 = G__53021;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$show_spot_header_$_state_machine__43983__auto__ = function(state_53011){
switch(arguments.length){
case 0:
return burningswell$web$actions$show_spot_header_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$show_spot_header_$_state_machine__43983__auto____1.call(this,state_53011);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$show_spot_header_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$show_spot_header_$_state_machine__43983__auto____0;
burningswell$web$actions$show_spot_header_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$show_spot_header_$_state_machine__43983__auto____1;
return burningswell$web$actions$show_spot_header_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__,map__53007,map__53007__$1,msg,type))
})();
var state__44282__auto__ = (function (){var statearr_53019 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_53019[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_53019;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__,map__53007,map__53007__$1,msg,type))
);

return c__44280__auto__;
});
burningswell.web.actions.set_scroller = (function burningswell$web$actions$set_scroller(system,scroller){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_53035){
var state_val_53036 = (state_53035[(1)]);
if((state_val_53036 === (1))){
var inst_53033 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$layout_SLASH_scroller,cljs.core.array_seq([scroller], 0));
var state_53035__$1 = state_53035;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53035__$1,inst_53033);
} else {
return null;
}
});})(c__44280__auto__))
;
return ((function (switch__43982__auto__,c__44280__auto__){
return (function() {
var burningswell$web$actions$set_scroller_$_state_machine__43983__auto__ = null;
var burningswell$web$actions$set_scroller_$_state_machine__43983__auto____0 = (function (){
var statearr_53040 = [null,null,null,null,null,null,null];
(statearr_53040[(0)] = burningswell$web$actions$set_scroller_$_state_machine__43983__auto__);

(statearr_53040[(1)] = (1));

return statearr_53040;
});
var burningswell$web$actions$set_scroller_$_state_machine__43983__auto____1 = (function (state_53035){
while(true){
var ret_value__43984__auto__ = (function (){try{while(true){
var result__43985__auto__ = switch__43982__auto__(state_53035);
if(cljs.core.keyword_identical_QMARK_(result__43985__auto__,cljs.core.cst$kw$recur)){
continue;
} else {
return result__43985__auto__;
}
break;
}
}catch (e53041){if((e53041 instanceof Object)){
var ex__43986__auto__ = e53041;
var statearr_53042_53044 = state_53035;
(statearr_53042_53044[(5)] = ex__43986__auto__);


cljs.core.async.impl.ioc_helpers.process_exception(state_53035);

return cljs.core.cst$kw$recur;
} else {
throw e53041;

}
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__43984__auto__,cljs.core.cst$kw$recur)){
var G__53045 = state_53035;
state_53035 = G__53045;
continue;
} else {
return ret_value__43984__auto__;
}
break;
}
});
burningswell$web$actions$set_scroller_$_state_machine__43983__auto__ = function(state_53035){
switch(arguments.length){
case 0:
return burningswell$web$actions$set_scroller_$_state_machine__43983__auto____0.call(this);
case 1:
return burningswell$web$actions$set_scroller_$_state_machine__43983__auto____1.call(this,state_53035);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
burningswell$web$actions$set_scroller_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$0 = burningswell$web$actions$set_scroller_$_state_machine__43983__auto____0;
burningswell$web$actions$set_scroller_$_state_machine__43983__auto__.cljs$core$IFn$_invoke$arity$1 = burningswell$web$actions$set_scroller_$_state_machine__43983__auto____1;
return burningswell$web$actions$set_scroller_$_state_machine__43983__auto__;
})()
;})(switch__43982__auto__,c__44280__auto__))
})();
var state__44282__auto__ = (function (){var statearr_53043 = (f__44281__auto__.cljs$core$IFn$_invoke$arity$0 ? f__44281__auto__.cljs$core$IFn$_invoke$arity$0() : f__44281__auto__.call(null));
(statearr_53043[cljs.core.async.impl.ioc_helpers.USER_START_IDX] = c__44280__auto__);

return statearr_53043;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__44282__auto__);
});})(c__44280__auto__))
);

return c__44280__auto__;
});
burningswell.web.actions.start = (function burningswell$web$actions$start(system){
var c__44280__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (c__44280__auto__){
return (function (){
var f__44281__auto__ = (function (){var switch__43982__auto__ = ((function (c__44280__auto__){
return (function (state_53099){
var state_val_53100 = (state_53099[(1)]);
if((state_val_53100 === (1))){
var inst_53083 = (state_53099[(7)]);
var inst_53082 = cljs.core.cst$kw$local_DASH_storage.cljs$core$IFn$_invoke$arity$1(system);
var inst_53083__$1 = cljs.core.cst$kw$user.cljs$core$IFn$_invoke$arity$1(inst_53082);
var state_53099__$1 = (function (){var statearr_53101 = state_53099;
(statearr_53101[(7)] = inst_53083__$1);

return statearr_53101;
})();
if(cljs.core.truth_(inst_53083__$1)){
var statearr_53102_53118 = state_53099__$1;
(statearr_53102_53118[(1)] = (2));

} else {
var statearr_53103_53119 = state_53099__$1;
(statearr_53103_53119[(1)] = (3));

}

return cljs.core.cst$kw$recur;
} else {
if((state_val_53100 === (2))){
var inst_53083 = (state_53099[(7)]);
var inst_53085 = burningswell.web.actions.dispatch_BANG_.cljs$core$IFn$_invoke$arity$variadic(system,cljs.core.cst$kw$user_SLASH_local_DASH_storage,cljs.core.array_seq([inst_53083], 0));
var state_53099__$1 = state_53099;
var statearr_53104_53120 = state_53099__$1;
(statearr_53104_53120[(2)] = inst_53085);

