(ns burningswell.web.components.spot-address
  (:require [burningswell.api.client :as api]
            [burningswell.web.core :as core]
            [goog.format :as format]
            [hal.core :as hal]
            [om.core :as om :include-macros true]
            [om-tools.core :refer-macros [defcomponent]]
            [sablono.core :as html :refer-macros [html]]))

(defcomponent spot-address
  [spot owner opts]
  (render [_]
    (let [system (om/get-shared owner)
          country (hal/embedded spot :country)
          region (hal/embedded spot :region)]
      (html
       [:div {:class (:class opts)}
        [:iron-icon {:icon "maps:place"}]
        (if region
          [:span.spot-address__region
           (core/link-to system (api/path-for :region region) (:name region))])
        (if (and region country) ", ")
        (if country
          [:span.spot-address__country
           (core/link-to system (api/path-for :country country) (:name country))])
        (if-let [distance (:distance spot)]
          [:span.spot-item__distance
           (str ", " (format/numericValueToString distance (if (>= distance 100) 0 1))
                " km away")])]))))
