(ns burningswell.web.components.paper-button
  (:require [om.core :as om]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :refer-macros [defhtml html]]))

(defcomponentk paper-button
  [data owner opts state]
  (init-state [_]
    (assoc opts :ref "paper-button"))
  (did-mount [_]
    (let [node (om/get-node owner "paper-button")]
      (doseq [attr [:raised :noink] :when (attr opts)]
        (.setAttribute node (name attr) "1"))))
  (render [_]
    (html [:paper-button @state data])))
