(ns burningswell.web.stores.spots
  (:require [burningswell.web.stores.resources :as resources]
            [coolant.core :as coolant]))

(defn update-spot-list [state spots]
  (assoc state :list (map resources/spot-path spots)))

(def store
  "The spots page store."
  (coolant/store
   :spots
   {:list []
    :title "Spots"}
   {:spots/list update-spot-list}))
