(ns burningswell.web.components.country
  (:require [burningswell.api.client :as api]
            [burningswell.web.core :as core]
            [burningswell.web.components.google-maps :as maps]
            [burningswell.web.util :as util]
            [hal.core :as hal]
            [om-tools.core :refer-macros [defcomponentk]]
            [sablono.core :as html :refer-macros [html]]))

(defcomponentk country
  "Return a country component."
  [data owner shared]
  (render [_]
    (html
     [:div.country-item
      [:div.country-item__map
       (maps/->static-map (:name data))]
      [:div.country-item__details
       [:h4.country-item__headline
        (util/country-flag data)
        (core/link-to shared (api/path-for :country data) (:name data))]
       [:h4.country-item__address
        [:iron-icon {:icon "maps:place"}]
        (:name (hal/embedded data :continent))]
       [:div.country-item__summary
        [:span (:spot-count data)] " spots in "
        [:span (:region-count data)] " regions"]]])))
