(ns burningswell.weather.system
  (:require [burningswell.db.connection :refer [new-db]]
            [burningswell.weather.router :refer [new-router]]
            [burningswell.weather.server :refer [new-server]]
            [com.stuartsierra.component :as component]))

(defn new-system
  "Return a new weather system."
  [config]
  (let [{:keys [db router server]} config]
    (component/system-map
     :db (new-db db)
     :router (new-router router)
     :server (new-server server))))
