(ns burningswell.weather.main
  (:require [burningswell.config.core :as config]
            [burningswell.weather.system :refer [new-system]]
            [burningswell.system :as system]
            [com.stuartsierra.component :as component]
            [environ.core :refer [env]])
  (:gen-class))

(defn -main [& args]
  (system/with-system [system (new-system (config/weather env))]
    (system/on-shutdown #(component/stop system))
    (loop []
      (Thread/sleep 10000)
      (recur))))
