(ns burningswell.transit.time
  (:require [cognitect.transit :as transit]
            [time-literals.read-write]
            #?(:cljs [java.time :refer [Period LocalDate LocalDateTime ZonedDateTime OffsetTime Instant OffsetDateTime
                                        ZoneId DayOfWeek LocalTime Month Duration Year YearMonth]]))
  #?(:clj (:import [java.io ByteArrayOutputStream ByteArrayInputStream]
                   [java.time Period LocalDate LocalDateTime ZonedDateTime OffsetTime Instant
                    OffsetDateTime ZoneId DayOfWeek LocalTime Month Duration Year YearMonth])))

(def ^:private classes
  {'date LocalDate
   'date-time LocalDateTime
   'day-of-week DayOfWeek
   'duration Duration
   'instant Instant
   'month Month
   'offset-date-time OffsetDateTime
   'offset-time OffsetTime
   'period Period
   'time LocalTime
   'year Year
   'year-month YearMonth
   'zone ZoneId
   'zoned-date-time ZonedDateTime})

(defn- tag
  "Return the tag for `symbol`."
  [symbol]
  (str "burningswell/" (name symbol)))

(def read-handlers
  "The Transit read handlers."
  (into {} (for [[sym handler] time-literals.read-write/tags]
             [(tag sym) (transit/read-handler handler)])))

(def write-handlers
  "The Transit write handlers."
  (into {} (for [[sym class] classes]
             [class (transit/write-handler (constantly (tag sym)) str)])))
