(defproject burningswell/transit "0.1.4"
  :description "The Burning Swell Transit format library."
  :url "https://github.com/burningswell/transit"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :min-lein-version "2.6.1"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[clj-time "0.15.2"]
                 [com.cognitect/transit-clj "1.0.324"]
                 [com.cognitect/transit-cljs "0.8.264"]
                 [geo-clj "0.6.4"]
                 [net.postgis/postgis-jdbc "2.5.0" :exclusions [postgresql org.postgresql/postgresql]]
                 [org.clojure/clojure "1.10.2"]
                 [org.postgresql/postgresql "42.2.18"]
                 [tick "0.4.29-alpha"]]
  :profiles {:dev {:dependencies [[org.clojure/clojurescript "1.10.773" :scope "provided"]]}}
  :managed-dependencies [[org.clojure/core.rrb-vector "0.1.2"]]
  :plugins [[jonase/eastwood "0.3.13"]
            [lein-cljsbuild "1.1.8"]
            [lein-difftest "2.0.0"]
            [lein-doo "0.1.11"]]
  :aliases
  {"ci" ["do"
         ["clean"]
         ["difftest"]
         ["doo" "node" "node" "once"]
         ["doo" "phantom" "none" "once"]
         ;; ["doo" "phantom" "advanced" "once"]
         ["lint"]]
   "lint" ["do"  ["eastwood"]]}
  :cljsbuild
  {:builds
   [{:id "none"
     :compiler
     {:main burningswell.transit.runner
      :optimizations :none
      :output-dir "target/none"
      :output-to "target/none.js"
      :parallel-build true
      :pretty-print true
      :verbose false}
     :source-paths ["src" "test"]}
    {:id "node"
     :compiler
     {:main burningswell.transit.runner
      :optimizations :none
      :output-dir "target/node"
      :output-to "target/node.js"
      :parallel-build true
      :pretty-print true
      :target :nodejs
      :verbose false}
     :source-paths ["src" "test"]}
    {:id "advanced"
     :compiler
     {:main burningswell.transit.runner
      :optimizations :advanced
      :output-dir "target/advanced"
      :output-to "target/advanced.js"
      :parallel-build true
      :pretty-print true
      :verbose false}
     :source-paths ["src" "test"]}]})
