(ns burningswell.streams.pprint
  (:require [burningswell.streams.core :as k]
            [clojure.pprint :as pprint]
            [peripheral.core :refer [defcomponent]])
  (:import org.apache.kafka.streams.StreamsBuilder))

(defn pprint-topology [env config]
  (k/with-build-stream builder
    (-> (.stream builder (:input config))
        (.mapValues (k/value-mapper [v]
                      (locking *out* (pprint/pprint v))
                      v)))))

(defcomponent PrettyPrint [config]
  :this/as *this*
  :props (k/props config)
  :topology (pprint-topology *this* config)
  :stream (k/start-topology props topology) #(.close %))

(defn pprint [& [config]]
  (map->PrettyPrint
   {:config (merge {:application.id "pprint"} config)}))
