(ns burningswell.streams.json
  (:require [burningswell.json :as json]
            [burningswell.streams.core :as k]
            [peripheral.core :refer [defcomponent]])
  (:import org.apache.kafka.common.serialization.Serdes
           [org.apache.kafka.streams KeyValue StreamsBuilder]
           org.apache.kafka.streams.kstream.Produced))

(defn json-config [& [opts]]
  (merge opts {:application.id "json"
               :topics [["burningswell.api.commands"
                         "burningswell.api.commands.json"]
                        ["burningswell.api.events"
                         "burningswell.api.events.json"]]}))

(defn json-topology [env config]
  (k/with-build-stream builder
    (doseq [[input output] (:topics config)]
      (-> (.stream builder input)
          (.map (k/kv-mapper [k v]
                  (KeyValue.
                   (json/json-str k)
                   (json/json-str v))))
          (.to (or output (str output ".json"))
               (Produced/with (Serdes/String) (Serdes/String)))))))

(defcomponent Json [config]
  :this/as *this*
  :props (k/props config)
  :topology (json-topology *this* (json-config config))
  :stream (k/start-topology props topology) #(.close %))

(defn json [& [config]]
  (map->Json {:config config}))
