(ns burningswell.streams.api.events
  (:require [burningswell.streams.core :as k]
            [burningswell.streams.pprint :as pprint]))

(defn pprint [& [config]]
  (-> {:application.id "pretty-print-events"
       :input "burningswell.api.events"}
      (merge config)
      (pprint/pprint)))

(defn by-name [stream name]
  (k/filter stream (fn [_ event] (= (:name event) name))))
