(ns burningswell.specs.linkedin
  (:require [clojure.spec.alpha :as s]
            [burningswell.specs.core :as core]))

(s/def :linkedin.profile/email-address (s/nilable string?))
(s/def :linkedin.profile/first-name (s/nilable string?))
(s/def :linkedin.profile/id string?)
(s/def :linkedin.profile/last-name (s/nilable string?))
(s/def :linkedin.profile/picture-url (s/nilable ::core/url-str))

(s/def :linkedin/profile
  (s/keys :req-un [:linkedin.profile/id
                   :linkedin.profile/first-name
                   :linkedin.profile/last-name
                   :linkedin.profile/email-address
                   :linkedin.profile/picture-url]))
