(ns burningswell.api.specs.events
  (:require [burningswell.api.specs.commands]
            [burningswell.specs.linkedin]
            [burningswell.api.specs.ns]
            [burningswell.specs.core]
            [clojure.spec.alpha :as s]
            [postgis.spec :as postgis]
            [clojure.spec.gen.alpha :as gen]))

(s/def :burningswell.api.event/command-id uuid?)
(s/def :burningswell.api.event/email-id pos-int?)
(s/def :burningswell.api.event/id uuid?)
(s/def :burningswell.api.event/location ::postgis/point)
(s/def :burningswell.api.event/name qualified-keyword?)
(s/def :burningswell.api.event/session-id uuid?)
(s/def :burningswell.api.event/spot-id pos-int?)
(s/def :burningswell.api.event/url :burningswell.specs.core/url)
(s/def :burningswell.api.event/user-id pos-int?)

(s/def :burningswell.api/event
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/name]))

;; OAuth Callback

(s/def :burningswell.api.events.oauth.callback-failed/name
  #{:burningswell.api.events/signin-failed})

(s/def :burningswell.api.events.oauth.callback-failed/error keyword?)

(s/def :burningswell.api.events.oauth/callback-failed
  (s/keys :req-un [:burningswell.api.events.oauth.callback-failed/name
                   :burningswell.api.events.oauth.callback-failed/error
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id]))

(s/def :burningswell.api.events.oauth.callback-succeeded/name
  #{:burningswell.api.events.oauth/callback-succeeded})

(s/def :burningswell.api.events.oauth.callback-succeeded/profile
  (s/map-of keyword? any?))

(s/def :burningswell.api.events.oauth.callback-succeeded/token
  (s/map-of keyword? any?))

(s/def :burningswell.api.events.oauth.callback-succeeded/provider
  :burningswell.api.commands.oauth.callback/provider)

(s/def :burningswell.api.events.oauth/callback-succeeded
  (s/keys :req-un [:burningswell.api.events.oauth.callback-succeeded/name
                   :burningswell.api.events.oauth.callback-succeeded/profile
                   :burningswell.api.events.oauth.callback-succeeded/provider
                   :burningswell.api.events.oauth.callback-succeeded/token
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))

;; Page Views

(s/def :burningswell.api.events.page-view-created/name
  #{:burningswell.api.events/page-view-created})

(s/def :burningswell.api.events/page-view-created
  (s/keys :req-un [:burningswell.api.events.page-view-created/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/session-id
                   :burningswell.api.event/url]
          :opt-un [:burningswell.api.event/user-id]))

;; Reset Password

(s/def :burningswell.api.events.passwords.reset/name
  #{:burningswell.api.events.passwords/reset})

(s/def :burningswell.api.events.passwords/reset
  (s/keys :req-un [:burningswell.api.events.passwords.reset/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/email-id
                   :burningswell.api.event/id]))

;; Signin

(s/def :burningswell.api.events.signin-failed/name
  #{:burningswell.api.events/signin-failed})

(s/def :burningswell.api.events/signin-failed
  (s/keys :req-un [:burningswell.api.events.signin-failed/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id]))

(s/def :burningswell.api.events.signin-succeeded/name
  #{:burningswell.api.events/signin-succeeded})

(s/def :burningswell.api.events/signin-succeeded
  (s/keys :req-un [:burningswell.api.events.signin-succeeded/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))

;; Signup

(s/def :burningswell.api.events.signup-failed/name
  #{:burningswell.api.events/signup-failed})

(s/def :burningswell.api.events/signup-failed
  (s/keys :req-un [:burningswell.api.events.signup-failed/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id]))

(s/def :burningswell.api.events.signup-succeeded/name
  #{:burningswell.api.events/signup-succeeded})

(s/def :burningswell.api.events/signup-succeeded
  (s/keys :req-un [:burningswell.api.events.signup-succeeded/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))

;; Spots

(s/def :burningswell.api.events.spot-created/name
  #{:burningswell.api.events/spot-created})

(s/def :burningswell.api.events/spot-created
  (s/keys :req-un [:burningswell.api.events.spot-created/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id
                   :burningswell.api.event/spot-id]))


;; User Created

(s/def :burningswell.api.events.user-created/name
  #{:burningswell.api.events/user-created})

(s/def :burningswell.api.events/user-created
  (s/keys :req-un [:burningswell.api.events.user-created/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))
