(ns burningswell.specs.gravatar
  (:require [burningswell.specs.core :as core]
            [clojure.spec.alpha :as s]))

(s/def :gravatar.profile/display-name (s/nilable string?))
(s/def :gravatar.profile/hash string?)
(s/def :gravatar.profile/id string?)
(s/def :gravatar.profile/preferred-username (s/nilable string?))
(s/def :gravatar.profile/profile-url (s/nilable ::core/url-str))
(s/def :gravatar.profile/request-hash string?)
(s/def :gravatar.profile/thumbnail-url (s/nilable ::core/url-str))

(s/def :gravatar.profile.photo/type string?)
(s/def :gravatar.profile.photo/value ::core/url-str)

(s/def :gravatar.profile/photo
  (s/keys :req-un [:gravatar.profile.photo/type
                   :gravatar.profile.photo/value]))

(s/def :gravatar.profile/photos
  (s/coll-of :gravatar.profile/photo :kind vector?))

(s/def :gravatar/profile
  (s/keys :req-un [:gravatar.profile/display-name
                   :gravatar.profile/hash
                   :gravatar.profile/id
                   :gravatar.profile/preferred-username
                   :gravatar.profile/profile-url
                   :gravatar.profile/photos
                   :gravatar.profile/request-hash
                   :gravatar.profile/thumbnail-url]))
