(ns burningswell.specs.twitter
  (:require [burningswell.specs.core :as core]
            [clojure.spec.alpha :as s]))

(s/def :twitter.profile/default-profile-image boolean?)
(s/def :twitter.profile/description (s/nilable string?))
(s/def :twitter.profile/id pos-int?)
(s/def :twitter.profile/lang (s/nilable string?))
(s/def :twitter.profile/name string?)
(s/def :twitter.profile/profile-image-url-http ::core/url-str)
(s/def :twitter.profile/profile-image-url-https ::core/url-str)
(s/def :twitter.profile/screen-name string?)

(s/def :twitter/profile
  (s/keys :req-un [:twitter.profile/default-profile-image
                   :twitter.profile/description
                   :twitter.profile/id
                   :twitter.profile/lang
                   :twitter.profile/name
                   :twitter.profile/profile-image-url-http
                   :twitter.profile/profile-image-url-https
                   :twitter.profile/screen-name]))
