(ns burningswell.api.specs.commands
  (:require [burningswell.api.specs.ns]
            [burningswell.specs.core]
            [clojure.spec.alpha :as s]
            [postgis.spec :as postgis]))

(s/def :burningswell.api.command/id uuid?)
(s/def :burningswell.api.command/name qualified-keyword?)
(s/def :burningswell.api.command/location ::postgis/point)

(s/def :burningswell.api/command
  (s/keys :req-un [:burningswell.api.command/id
                   :burningswell.api.command/name]))

;; Create Spot

(s/def :burningswell.api.commands.create-spot/name
  #{:burningswell.api.commands/create-spot})

(s/def :burningswell.api.commands/create-spot
  (s/keys :req-un [:burningswell.api.commands.create-spot/name
                   :burningswell.api.command/id]))

;; Create Page View

(s/def :burningswell.api.commands.create-page-view/name
  #{:burningswell.api.commands/create-page-view})

(s/def :burningswell.api.commands/create-page-view
  (s/keys :req-un [:burningswell.api.commands.create-page-view/name
                   :burningswell.api.command/id]))

;; OAuth Callback

(s/def :burningswell.api.commands.oauth.callback/name
  #{:burningswell.api.commands.oauth/callback})

(s/def :burningswell.api.commands.oauth.callback/params
  (s/map-of keyword? string?))

(s/def :burningswell.api.commands.oauth.callback/provider
  #{"facebook" "google" "linkedin" "twitter"})

(s/def :burningswell.api.commands.oauth/callback
  (s/keys :req-un [:burningswell.api.commands.oauth.callback/name
                   :burningswell.api.commands.oauth.callback/params
                   :burningswell.api.commands.oauth.callback/provider
                   :burningswell.api.command/id]))

;; Signin

(s/def :burningswell.api.commands.signin/name
  (s/and #{:burningswell.api.commands/signin}))

(s/def :burningswell.api.commands/signin
  (s/keys :req-un [:burningswell.api.commands.signin/name
                   :burningswell.api.command/id]))

;; Signup

(s/def :burningswell.api.commands.signup/name
  (s/and #{:burningswell.api.commands/signup}))

(s/def :burningswell.api.commands/signup
  (s/keys :req-un [:burningswell.api.commands.signup/name
                   :burningswell.api.command/id]))
