(ns burningswell.gen.string
  (:require [clojure.test.check.generators :as gen])
  #?(:clj (:import [java.net URLEncoder])))

(defn url-encode
  [string]
  #?(:clj (some-> string str (URLEncoder/encode "UTF-8") (.replace "+" "%20"))
     :cljs (some-> string str (js/encodeURIComponent) (.replace "+" "%20"))))

(def non-empty-alphanumeric
  "Generator for non-empty alphanumeric strings"
  (gen/such-that #(not= "" %) gen/string-alphanumeric))

(def non-empty-url-encoded
  "Generator for url-encoded strings"
  (gen/fmap url-encode (gen/such-that #(not= "" %) gen/string)))
