(ns burningswell.api.specs.events
  (:require [burningswell.api.specs.commands]
            [burningswell.specs.linkedin]
            [burningswell.api.specs.ns]
            [burningswell.specs.core]
            [clojure.spec.alpha :as s]
            [postgis.spec :as postgis]
            [clojure.spec.gen.alpha :as gen]))

(s/def :burningswell.api.event/command-id uuid?)
(s/def :burningswell.api.event/favourite-id pos-int?)
(s/def :burningswell.api.event/email-id pos-int?)
(s/def :burningswell.api.event/id uuid?)
(s/def :burningswell.api.event/location ::postgis/point)
(s/def :burningswell.api.event/name qualified-keyword?)
(s/def :burningswell.api.event/session-id uuid?)
(s/def :burningswell.api.event/spot-id pos-int?)
(s/def :burningswell.api.event/url :burningswell.specs.core/url)
(s/def :burningswell.api.event/user-id pos-int?)

(s/def :burningswell.api/event
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/name]))

;; Favourites

(s/def :burningswell.api.events.favourite-created/name
  #{:burningswell.api.events/favourite-created})

(s/def :burningswell.api.events/favourite-created
  (s/keys :req-un [:burningswell.api.events.favourite-created/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/favourite-id
                   :burningswell.api.event/user-id]))

(s/def :burningswell.api.events.favourite-deleted/name
  #{:burningswell.api.events/favourite-deleted})

(s/def :burningswell.api.events/favourite-deleted
  (s/keys :req-un [:burningswell.api.events.favourite-deleted/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/favourite-id
                   :burningswell.api.event/user-id]))

;; OAuth Callback

(s/def :burningswell.api.events.oauth.callback-failed/name
  #{:burningswell.api.events/signin-failed})

(s/def :burningswell.api.events.oauth.callback-failed/error keyword?)

(s/def :burningswell.api.events.oauth/callback-failed
  (s/keys :req-un [:burningswell.api.events.oauth.callback-failed/name
                   :burningswell.api.events.oauth.callback-failed/error
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id]))

(s/def :burningswell.api.events.oauth.callback-succeeded/name
  #{:burningswell.api.events.oauth/callback-succeeded})

(s/def :burningswell.api.events.oauth.callback-succeeded/profile
  (s/map-of keyword? any?))

(s/def :burningswell.api.events.oauth.callback-succeeded/token
  (s/map-of keyword? any?))

(s/def :burningswell.api.events.oauth.callback-succeeded/provider
  :burningswell.api.commands.oauth.callback/provider)

(s/def :burningswell.api.events.oauth/callback-succeeded
  (s/keys :req-un [:burningswell.api.events.oauth.callback-succeeded/name
                   :burningswell.api.events.oauth.callback-succeeded/profile
                   :burningswell.api.events.oauth.callback-succeeded/provider
                   :burningswell.api.events.oauth.callback-succeeded/token
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))

;; Page Views

(s/def :burningswell.api.events.page-view-created/name
  #{:burningswell.api.events/page-view-created})

(s/def :burningswell.api.events/page-view-created
  (s/keys :req-un [:burningswell.api.events.page-view-created/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/session-id
                   :burningswell.api.event/url]
          :opt-un [:burningswell.api.event/user-id
                   :burningswell.api.event/location]))

;; Reset Password

(s/def :burningswell.api.events.passwords.reset/name
  #{:burningswell.api.events.passwords/reset})

(s/def :burningswell.api.events.passwords/reset
  (s/keys :req-un [:burningswell.api.events.passwords.reset/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/email-id
                   :burningswell.api.event/id]))

;; Search

(s/def :burningswell.api.events.search-result/id pos-int?)
(s/def :burningswell.api.events.search-result/rank number?)
(s/def :burningswell.api.events.search-result/term string?)
(s/def :burningswell.api.events.search-result/type keyword?)

(s/def :burningswell.api.events/search-result
  (s/keys :req-un [:burningswell.api.events.search-result/id
                   :burningswell.api.events.search-result/rank
                   :burningswell.api.events.search-result/term
                   :burningswell.api.events.search-result/type]))

(s/def :burningswell.api.events.search-results/name
  #{:burningswell.api.events/search-results})

(s/def :burningswell.api.events.search-results/results
  (s/coll-of :burningswell.api.events/search-result :gen-max 5))

(s/def :burningswell.api.events/search-results
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.events.search-results/name
                   :burningswell.api.events.search-results/results]))

;; Signin

(s/def :burningswell.api.events.signin-failed/name
  #{:burningswell.api.events/signin-failed})

(s/def :burningswell.api.events/signin-failed
  (s/keys :req-un [:burningswell.api.events.signin-failed/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id]))

(s/def :burningswell.api.events.signin-succeeded/name
  #{:burningswell.api.events/signin-succeeded})

(s/def :burningswell.api.events/signin-succeeded
  (s/keys :req-un [:burningswell.api.events.signin-succeeded/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))

;; Signup

(s/def :burningswell.api.events.signup-failed/name
  #{:burningswell.api.events/signup-failed})

(s/def :burningswell.api.events/signup-failed
  (s/keys :req-un [:burningswell.api.events.signup-failed/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id]))

(s/def :burningswell.api.events.signup-succeeded/name
  #{:burningswell.api.events/signup-succeeded})

(s/def :burningswell.api.events/signup-succeeded
  (s/keys :req-un [:burningswell.api.events.signup-succeeded/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))

;; Spots

(s/def :burningswell.api.events.spot-created/name
  #{:burningswell.api.events/spot-created})

(s/def :burningswell.api.events/spot-created
  (s/keys :req-un [:burningswell.api.events.spot-created/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id
                   :burningswell.api.event/spot-id]))


;; User Created

(s/def :burningswell.api.events.user-created/name
  #{:burningswell.api.events/user-created})

(s/def :burningswell.api.events/user-created
  (s/keys :req-un [:burningswell.api.events.user-created/name
                   :burningswell.api.event/command-id
                   :burningswell.api.event/id
                   :burningswell.api.event/user-id]))
