(ns burningswell.specs.core
  (:require [burningswell.specs.gen :as gens]
            [clojure.spec.alpha :as s]
            [clojure.spec.gen.alpha :as gen]
            [clojure.string :as str]))

(def ^:private email-regex
  "The regular expression for an email address."
  #"^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,63}$")

(defn max-count [n]
  #(<= (count %) n))

(defn min-count [n]
  #(>= (count %) n))

(defn not-blank? [s]
  (not (str/blank? s)))

(defn text [min max]
  (s/and string? (min-count min) (max-count max)))

;; Continent

(s/def :burningswell.continent/created-at inst?)
(s/def :burningswell.continent/id pos-int?)
(s/def :burningswell.continent/name (text 2 256))
(s/def :burningswell.continent/updated-at inst?)

(s/def :burningswell/continent
  (s/keys :req-un [:burningswell.continent/id]
          :opt-un [:burningswell.continent/name
                   :burningswell.continent/created-at
                   :burningswell.continent/updated-at]))

;; Country

(s/def :burningswell.country/continent :burningswell/continent)
(s/def :burningswell.country/created-at inst?)
(s/def :burningswell.country/id pos-int?)

(s/def :burningswell.country/name
  (s/and string? (min-count 2) (max-count 2)))

(s/def :burningswell.country/updated-at inst?)

(s/def :burningswell.country/iso-3166-1-alpha-2
  (s/with-gen (s/and string? (min-count 2) (max-count 2))
    (constantly gens/iso-3166-1-alpha-2)))

(s/def :burningswell.country/iso-3166-1-alpha-3
  (s/with-gen (s/and string? (min-count 3) (max-count 3))
    (constantly gens/iso-3166-1-alpha-3)))

(s/def :burningswell/country
  (s/keys :req-un [:burningswell.country/id]
          :opt-un [:burningswell.country/continent
                   :burningswell.country/created-at
                   :burningswell.country/iso-3166-1-alpha-2
                   :burningswell.country/iso-3166-1-alpha-3
                   :burningswell.country/name
                   :burningswell.country/updated-at]))

;; Region

(s/def :burningswell.region/country :burningswell/country)
(s/def :burningswell.region/created-at inst?)
(s/def :burningswell.region/id pos-int?)
(s/def :burningswell.region/name (text 2 256))
(s/def :burningswell.region/updated-at inst?)

(s/def :burningswell/region
  (s/keys :req-un [:burningswell.region/id]
          :opt-un [:burningswell.region/country
                   :burningswell.region/created-at
                   :burningswell.region/name
                   :burningswell.region/updated-at]))

;; Spot

(s/def :burningswell.spot/country :burningswell/country)
(s/def :burningswell.spot/created-at inst?)
(s/def :burningswell.spot/id pos-int?)
(s/def :burningswell.spot/name (text 2 256))
(s/def :burningswell.spot/region :burningswell/region)
(s/def :burningswell.spot/updated-at inst?)

(s/def :burningswell/spot
  (s/keys :req-un [:burningswell.spot/id]
          :opt-un [:burningswell.spot/country
                   :burningswell.spot/created-at
                   :burningswell.spot/name
                   :burningswell.spot/region
                   :burningswell.spot/updated-at]))

(comment
  (gen/sample (s/gen :burningswell.country/iso-3166-1-alpha-2))
  (clojure.pprint/pprint
   (gen/sample (s/gen :burningswell/spot)))
  (gen/generate (s/gen :burningswell/country)))
