(ns burningswell.api.specs.events
  (:require [burningswell.api.specs.ns]
            [clojure.spec.alpha :as s]
            [postgis.spec :as postgis]))

;; Names

(s/def :burningswell.api.event.access-token-requested/name #{"access-token-requested"})
(s/def :burningswell.api.event.created/name #{"created"})
(s/def :burningswell.api.event.failed/name #{"failed"})
(s/def :burningswell.api.event.profile-requested/name #{"profile-requested"})
(s/def :burningswell.api.event.succeeded/name #{"succeeded"})
(s/def :burningswell.api.event.user-created/name #{"user-created"})
(s/def :burningswell.api.event.user-updated/name #{"user-updated"})

;; Event

(s/def :burningswell.api.event/command-id uuid?)
(s/def :burningswell.api.event/name string?)
(s/def :burningswell.api.event/ns string?)

(s/def :burningswell.api/event
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.event/ns
                   :burningswell.api.event/name]))

;; OAuth Callback

(s/def :burningswell.api.oauth.callback.events/access-token-requested
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.oauth.callback/ns
                   :burningswell.api.event.access-token-requested/name]))

(s/def :burningswell.api.oauth.callback.events/profile-requested
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.oauth.callback/ns
                   :burningswell.api.event.profile-requested/name]))

(s/def :burningswell.api.oauth.callback.events/user-created
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.oauth.callback/ns
                   :burningswell.api.event.user-created/name]))

(s/def :burningswell.api.oauth.callback.events/user-updated
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.oauth.callback/ns
                   :burningswell.api.event.user-updated/name]))

(s/def :burningswell.api.oauth.callback.events/succeeded
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.oauth.callback/ns
                   :burningswell.api.event.succeeded/name]))

(s/def :burningswell.api.oauth.callback.events/failed
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.oauth.callback/ns
                   :burningswell.api.event.failed/name]))

;; Page Views

(s/def :burningswell.api.page-views.events.user/id pos-int?)

(s/def :burningswell.api.page-views.events/user
  (s/nilable (s/keys :req-un [:burningswell.api.page-views.events.user/id])))

(s/def :burningswell.api.page-views.events.created/location (s/nilable ::postgis/point))

(s/def :burningswell.api.page-views.events/created
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.page-views/ns
                   :burningswell.api.event.created/name
                   :burningswell.api.page-views.events.created/location
                   :burningswell.api.page-views.events/user]))

;; Signin

(s/def :burningswell.api.signin.events.user/id pos-int?)

(s/def :burningswell.api.signin.events/user
  (s/keys :req-un [:burningswell.api.signin.events.user/id]))

(s/def :burningswell.api.signin.events/succeeded
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.signin/ns
                   :burningswell.api.event.succeeded/name
                   :burningswell.api.signin.events/user]))

(s/def :burningswell.api.signin.events/failed
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.signin/ns
                   :burningswell.api.event.failed/name]))

;; Signup

(s/def :burningswell.api.signup.events.user/id pos-int?)

(s/def :burningswell.api.signup.events/user
  (s/keys :req-un [:burningswell.api.signup.events.user/id]))

(s/def :burningswell.api.signup.events/succeeded
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.signup/ns
                   :burningswell.api.event.succeeded/name
                   :burningswell.api.signup.events/user]))

(s/def :burningswell.api.signup.events/failed
  (s/keys :req-un [:burningswell.api.event/command-id
                   :burningswell.api.signup/ns
                   :burningswell.api.event.failed/name]))
