(defproject burningswell/scheduler "0.1.16"
  :description "The Burning Swell scheduler"
  :url "https://github.com/burningswell/scheduler"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :min-lein-version "2.0.0"
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/config "0.1.38"]
                 [burningswell/core "0.0.43"]
                 [burningswell/db "0.0.87"]
                 [burningswell/rabbitmq "0.3.0"]
                 [burningswell/weather "0.1.3"]
                 [ch.qos.logback/logback-classic "1.1.7"]
                 [ch.qos.logback/logback-core "1.1.7"]
                 [clojurewerkz/quartzite "2.0.0"]
                 [listora/again"0.1.0"]
                 [netcdf-clj "0.0.13"
                  :exclusions [com.amazonaws/aws-java-sdk-s3
                               org.slf4j/slf4j-log4j12]]
                 [org.clojure/clojure "1.9.0-alpha10"]]
  :plugins [[lein-environ "1.1.0"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :main ^{:skip-aot true} burningswell.scheduler.main
  :profiles {:dev {:dependencies [[reloaded.repl "0.2.2"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :repl-options {:init-ns user}
                   :source-paths ["dev" "src"]}
             :test {:source-paths ^:replace ["src"]
                    :resource-paths ["test-resources"]}
             :uberjar {:aot :all :main burningswell.scheduler.main}}
  :uberjar-name "burningswell-scheduler.jar")
