(ns burningswell.scheduler.quartz
  (:require [clojure.tools.logging :as log]
            [clojurewerkz.quartzite.scheduler :as scheduler]
            [com.stuartsierra.component :as component]
            [schema.core :as s]))

(s/defrecord Quartz
    [scheduler :- s/Any
     schedule-fn :- s/Any]
  {s/Any s/Any})

(s/defn ^:always-validate start-quartz :- Quartz
  "Start the Quartz scheduler."
  [quartz :- Quartz]
  (if (:scheduler quartz)
    quartz
    (let [scheduler (scheduler/initialize)
          quartz (assoc quartz :scheduler scheduler)]
      (if-let [schedule-fn (:schedule-fn quartz)]
        (schedule-fn quartz))
      (scheduler/start scheduler)
      quartz)))

(s/defn ^:always-validate stop-quartz :- Quartz
  "Stop the Quartz scheduler."
  [quartz :- Quartz]
  (when-let [scheduler (:scheduler quartz)]
    (scheduler/shutdown scheduler))
  (assoc quartz :scheduler nil))

(extend-protocol component/Lifecycle
  Quartz
  (start [quartz]
    (start-quartz quartz))
  (stop [quartz]
    (stop-quartz quartz)))

(s/defn ^:always-validate quartz :- Quartz
  "Make a new Quartz scheduler."
  [config]
  (map->Quartz config))
