(defproject burningswell/pedestal "0.1.7"
  :description "The Burning Swell Pedestal client library"
  :url "https://github.com/burningswell/pedestal"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[com.stuartsierra/component "0.4.0"]
                 [io.pedestal/pedestal.jetty "0.5.5"]
                 [io.pedestal/pedestal.service "0.5.5" :exclusions [org.clojure/core.async]]
                 [org.clojure/clojure "1.10.0"]
                 [org.clojure/core.async "0.4.490"]
                 [org.clojure/tools.logging "0.5.0-alpha.1"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :min-lein-version "2.7.1"
  :profiles {:dev {:dependencies [[ch.qos.logback/logback-core "1.2.3"]
                                  [ch.qos.logback/logback-classic "1.2.3"]
                                  [org.slf4j/log4j-over-slf4j "1.7.26"]
                                  [reloaded.repl "0.2.4"]]
                   :plugins [[jonase/eastwood "0.3.5"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :test {:resource-paths ["test-resources"]}})
