(defproject burningswell/pedestal "0.1.4"
  :description "The Burning Swell Pedestal client library"
  :url "https://github.com/burningswell/pedestal"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[com.stuartsierra/component "0.3.2"]
                 [io.pedestal/pedestal.jetty "0.5.2"]
                 [io.pedestal/pedestal.service "0.5.2"]
                 [org.clojure/clojure "1.8.0"]
                 [org.clojure/tools.logging "0.3.1"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]
            "test-ancient" ["test"]}
  :min-lein-version "2.4.2"
  :profiles {:dev {:dependencies [[ch.qos.logback/logback-core "1.1.9"]
                                  [ch.qos.logback/logback-classic "1.1.9"]
                                  [org.slf4j/log4j-over-slf4j "1.7.22"]
                                  [reloaded.repl "0.2.3"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :test {:resource-paths ["test-resources"]}})
