(defproject burningswell/metrics "0.1.5"
  :description "The Burning Swell metrics"
  :url "https://github.com/burningswell/metrics"
  :license {:name "Creative Commons Attribution-NonCommercial 3.0"
            :url "http://creativecommons.org/licenses/by-nc/3.0/"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/pedestal "0.1.6"]
                 [iapetos "0.1.6"]
                 [io.prometheus/simpleclient_hotspot "0.0.21"]
                 [org.clojure/clojure "1.9.0-alpha16"]]
  :aliases {"ci" ["do" ["difftest"] ["lint"]]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :min-lein-version "2.4.2"
  :profiles {:dev {:dependencies [[ch.qos.logback/logback-core "1.2.3"]
                                  [ch.qos.logback/logback-classic "1.2.3"]
                                  [clj-http "3.5.0"]
                                  [org.slf4j/log4j-over-slf4j "1.7.25"]
                                  [reloaded.repl "0.2.3"]]
                   :plugins [[jonase/eastwood "0.2.3"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]
                   :resource-paths ["dev" "test-resources"]}})
