(ns burningswell.kafka.client
  (:require [peripheral.core :refer [defcomponent]])
  (:import kafka.admin.AdminUtils
           [kafka.utils ZKStringSerializer$ ZkUtils]
           [org.I0Itec.zkclient ZkClient ZkConnection]))

(defcomponent Client [hosts connect-timeout session-timeout]
  :hosts (or hosts "localhost:2181")
  :connect-timeout (or connect-timeout (* 10 1000))
  :session-timeout (or connect-timeout (* 15 1000))
  :client (ZkClient. hosts session-timeout connect-timeout
                     ZKStringSerializer$/MODULE$) #(.close %)
  :utils (ZkUtils. client (ZkConnection. hosts) false))

(defn client [& [opts]]
  (map->Client opts))

(defn create-topic!
  "Create the Kafka `topic`."
  [client topic & [{:keys [partitions replication]}]]
  (AdminUtils/createTopic
   (:utils client)
   topic
   (or partitions 1)
   (or replication 1)
   (java.util.Properties.)
   kafka.admin.RackAwareMode$Enforced$/MODULE$))

(defn delete-topic!
  "Delete the Kafka `topic`."
  [client topic]
  (AdminUtils/deleteTopic (:utils client) topic))
