(defproject burningswell/kafka "0.1.4"
  :description "The Burning Swell Kafka library"
  :url "https://gitlab.com/burningswell/kafka"
  :license {:name "Eclipse Public License"
            :url "http://www.eclipse.org/legal/epl-v10.html"}
  :deploy-repositories [["releases" :clojars]]
  :dependencies [[burningswell/core "0.0.70"]
                 [burningswell/db "0.3.25"]
                 [burningswell/transit "0.1.3"]
                 [com.damballa/abracad "0.4.13"]
                 [com.taoensso/timbre "4.10.0"]
                 [org.apache.kafka/kafka-clients "1.1.0"]
                 [org.apache.kafka/kafka-streams "1.1.0"]
                 [org.apache.kafka/kafka_2.12 "1.1.0"]
                 [org.clojure/clojure "1.9.0"]
                 [peripheral "0.5.3"]
                 [rads/kafka.transit "0.3.0" :exclusions [org.apache.kafka/kafka_2.11]]]
  :aliases {"ci" ["do" ["clean"] ["difftest"] ["lint"]]
            "consumer" ["run" "-m" "burningswell.kafka.console.consumer"]
            "lint" ["do" ["whitespace-linter"] ["eastwood"]]}
  :aot [burningswell.kafka.console.consumer
        burningswell.kafka.serializer
        burningswell.kafka.deserializer
        burningswell.kafka.serdes.transit]
  :eastwood {:exclude-linters [:constant-test :unused-ret-vals :redefd-vars]}
  :min-lein-version "2.4.2"
  :profiles {:dev {:dependencies [[reloaded.repl "0.2.4"]]
                   :plugins [[jonase/eastwood "0.2.1"]
                             [lein-difftest "2.0.0"]
                             [listora/whitespace-linter "0.1.0"]]}
             :repl {:dependencies [[ch.qos.logback/logback-classic "1.2.3"]]
                    :repl-options {:init-ns user}
                    :source-paths ["dev"]}
             :test {:resource-paths ["test-resources"]}})
