(ns burningswell.kafka.system
  (:refer-clojure :exclude [test])
  (:require [burningswell.kafka.client :as client]
            [burningswell.kafka.cluster :as kafka]
            [burningswell.kafka.consumer :as consumer]
            [burningswell.kafka.producer :as producer]
            [burningswell.zookeeper.cluster :as zookeeper]
            [peripheral.core :refer [defsystem+]]))

(defsystem+ Client
  []
  :client []
  :consumer []
  :producer [])

(defn client
  "Returns a Kafka client system."
  [& [{:keys [client consumer producer] :as config}]]
  (map->Client
   {:client (client/client client)
    :consumer (consumer/consumer consumer)
    :producer (producer/producer producer)}))

(defsystem+ Test
  []
  :consumer [:kafka]
  :kafka [:zookeeper]
  :producer [:kafka]
  :zookeeper [])

(defn test
  "Returns a Kafka test system."
  [& [{:keys [kafka consumer producer zookeeper] :as config}]]
  (let [kafka (kafka/config kafka)
        zookeeper (zookeeper/cluster zookeeper)
        zk-hosts (str "localhost:" (-> zookeeper :config :bind-port))]
    (map->Test
     {:client (client/client {:hosts (str "localhost:" (:bind-port zookeeper))})
      :consumer (consumer/consumer (merge consumer (:config kafka)))
      :kafka (kafka/cluster kafka)
      :producer (producer/producer (merge producer (:config kafka)))
      :zookeeper zookeeper})))
