(ns burningswell.geoip.interceptor
  (:require [burningswell.geoip.core :refer [geocode]]
            [io.pedestal.interceptor :refer [interceptor]]))

(defn geoip
  "Return a GeoIP interceptor."
  [& [{:keys [component path]}]]
  (let [component (or component [:request :geoip])
        path (or path [:request :geoip-result])]
    (interceptor
     {:name ::geoip
      :enter
      (fn [context]
        (if-let [geocoder (get-in context component)]
          (->> (geocode geocoder (-> context :request :remote-addr))
               (assoc-in context path))
          context))})))
