(ns burningswell.geoip.interceptor
  (:require [burningswell.geoip.core :refer [geocode]]
            [io.pedestal.interceptor :refer [interceptor]]))

(defn geoip
  "Return a GeoIP interceptor."
  [& [{:keys [component location]}]]
  (let [component (or component [:request :geoip])
        location (or location [:request :location])]
    (interceptor
     {:name ::geoip
      :enter
      (fn [context]
        (if-let [geocoder (get-in context component)]
          (->> (geocode geocoder (-> context :request :remote-addr))
               (assoc-in context location))
          context))})))
