(ns burningswell.db.specs
  (:require [clojure.spec.alpha :as s]
            [clojure.string :as str]
            [clojure.spec.gen.alpha :as gen]
            [geo.core :refer [point?]]
            [geo.postgis :refer [point]]))

(defn not-blank? [s]
  (not (str/blank? s)))

(s/def ::latitude
  (s/double-in :min -90 :max 90 :NaN? false :infinite? false))

(s/def ::longitude
  (s/double-in :min -180 :max 180 :NaN? false :infinite? false))

(s/def ::location
  (s/with-gen point?
    #(gen/fmap (fn [[x y]] (point 4326 x y))
               (gen/tuple (s/gen ::longitude)
                          (s/gen ::latitude)))))
