(ns burningswell.db.sessions
  (:require [datumbazo.table :as t]))

(t/deftable sessions
  "The surf sessions database table."
  (t/column :created-at :timestamp-with-time-zone :not-null? true :default '(now))
  (t/column :id :serial :primary-key? true)
  (t/column :rating :integer :not-null? true)
  (t/column :spot-id :integer :not-null? true :references :spots/id)
  (t/column :started-at :timestamp-with-time-zone :not-null? true)
  (t/column :stopped-at :timestamp-with-time-zone :not-null? true)
  (t/column :updated-at :timestamp-with-time-zone :not-null? true :default '(now))
  (t/column :user-id :integer :not-null? true :references :users/id))
