(ns burningswell.db.weather.datasources
  (:require [datumbazo.table :as t]))

(t/deftable datasources
  "The weather datasources table."
  (t/table :weather.datasources)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :das :text :not-null? true :unique? true)
  (t/column :dds :text :not-null? true :unique? true)
  (t/column :dods :text :not-null? true :unique? true)
  (t/column :id :serial :primary-key? true)
  (t/column :model-id :integer :not-null? true :references :weather.models/id)
  (t/column :reference-time :timestamp :not-null? true)
  (t/column :updated-at :timestamp :not-null? true))
