(ns burningswell.db.weather.datasets
  (:require [datumbazo.table :as t]))

(t/deftable datasets
  "The weather datasets table."
  (t/table :weather.datasets)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :datasource-id :integer :not-null? true :references :weather.datasources/id)
  (t/column :geotiff-url :citext)
  (t/column :id :serial :primary-key? true)
  (t/column :ingest-finished-at :timestamp-with-time-zone)
  (t/column :ingest-started-at :timestamp-with-time-zone)
  (t/column :updated-at :timestamp :not-null? true)
  (t/column :valid-time :timestamp :not-null? true)
  (t/column :variable-id :integer :not-null? true :references :weather.variables/id))
