(ns burningswell.db.connection
  (:require [clojure.spec.test.alpha :as stest]
            [clojure.string :as str]
            [datumbazo.core :as d]))

(defn- dash [s]
  (keyword (str/replace (name s) "_" "-")))

(defn- underscore [s]
  (str/replace (name s) "-" "_"))

(def default-opts
  {:backend 'jdbc.core
   :sql-keyword dash
   :sql-name underscore})

(defn new-db [config & [opts]]
  (d/new-db config (merge opts default-opts)))

(defmacro with-db
  "Eval `body` within the context of a database."
  [[db-sym config] & body]
  `(d/with-db [~db-sym ~config default-opts]
     ~@body))

(defmacro with-test-db
  "Eval `body` within the context of a database."
  [[db-sym config] & body]
  `(d/with-db [~db-sym ~config default-opts]
     (stest/unstrument)
     (stest/instrument)
     ~@body))
