(ns burningswell.db.cover-photos
  (:gen-class)
  (:require [burningswell.config.core :as config]
            [burningswell.db.connection :refer [with-db]]
            [burningswell.db.continents :as continents]
            [burningswell.db.countries :as countries]
            [burningswell.db.regions :as regions]
            [commandline.core :refer [print-help with-commandline]]
            [environ.core :refer [env]]))

(defn update! [db]
  {:continents (:count (continents/update-photos! db))
   :countries (:count (countries/update-photos! db))
   :photos (:count (regions/update-photos! db))})

(defn -main [& args]
  (with-commandline [[opts [cmd & args]] args]
    [[h help "Print this help."]
     [d directory "Read fixtures from DIRECTORY." :string "DIRECTORY"]]
    (when (:help opts)
      (print-help "cover-photos"))
    (with-db [db (config/db env)]
      (update! db))))

(comment (-main))
