(ns burningswell.db.core)

(defn namespace-map
  "Add the namespace `ns` to all keys of `m`."
  [ns m]
  (when-not (empty? m)
    (->> (for [[k v] m]
           (if (namespace k)
             [k v] [(keyword (name ns) (name k)) v]))
         (into {}))))

(defn namespace-maps
  "Add the namespace `ns` to all keys of the maps `xs`."
  [ns xs]
  (map #(namespace-map ns %) xs))
