-- Revert remove_static_counter_cache_triggers

BEGIN;

CREATE OR REPLACE FUNCTION "update_airport_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_airport_count"();
  PERFORM "update_country_airport_count"();
  PERFORM "update_region_airport_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_airport_counts_on_delete_trigger"
  AFTER DELETE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_airport_counts"();

CREATE TRIGGER "update_airport_counts_on_insert_trigger"
  AFTER INSERT ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_airport_counts"();

CREATE TRIGGER "update_airport_counts_on_update_trigger"
  AFTER UPDATE ON "airports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_airport_counts"();

CREATE OR REPLACE FUNCTION "update_country_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_country_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_country_counts_on_delete_trigger"
  AFTER DELETE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_country_counts"();

CREATE TRIGGER "update_country_counts_on_insert_trigger"
  AFTER INSERT ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_country_counts"();

CREATE TRIGGER "update_country_counts_on_update_trigger"
  AFTER UPDATE ON "countries"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_country_counts"();

CREATE OR REPLACE FUNCTION "update_port_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_port_count"();
  PERFORM "update_country_port_count"();
  PERFORM "update_region_port_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_port_counts_on_delete_trigger"
  AFTER DELETE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_port_counts"();

CREATE TRIGGER "update_port_counts_on_insert_trigger"
  AFTER INSERT ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_port_counts"();

CREATE TRIGGER "update_port_counts_on_update_trigger"
  AFTER UPDATE ON "ports"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_port_counts"();


CREATE OR REPLACE FUNCTION "update_region_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_region_count"();
  PERFORM "update_country_region_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_region_counts_on_delete_trigger"
  AFTER DELETE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_region_counts"();

CREATE TRIGGER "update_region_counts_on_insert_trigger"
  AFTER INSERT ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_region_counts"();

CREATE TRIGGER "update_region_counts_on_update_trigger"
  AFTER UPDATE ON "regions"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_region_counts"();

CREATE OR REPLACE FUNCTION "update_spot_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_spot_count"();
  PERFORM "update_country_spot_count"();
  PERFORM "update_region_spot_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_spot_counts_on_delete_trigger"
  AFTER DELETE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_spot_counts"();

CREATE TRIGGER "update_spot_counts_on_insert_trigger"
  AFTER INSERT ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_spot_counts"();

CREATE TRIGGER "update_spot_counts_on_update_trigger"
  AFTER UPDATE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_spot_counts"();

CREATE OR REPLACE FUNCTION "update_user_counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update_continent_user_count"();
  PERFORM "update_country_user_count"();
  PERFORM "update_region_user_count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update_user_counts_on_delete_trigger"
  AFTER DELETE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_user_counts"();

CREATE TRIGGER "update_user_counts_on_insert_trigger"
  AFTER INSERT ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_user_counts"();

CREATE TRIGGER "update_user_counts_on_update_trigger"
  AFTER UPDATE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update_user_counts"();

COMMIT;
